/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.procedure2.BaseRSProcedureCallable;
import org.apache.hadoop.hbase.replication.regionserver.PeerProcedureHandler;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RefreshPeerCallable
extends BaseRSProcedureCallable {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshPeerCallable.class);
    private String peerId;
    private MasterProcedureProtos.PeerModificationType type;
    private int stage;

    @Override
    protected void doCall() throws Exception {
        LOG.info("Received a peer change event, peerId=" + this.peerId + ", type=" + this.type);
        PeerProcedureHandler handler = this.rs.getReplicationSourceService().getPeerProcedureHandler();
        switch (this.type) {
            case ADD_PEER: {
                handler.addPeer(this.peerId);
                break;
            }
            case REMOVE_PEER: {
                handler.removePeer(this.peerId);
                break;
            }
            case ENABLE_PEER: {
                handler.enablePeer(this.peerId);
                break;
            }
            case DISABLE_PEER: {
                handler.disablePeer(this.peerId);
                break;
            }
            case UPDATE_PEER_CONFIG: {
                handler.updatePeerConfig(this.peerId);
                break;
            }
            case TRANSIT_SYNC_REPLICATION_STATE: {
                handler.transitSyncReplicationPeerState(this.peerId, this.stage, this.rs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown peer modification type: " + this.type);
            }
        }
    }

    @Override
    protected void initParameter(byte[] parameter) throws InvalidProtocolBufferException {
        MasterProcedureProtos.RefreshPeerParameter param = MasterProcedureProtos.RefreshPeerParameter.parseFrom((byte[])parameter);
        this.peerId = param.getPeerId();
        this.type = param.getType();
        this.stage = param.getStage();
    }

    @Override
    public EventType getEventType() {
        return EventType.RS_REFRESH_PEER;
    }
}

