/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.regionreplication;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.io.netty.util.HashedWheelTimer;
import org.apache.hbase.thirdparty.io.netty.util.Timeout;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionReplicationFlushRequester {
    private static volatile HashedWheelTimer TIMER;
    public static final String MIN_INTERVAL_SECS = "hbase.region.read-replica.sink.flush.min-interval.secs";
    public static final int MIN_INTERVAL_SECS_DEFAULT = 30;
    private final Runnable flushRequester;
    private final long minIntervalSecs;
    private long lastRequestNanos;
    private long pendingFlushRequestSequenceId;
    private long lastFlushedSequenceId;
    private Timeout pendingFlushRequest;

    RegionReplicationFlushRequester(Configuration conf, Runnable flushRequester) {
        this.flushRequester = flushRequester;
        this.minIntervalSecs = conf.getInt(MIN_INTERVAL_SECS, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashedWheelTimer getTimer() {
        HashedWheelTimer timer = TIMER;
        if (timer != null) {
            return timer;
        }
        Class<RegionReplicationFlushRequester> clazz = RegionReplicationFlushRequester.class;
        synchronized (RegionReplicationFlushRequester.class) {
            timer = TIMER;
            if (timer != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return timer;
            }
            TIMER = timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("RegionReplicationFlushRequester-Timer-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build(), 500L, TimeUnit.MILLISECONDS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return timer;
        }
    }

    private void request() {
        this.flushRequester.run();
        this.lastRequestNanos = System.nanoTime();
    }

    private synchronized void flush(Timeout timeout) {
        this.pendingFlushRequest = null;
        if (this.pendingFlushRequestSequenceId >= this.lastFlushedSequenceId) {
            this.request();
        }
    }

    synchronized void requestFlush(long sequenceId) {
        if (this.pendingFlushRequest != null) {
            this.pendingFlushRequestSequenceId = Math.max(sequenceId, this.pendingFlushRequestSequenceId);
            return;
        }
        long elapsedSecs = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.lastRequestNanos);
        if (elapsedSecs >= this.minIntervalSecs) {
            this.request();
            return;
        }
        HashedWheelTimer timer = RegionReplicationFlushRequester.getTimer();
        this.pendingFlushRequestSequenceId = sequenceId;
        this.pendingFlushRequest = timer.newTimeout(this::flush, this.minIntervalSecs - elapsedSecs, TimeUnit.SECONDS);
    }

    synchronized void recordFlush(long sequenceId) {
        this.lastFlushedSequenceId = sequenceId;
        if (sequenceId > this.pendingFlushRequestSequenceId && this.pendingFlushRequest != null) {
            this.pendingFlushRequest.cancel();
            this.pendingFlushRequest = null;
        }
    }
}

