/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.replication.AbstractPeerNoLockProcedure;
import org.apache.hadoop.hbase.master.replication.SyncReplicationReplayWALManager;
import org.apache.hadoop.hbase.master.replication.SyncReplicationReplayWALRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SyncReplicationReplayWALProcedure
extends AbstractPeerNoLockProcedure<MasterProcedureProtos.SyncReplicationReplayWALState> {
    private static final Logger LOG = LoggerFactory.getLogger(SyncReplicationReplayWALProcedure.class);
    private ServerName worker = null;
    private List<String> wals;

    public SyncReplicationReplayWALProcedure() {
    }

    public SyncReplicationReplayWALProcedure(String peerId, List<String> wals) {
        this.peerId = peerId;
        this.wals = wals;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.SyncReplicationReplayWALState state) throws ProcedureSuspendedException {
        SyncReplicationReplayWALManager syncReplicationReplayWALManager = env.getMasterServices().getSyncReplicationReplayWALManager();
        switch (state) {
            case ASSIGN_WORKER: {
                this.worker = syncReplicationReplayWALManager.acquirePeerWorker(this.peerId, (Procedure<?>)this);
                this.setNextState(MasterProcedureProtos.SyncReplicationReplayWALState.DISPATCH_WALS_TO_WORKER);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case DISPATCH_WALS_TO_WORKER: {
                this.addChildProcedure(new SyncReplicationReplayWALRemoteProcedure[]{new SyncReplicationReplayWALRemoteProcedure(this.peerId, this.wals, this.worker)});
                this.setNextState(MasterProcedureProtos.SyncReplicationReplayWALState.RELEASE_WORKER);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case RELEASE_WORKER: {
                boolean finished = false;
                try {
                    finished = syncReplicationReplayWALManager.isReplayWALFinished(this.wals.get(0));
                }
                catch (IOException e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("Failed to check whether replay wals {} finished for peer id={}, sleep {} secs and retry", new Object[]{this.wals, this.peerId, backoff / 1000L, e}));
                }
                syncReplicationReplayWALManager.releasePeerWorker(this.peerId, this.worker, env.getProcedureScheduler());
                if (!finished) {
                    LOG.warn("Failed to replay wals {} for peer id={}, retry", this.wals, (Object)this.peerId);
                    this.setNextState(MasterProcedureProtos.SyncReplicationReplayWALState.ASSIGN_WORKER);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.SyncReplicationReplayWALState state) throws IOException, InterruptedException {
        if (state == this.getInitialState()) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    protected MasterProcedureProtos.SyncReplicationReplayWALState getState(int state) {
        return MasterProcedureProtos.SyncReplicationReplayWALState.forNumber((int)state);
    }

    protected int getStateId(MasterProcedureProtos.SyncReplicationReplayWALState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.SyncReplicationReplayWALState getInitialState() {
        return MasterProcedureProtos.SyncReplicationReplayWALState.ASSIGN_WORKER;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.SyncReplicationReplayWALStateData.Builder builder = MasterProcedureProtos.SyncReplicationReplayWALStateData.newBuilder().setPeerId(this.peerId).addAllWal(this.wals);
        if (this.worker != null) {
            builder.setWorker(ProtobufUtil.toServerName((ServerName)this.worker));
        }
        serializer.serialize((Message)builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.SyncReplicationReplayWALStateData data = (MasterProcedureProtos.SyncReplicationReplayWALStateData)serializer.deserialize(MasterProcedureProtos.SyncReplicationReplayWALStateData.class);
        this.peerId = data.getPeerId();
        this.wals = data.getWalList();
        if (data.hasWorker()) {
            this.worker = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getWorker());
        }
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.SYNC_REPLICATION_REPLAY_WAL;
    }

    protected void afterReplay(MasterProcedureEnv env) {
        if (this.worker != null && !this.isFinished()) {
            env.getMasterServices().getSyncReplicationReplayWALManager().addUsedPeerWorker(this.peerId, this.worker);
        }
    }
}

