/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.http;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hadoop.hbase.CatalogFamilyFormat;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateStore;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RegionReplicaInfo {
    private final byte[] row;
    private final RegionInfo regionInfo;
    private final RegionState.State regionState;
    private final ServerName serverName;
    private final long seqNum;
    private final ServerName targetServerName;
    private final Map<String, RegionInfo> mergeRegionInfo;
    private final Map<String, RegionInfo> splitRegionInfo;

    private RegionReplicaInfo(Result result, HRegionLocation location) {
        this.row = result != null ? result.getRow() : null;
        this.regionInfo = location != null ? location.getRegion() : null;
        this.regionState = result != null && this.regionInfo != null ? RegionStateStore.getRegionState(result, this.regionInfo) : null;
        this.serverName = location != null ? location.getServerName() : null;
        this.seqNum = location != null ? location.getSeqNum() : -1L;
        this.targetServerName = result != null && this.regionInfo != null ? MetaTableAccessor.getTargetServerName(result, this.regionInfo.getReplicaId()) : null;
        Map<String, RegionInfo> map = this.mergeRegionInfo = result != null ? CatalogFamilyFormat.getMergeRegionsWithName((Cell[])result.rawCells()) : null;
        if (result != null) {
            PairOfSameType<RegionInfo> daughterRegions = MetaTableAccessor.getDaughterRegions(result);
            this.splitRegionInfo = new LinkedHashMap<String, RegionInfo>();
            if (daughterRegions.getFirst() != null) {
                this.splitRegionInfo.put("splitA", (RegionInfo)daughterRegions.getFirst());
            }
            if (daughterRegions.getSecond() != null) {
                this.splitRegionInfo.put("splitB", (RegionInfo)daughterRegions.getSecond());
            }
        } else {
            this.splitRegionInfo = null;
        }
    }

    public static List<RegionReplicaInfo> from(Result result) {
        if (result == null) {
            return Collections.singletonList(null);
        }
        RegionLocations locations = CatalogFamilyFormat.getRegionLocations((Result)result);
        if (locations == null) {
            return Collections.singletonList(null);
        }
        return StreamSupport.stream(locations.spliterator(), false).map(location -> new RegionReplicaInfo(result, (HRegionLocation)location)).collect(Collectors.toList());
    }

    public byte[] getRow() {
        return this.row;
    }

    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public byte[] getRegionName() {
        return this.regionInfo != null ? this.regionInfo.getRegionName() : null;
    }

    public byte[] getStartKey() {
        return this.regionInfo != null ? this.regionInfo.getStartKey() : null;
    }

    public byte[] getEndKey() {
        return this.regionInfo != null ? this.regionInfo.getEndKey() : null;
    }

    public Integer getReplicaId() {
        return this.regionInfo != null ? Integer.valueOf(this.regionInfo.getReplicaId()) : null;
    }

    public RegionState.State getRegionState() {
        return this.regionState;
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    public ServerName getTargetServerName() {
        return this.targetServerName;
    }

    public Map<String, RegionInfo> getMergeRegionInfo() {
        return this.mergeRegionInfo;
    }

    public Map<String, RegionInfo> getSplitRegionInfo() {
        return this.splitRegionInfo;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RegionReplicaInfo that = (RegionReplicaInfo)other;
        return new EqualsBuilder().append(this.row, that.row).append((Object)this.regionInfo, (Object)that.regionInfo).append((Object)this.regionState, (Object)that.regionState).append((Object)this.serverName, (Object)that.serverName).append(this.seqNum, that.seqNum).append((Object)this.targetServerName, (Object)that.targetServerName).append(this.mergeRegionInfo, that.mergeRegionInfo).append(this.splitRegionInfo, that.splitRegionInfo).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.row).append((Object)this.regionInfo).append((Object)this.regionState).append((Object)this.serverName).append(this.seqNum).append((Object)this.targetServerName).append(this.mergeRegionInfo).append(this.splitRegionInfo).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("row", (Object)Bytes.toStringBinary((byte[])this.row)).append("regionInfo", (Object)this.regionInfo).append("regionState", (Object)this.regionState).append("serverName", (Object)this.serverName).append("seqNum", this.seqNum).append("transitioningOnServerName", (Object)this.targetServerName).append("merge*", this.mergeRegionInfo).append("split*", this.splitRegionInfo).toString();
    }
}

