/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.ClusterInfoProvider;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MaintenanceLoadBalancer
implements LoadBalancer {
    private volatile boolean stopped = false;

    public void stop(String why) {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void updateClusterMetrics(ClusterMetrics st) {
    }

    public void setClusterInfoProvider(ClusterInfoProvider provider) {
    }

    public List<RegionPlan> balanceCluster(Map<TableName, Map<ServerName, List<RegionInfo>>> loadOfAllTable) throws IOException {
        return Collections.emptyList();
    }

    private Map<ServerName, List<RegionInfo>> assign(Collection<RegionInfo> regions, List<ServerName> servers) {
        assert (servers.size() == 1);
        List systemRegions = regions.stream().filter(r -> r.getTable().isSystemTable()).collect(Collectors.toList());
        if (!systemRegions.isEmpty()) {
            return Collections.singletonMap(servers.get(0), systemRegions);
        }
        return Collections.emptyMap();
    }

    public Map<ServerName, List<RegionInfo>> roundRobinAssignment(List<RegionInfo> regions, List<ServerName> servers) throws IOException {
        return this.assign(regions, servers);
    }

    public Map<ServerName, List<RegionInfo>> retainAssignment(Map<RegionInfo, ServerName> regions, List<ServerName> servers) throws IOException {
        return this.assign(regions.keySet(), servers);
    }

    public ServerName randomAssignment(RegionInfo regionInfo, List<ServerName> servers) throws IOException {
        assert (servers.size() == 1);
        return regionInfo.getTable().isSystemTable() ? servers.get(0) : null;
    }

    public void initialize() {
    }

    public void regionOnline(RegionInfo regionInfo, ServerName sn) {
    }

    public void regionOffline(RegionInfo regionInfo) {
    }

    public void onConfigurationChange(Configuration conf) {
    }

    public void postMasterStartupInitialize() {
    }

    public void updateBalancerStatus(boolean status) {
    }
}

