/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.assignment.GCRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@Deprecated
public class GCMergedRegionsProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.GCMergedRegionsState> {
    private static final Logger LOG = LoggerFactory.getLogger(GCMergedRegionsProcedure.class);
    private RegionInfo father;
    private RegionInfo mother;
    private RegionInfo mergedChild;

    public GCMergedRegionsProcedure(MasterProcedureEnv env, RegionInfo mergedChild, RegionInfo father, RegionInfo mother) {
        super(env);
        this.father = father;
        this.mother = mother;
        this.mergedChild = mergedChild;
    }

    public GCMergedRegionsProcedure() {
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.MERGED_REGIONS_GC;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.GCMergedRegionsState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " execute state=" + state);
        }
        try {
            switch (state) {
                case GC_MERGED_REGIONS_PREPARE: {
                    this.setNextState(MasterProcedureProtos.GCMergedRegionsState.GC_MERGED_REGIONS_PURGE);
                    break;
                }
                case GC_MERGED_REGIONS_PURGE: {
                    this.addChildProcedure((Procedure[])this.createGCRegionProcedures(env));
                    this.setNextState(MasterProcedureProtos.GCMergedRegionsState.GC_REGION_EDIT_METADATA);
                    break;
                }
                case GC_REGION_EDIT_METADATA: {
                    env.getAssignmentManager().getRegionStateStore().deleteMergeQualifiers(this.mergedChild);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException ioe) {
            LOG.warn("Error trying to GC merged regions " + this.father.getShortNameToLog() + " & " + this.mother.getShortNameToLog() + "; retrying...", (Throwable)ioe);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private GCRegionProcedure[] createGCRegionProcedures(MasterProcedureEnv env) {
        GCRegionProcedure[] procs = new GCRegionProcedure[2];
        int index = 0;
        for (RegionInfo hri : new RegionInfo[]{this.father, this.mother}) {
            GCRegionProcedure proc = new GCRegionProcedure(env, hri);
            proc.setOwner(env.getRequestUser().getShortName());
            procs[index++] = proc;
        }
        return procs;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.GCMergedRegionsState state) throws IOException, InterruptedException {
    }

    protected MasterProcedureProtos.GCMergedRegionsState getState(int stateId) {
        return MasterProcedureProtos.GCMergedRegionsState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.GCMergedRegionsState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.GCMergedRegionsState getInitialState() {
        return MasterProcedureProtos.GCMergedRegionsState.GC_MERGED_REGIONS_PREPARE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.GCMergedRegionsStateData.Builder msg = MasterProcedureProtos.GCMergedRegionsStateData.newBuilder().setParentA(ProtobufUtil.toRegionInfo((RegionInfo)this.father)).setParentB(ProtobufUtil.toRegionInfo((RegionInfo)this.mother)).setMergedChild(ProtobufUtil.toRegionInfo((RegionInfo)this.mergedChild));
        serializer.serialize((Message)msg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.GCMergedRegionsStateData msg = (MasterProcedureProtos.GCMergedRegionsStateData)serializer.deserialize(MasterProcedureProtos.GCMergedRegionsStateData.class);
        this.father = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)msg.getParentA());
        this.mother = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)msg.getParentB());
        this.mergedChild = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)msg.getMergedChild());
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" child=");
        sb.append(this.mergedChild.getShortNameToLog());
        sb.append(", father=");
        sb.append(this.father.getShortNameToLog());
        sb.append(", mother=");
        sb.append(this.mother.getShortNameToLog());
    }

    @Override
    public TableName getTableName() {
        return this.mergedChild.getTable();
    }
}

