/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public final class ClientTokenUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClientTokenUtil.class);
    private static ServiceException injectedException;

    private ClientTokenUtil() {
    }

    private static void injectFault() throws ServiceException {
        if (injectedException != null) {
            throw injectedException;
        }
    }

    @InterfaceAudience.Private
    public static CompletableFuture<Token<AuthenticationTokenIdentifier>> obtainToken(AsyncConnection conn) {
        CompletableFuture<Token<AuthenticationTokenIdentifier>> future = new CompletableFuture<Token<AuthenticationTokenIdentifier>>();
        if (injectedException != null) {
            future.completeExceptionally(ProtobufUtil.handleRemoteException(injectedException));
            return future;
        }
        AsyncTable<AdvancedScanResultConsumer> table = conn.getTable(TableName.META_TABLE_NAME);
        table.coprocessorService(AuthenticationProtos.AuthenticationService::newStub, (s, c, r) -> s.getAuthenticationToken(c, AuthenticationProtos.GetAuthenticationTokenRequest.getDefaultInstance(), r), HConstants.EMPTY_START_ROW).whenComplete((resp, error) -> {
            if (error != null) {
                future.completeExceptionally(ProtobufUtil.handleRemoteException(error));
            } else {
                future.complete(ClientTokenUtil.toToken(resp.getToken()));
            }
        });
        return future;
    }

    @InterfaceAudience.Private
    static Token<AuthenticationTokenIdentifier> obtainToken(Connection conn) throws IOException {
        try (Table meta = null;){
            ClientTokenUtil.injectFault();
            meta = conn.getTable(TableName.META_TABLE_NAME);
            CoprocessorRpcChannel rpcChannel = meta.coprocessorService(HConstants.EMPTY_START_ROW);
            AuthenticationProtos.AuthenticationService.BlockingInterface service = AuthenticationProtos.AuthenticationService.newBlockingStub((BlockingRpcChannel)rpcChannel);
            AuthenticationProtos.GetAuthenticationTokenResponse response = service.getAuthenticationToken(null, AuthenticationProtos.GetAuthenticationTokenRequest.getDefaultInstance());
            Token<AuthenticationTokenIdentifier> token = ClientTokenUtil.toToken(response.getToken());
            return token;
        }
    }

    @InterfaceAudience.Private
    static AuthenticationProtos.Token toToken(Token<AuthenticationTokenIdentifier> token) {
        AuthenticationProtos.Token.Builder builder = AuthenticationProtos.Token.newBuilder();
        builder.setIdentifier(ByteString.copyFrom((byte[])token.getIdentifier()));
        builder.setPassword(ByteString.copyFrom((byte[])token.getPassword()));
        if (token.getService() != null) {
            builder.setService(ByteString.copyFromUtf8((String)token.getService().toString()));
        }
        return builder.build();
    }

    @InterfaceAudience.Private
    static Token<AuthenticationTokenIdentifier> toToken(AuthenticationProtos.Token proto) {
        return new Token(proto.hasIdentifier() ? proto.getIdentifier().toByteArray() : null, proto.hasPassword() ? proto.getPassword().toByteArray() : null, AuthenticationTokenIdentifier.AUTH_TOKEN_TYPE, proto.hasService() ? new Text(proto.getService().toStringUtf8()) : null);
    }

    @InterfaceAudience.Private
    static Token<AuthenticationTokenIdentifier> obtainToken(final Connection conn, User user) throws IOException, InterruptedException {
        return (Token)user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<AuthenticationTokenIdentifier>>(){

            @Override
            public Token<AuthenticationTokenIdentifier> run() throws Exception {
                return ClientTokenUtil.obtainToken(conn);
            }
        });
    }

    public static void obtainAndCacheToken(Connection conn, User user) throws IOException, InterruptedException {
        try {
            Token<AuthenticationTokenIdentifier> token = ClientTokenUtil.obtainToken(conn, user);
            if (token == null) {
                throw new IOException("No token returned for user " + user.getName());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Obtained token " + token.getKind().toString() + " for user " + user.getName());
            }
            user.addToken(token);
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getName());
        }
    }
}

