/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CatalogFamilyFormat {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogFamilyFormat.class);
    private static final Pattern SERVER_COLUMN_PATTERN = Pattern.compile("^server(_[0-9a-fA-F]{4})?$");
    static final char META_REPLICA_ID_DELIMITER = '_';

    public static RegionInfo parseRegionInfoFromRegionName(byte[] regionName) throws IOException {
        byte[][] fields = RegionInfo.parseRegionName(regionName);
        long regionId = Long.parseLong(Bytes.toString((byte[])fields[2]));
        int replicaId = fields.length > 3 ? Integer.parseInt(Bytes.toString((byte[])fields[3]), 16) : 0;
        return RegionInfoBuilder.newBuilder(TableName.valueOf((byte[])fields[0])).setStartKey(fields[1]).setRegionId(regionId).setReplicaId(replicaId).build();
    }

    @Nullable
    public static RegionInfo getRegionInfo(Result r, byte[] qualifier) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, qualifier);
        if (cell == null) {
            return null;
        }
        return RegionInfo.parseFromOrNull(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static RegionInfo getRegionInfo(Result data) {
        return CatalogFamilyFormat.getRegionInfo(data, HConstants.REGIONINFO_QUALIFIER);
    }

    public static HRegionLocation getRegionLocation(Result r, RegionInfo regionInfo, int replicaId) {
        ServerName serverName = CatalogFamilyFormat.getServerName(r, replicaId);
        long seqNum = CatalogFamilyFormat.getSeqNumDuringOpen(r, replicaId);
        RegionInfo replicaInfo = RegionReplicaUtil.getRegionInfoForReplica(regionInfo, replicaId);
        return new HRegionLocation(replicaInfo, serverName, seqNum);
    }

    @Nullable
    public static RegionLocations getRegionLocations(Result r) {
        Map.Entry entry;
        if (r == null) {
            return null;
        }
        RegionInfo regionInfo = CatalogFamilyFormat.getRegionInfo(r, HConstants.REGIONINFO_QUALIFIER);
        if (regionInfo == null) {
            return null;
        }
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>(1);
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyMap = r.getNoVersionMap();
        locations.add(CatalogFamilyFormat.getRegionLocation(r, regionInfo, 0));
        NavigableMap infoMap = (NavigableMap)familyMap.get(HConstants.CATALOG_FAMILY);
        if (infoMap == null) {
            return new RegionLocations(locations);
        }
        int replicaId = 0;
        byte[] serverColumn = CatalogFamilyFormat.getServerColumn(replicaId);
        NavigableMap serverMap = infoMap.tailMap(serverColumn, false);
        if (serverMap.isEmpty()) {
            return new RegionLocations(locations);
        }
        Iterator iterator = serverMap.entrySet().iterator();
        while (iterator.hasNext() && (replicaId = CatalogFamilyFormat.parseReplicaIdFromServerColumn((byte[])(entry = iterator.next()).getKey())) >= 0) {
            HRegionLocation location = CatalogFamilyFormat.getRegionLocation(r, regionInfo, replicaId);
            if (location.getServerName() == null) {
                locations.add(null);
                continue;
            }
            locations.add(location);
        }
        return new RegionLocations(locations);
    }

    @Nullable
    public static ServerName getServerName(Result r, int replicaId) {
        byte[] serverColumn = CatalogFamilyFormat.getServerColumn(replicaId);
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, serverColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        String hostAndPort = Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
        byte[] startcodeColumn = CatalogFamilyFormat.getStartCodeColumn(replicaId);
        cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, startcodeColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        try {
            return ServerName.valueOf((String)hostAndPort, (long)Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Ignoring invalid region for server " + hostAndPort + "; cell=" + cell, (Throwable)e);
            return null;
        }
    }

    public static byte[] getServerColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVER_QUALIFIER : Bytes.toBytes((String)("server_" + String.format("%04X", replicaId)));
    }

    public static byte[] getStartCodeColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STARTCODE_QUALIFIER : Bytes.toBytes((String)("serverstartcode_" + String.format("%04X", replicaId)));
    }

    private static long getSeqNumDuringOpen(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getSeqNumColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return -1L;
        }
        return Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
    }

    public static byte[] getSeqNumColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SEQNUM_QUALIFIER : Bytes.toBytes((String)("seqnumDuringOpen_" + String.format("%04X", replicaId)));
    }

    static int parseReplicaIdFromServerColumn(byte[] serverColumn) {
        String serverStr = Bytes.toString((byte[])serverColumn);
        Matcher matcher = SERVER_COLUMN_PATTERN.matcher(serverStr);
        if (matcher.matches() && matcher.groupCount() > 0) {
            String group = matcher.group(1);
            if (group != null && group.length() > 0) {
                return Integer.parseInt(group.substring(1), 16);
            }
            return 0;
        }
        return -1;
    }

    public static byte[] getMetaKeyForRegion(RegionInfo regionInfo) {
        return RegionReplicaUtil.getRegionInfoForDefaultReplica(regionInfo).getRegionName();
    }

    public static byte[] getRegionStateColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STATE_QUALIFIER : Bytes.toBytes((String)("state_" + String.format("%04X", replicaId)));
    }

    public static byte[] getServerNameColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVERNAME_QUALIFIER : Bytes.toBytes((String)("sn_" + String.format("%04X", replicaId)));
    }

    @Nullable
    public static TableState getTableState(Result r) throws IOException {
        Cell cell = r.getColumnLatestCell(HConstants.TABLE_FAMILY, HConstants.TABLE_STATE_QUALIFIER);
        if (cell == null) {
            return null;
        }
        try {
            return TableState.parseFrom(TableName.valueOf((byte[])r.getRow()), Arrays.copyOfRange(cell.getValueArray(), cell.getValueOffset(), cell.getValueOffset() + cell.getValueLength()));
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    @Nullable
    public static Map<String, RegionInfo> getMergeRegionsWithName(Cell[] cells) {
        if (cells == null) {
            return null;
        }
        LinkedHashMap<String, RegionInfo> regionsToMerge = null;
        for (Cell cell : cells) {
            RegionInfo ri;
            if (!CatalogFamilyFormat.isMergeQualifierPrefix(cell) || (ri = RegionInfo.parseFromOrNull(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength())) == null) continue;
            if (regionsToMerge == null) {
                regionsToMerge = new LinkedHashMap<String, RegionInfo>();
            }
            regionsToMerge.put(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell)), ri);
        }
        return regionsToMerge;
    }

    @Nullable
    public static List<RegionInfo> getMergeRegions(Cell[] cells) {
        Map<String, RegionInfo> mergeRegionsWithName = CatalogFamilyFormat.getMergeRegionsWithName(cells);
        return mergeRegionsWithName == null ? null : new ArrayList<RegionInfo>(mergeRegionsWithName.values());
    }

    public static boolean hasMergeRegions(Cell[] cells) {
        for (Cell cell : cells) {
            if (!CatalogFamilyFormat.isMergeQualifierPrefix(cell)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMergeQualifierPrefix(Cell cell) {
        return CellUtil.matchingFamily((Cell)cell, (byte[])HConstants.CATALOG_FAMILY) && PrivateCellUtil.qualifierStartsWith((Cell)cell, (byte[])HConstants.MERGE_QUALIFIER_PREFIX);
    }
}

