/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.sps;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.sps.BlockMovementListener;
import org.apache.hadoop.hdfs.server.namenode.sps.BlockStorageMovementAttemptedItems;
import org.apache.hadoop.hdfs.server.namenode.sps.Context;
import org.apache.hadoop.hdfs.server.namenode.sps.SPSService;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.sps.ExternalSPSContext;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExternalStoragePolicySatisfier {
    private static final String ONE_SSD = "ONE_SSD";
    private static final String COLD = "COLD";
    private StorageType[][] allDiskTypes = new StorageType[][]{{StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}};
    private File keytabFile;
    private String principal;
    private MiniKdc kdc;
    private File baseDir;
    private NameNodeConnector nnc;
    private StoragePolicySatisfier externalSps;
    private ExternalSPSContext externalCtxt;
    private DistributedFileSystem dfs = null;
    private MiniDFSCluster hdfsCluster = null;
    private Configuration config = null;
    private static final int NUM_OF_DATANODES = 3;
    private static final int STORAGES_PER_DATANODE = 2;
    private static final long CAPACITY = 0x20000000L;
    private static final String FILE = "/testMoveToSatisfyStoragePolicy";
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    private static final Logger LOG = LoggerFactory.getLogger(TestExternalStoragePolicySatisfier.class);

    @Before
    public void setUp() {
        this.config = new HdfsConfiguration();
        this.config.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        this.config.setLong("dfs.storage.policy.satisfier.datanode.cache.refresh.interval.ms", 3000L);
        this.config.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
    }

    @After
    public void destroy() throws Exception {
        if (this.kdc != null) {
            this.kdc.stop();
            FileUtil.fullyDelete((File)this.baseDir);
        }
        if (this.hdfsCluster != null) {
            this.hdfsCluster.shutdown();
        }
    }

    private void setCluster(MiniDFSCluster cluster) {
        this.hdfsCluster = cluster;
    }

    private Configuration getConf() {
        return this.config;
    }

    private MiniDFSCluster getCluster() {
        return this.hdfsCluster;
    }

    private DistributedFileSystem getFS() throws IOException {
        this.dfs = this.hdfsCluster.getFileSystem();
        return this.dfs;
    }

    private void shutdownCluster() {
        if (this.externalSps != null) {
            this.externalSps.stopGracefully();
        }
    }

    private void stopExternalSps() {
        if (this.externalSps != null) {
            this.externalSps.stopGracefully();
        }
    }

    private void startExternalSps() {
        this.externalSps = new StoragePolicySatisfier(this.getConf());
        this.externalCtxt = new ExternalSPSContext((SPSService)this.externalSps, this.nnc);
        this.externalSps.init((Context)this.externalCtxt);
        this.externalSps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
    }

    private void createCluster() throws IOException {
        this.getConf().setLong("dfs.block.size", 1024L);
        this.setCluster(this.startCluster(this.getConf(), this.allDiskTypes, 3, 2, 0x20000000L));
        this.getFS();
        this.writeContent(FILE);
    }

    private MiniDFSCluster startCluster(Configuration conf, StorageType[][] storageTypes, int numberOfDatanodes, int storagesPerDn, long nodeCapacity) throws IOException {
        long[][] capacities = new long[numberOfDatanodes][storagesPerDn];
        for (int i = 0; i < numberOfDatanodes; ++i) {
            for (int j = 0; j < storagesPerDn; ++j) {
                capacities[i][j] = nodeCapacity;
            }
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numberOfDatanodes).storagesPerDatanode(storagesPerDn).storageTypes(storageTypes).storageCapacities(capacities).build();
        cluster.waitActive();
        this.nnc = DFSTestUtil.getNameNodeConnector(this.getConf(), HdfsServerConstants.MOVER_ID_PATH, 1, false);
        this.externalSps = new StoragePolicySatisfier(this.getConf());
        this.externalCtxt = new ExternalSPSContext((SPSService)this.externalSps, this.nnc);
        this.externalSps.init((Context)this.externalCtxt);
        this.externalSps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
        return cluster;
    }

    private void restartNamenode() throws IOException {
        if (this.externalSps != null) {
            this.externalSps.stopGracefully();
        }
        this.getCluster().restartNameNodes();
        this.getCluster().waitActive();
        this.externalSps = new StoragePolicySatisfier(this.getConf());
        this.externalCtxt = new ExternalSPSContext((SPSService)this.externalSps, this.nnc);
        this.externalSps.init((Context)this.externalCtxt);
        this.externalSps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
    }

    private void initSecureConf(Configuration conf) throws Exception {
        String username = "externalSPS";
        this.baseDir = GenericTestUtils.getTestDir((String)TestExternalStoragePolicySatisfier.class.getSimpleName());
        FileUtil.fullyDelete((File)this.baseDir);
        Assert.assertTrue((boolean)this.baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        this.kdc = new MiniKdc(kdcConf, this.baseDir);
        this.kdc.start();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        KerberosName.resetDefaultRealm();
        Assert.assertTrue((String)"Expected configuration to enable security", (boolean)UserGroupInformation.isSecurityEnabled());
        this.keytabFile = new File(this.baseDir, username + ".keytab");
        String keytab = this.keytabFile.getAbsolutePath();
        String krbInstance = Path.WINDOWS ? "127.0.0.1" : "localhost";
        this.principal = username + "/" + krbInstance + "@" + this.kdc.getRealm();
        String spnegoPrincipal = "HTTP/" + krbInstance + "@" + this.kdc.getRealm();
        this.kdc.createPrincipal(this.keytabFile, new String[]{username, username + "/" + krbInstance, "HTTP/" + krbInstance});
        conf.set("dfs.namenode.kerberos.principal", this.principal);
        conf.set("dfs.namenode.keytab.file", keytab);
        conf.set("dfs.datanode.kerberos.principal", this.principal);
        conf.set("dfs.datanode.keytab.file", keytab);
        conf.set("dfs.web.authentication.kerberos.principal", spnegoPrincipal);
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.data.transfer.protection", "authentication");
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        conf.setInt("ipc.client.connect.max.retries.on.sasl", 10);
        conf.set("dfs.storage.policy.satisfier.address", "localhost:0");
        conf.set("dfs.storage.policy.satisfier.keytab.file", keytab);
        conf.set("dfs.storage.policy.satisfier.kerberos.principal", this.principal);
        String keystoresDir = this.baseDir.getAbsolutePath();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestExternalStoragePolicySatisfier.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        conf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
        conf.setInt("dfs.bytes-per-checksum", 1024);
        conf.setLong("dfs.heartbeat.interval", 1L);
    }

    @Test(timeout=300000L)
    public void testWithKeytabs() throws Exception {
        try {
            this.initSecureConf(this.getConf());
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.principal, (String)this.keytabFile.getAbsolutePath());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestExternalStoragePolicySatisfier.this.testWhenStoragePolicySetToALLSSD();
                    Assert.assertTrue((boolean)UserGroupInformation.isLoginKeytabBased());
                    return null;
                }
            });
        }
        finally {
            UserGroupInformation.reset();
            UserGroupInformation.setConfiguration((Configuration)new Configuration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testOutstandingQueueLimitExceeds() throws Exception {
        try {
            this.getConf().setInt("dfs.storage.policy.satisfier.max.outstanding.paths", 3);
            this.createCluster();
            ArrayList<String> files = new ArrayList<String>();
            files.add(FILE);
            DistributedFileSystem fs = this.getFS();
            this.externalSps.stopGracefully();
            for (int i = 0; i < 3; ++i) {
                String file1 = "/testOutstandingQueueLimitExceeds_" + i;
                files.add(file1);
                this.writeContent(file1);
                fs.satisfyStoragePolicy(new Path(file1));
            }
            String fileExceeds = "/testOutstandingQueueLimitExceeds_4";
            files.add(fileExceeds);
            this.writeContent(fileExceeds);
            try {
                fs.satisfyStoragePolicy(new Path(fileExceeds));
                Assert.fail((String)"Should throw exception as it exceeds outstanding SPS call Q limit");
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"Outstanding satisfier queue limit: 3 exceeded, try later!", (Throwable)ioe);
            }
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testWhenMoverExitsWithoutDeleteMoverIDFile() throws IOException {
        try {
            this.createCluster();
            DFSTestUtil.createFile((FileSystem)this.getCluster().getFileSystem(), HdfsServerConstants.MOVER_ID_PATH, 0L, (short)1, 0L);
            this.restartNamenode();
            boolean running = this.externalCtxt.isRunning();
            Assert.assertTrue((String)"SPS should be running as no Mover really running", (boolean)running);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Ignore(value="ExternalFileIdCollector is not batch based right now. So, ignoring it.")
    public void testBatchProcessingForSPSDirectory() throws Exception {
    }

    @Ignore(value="This test is specific to internal, so skipping here.")
    public void testWhenMoverIsAlreadyRunningBeforeStoragePolicySatisfier() throws Exception {
    }

    @Ignore(value="This test is specific to internal SPS. So, ignoring it.")
    public void testTraverseWhenParentDeleted() throws Exception {
    }

    @Ignore(value="This test is specific to internal SPS. So, ignoring it.")
    public void testTraverseWhenRootParentDeleted() throws Exception {
    }

    @Test(timeout=300000L)
    public void testWhenStoragePolicySetToCOLD() throws Exception {
        try {
            this.createCluster();
            this.doTestWhenStoragePolicySetToCOLD();
        }
        finally {
            this.shutdownCluster();
        }
    }

    private void doTestWhenStoragePolicySetToCOLD() throws Exception {
        this.dfs.setStoragePolicy(new Path(FILE), COLD);
        StorageType[][] newtypes = new StorageType[][]{{StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}};
        this.startAdditionalDNs(this.config, 3, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
        this.hdfsCluster.triggerHeartbeats();
        this.dfs.satisfyStoragePolicy(new Path(FILE));
        DFSTestUtil.waitExpectedStorageType(FILE, StorageType.ARCHIVE, 3, 35000, this.dfs);
    }

    @Test(timeout=300000L)
    public void testWhenStoragePolicySetToALLSSD() throws Exception {
        try {
            this.createCluster();
            this.dfs.setStoragePolicy(new Path(FILE), "ALL_SSD");
            StorageType[][] newtypes = new StorageType[][]{{StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}};
            this.startAdditionalDNs(this.config, 3, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
            this.dfs.satisfyStoragePolicy(new Path(FILE));
            this.hdfsCluster.triggerHeartbeats();
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.SSD, 3, 30000, this.dfs);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testWhenStoragePolicySetToONESSD() throws Exception {
        try {
            this.createCluster();
            this.dfs.setStoragePolicy(new Path(FILE), ONE_SSD);
            StorageType[][] newtypes = new StorageType[][]{{StorageType.SSD, StorageType.DISK}};
            this.startAdditionalDNs(this.config, 1, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
            this.dfs.satisfyStoragePolicy(new Path(FILE));
            this.hdfsCluster.triggerHeartbeats();
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.SSD, 1, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.DISK, 2, 30000, this.dfs);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testBlksStorageMovementAttemptFinishedReport() throws Exception {
        try {
            this.createCluster();
            this.dfs.setStoragePolicy(new Path(FILE), ONE_SSD);
            StorageType[][] newtypes = new StorageType[][]{{StorageType.SSD, StorageType.DISK}};
            this.startAdditionalDNs(this.config, 1, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
            this.dfs.satisfyStoragePolicy(new Path(FILE));
            this.hdfsCluster.triggerHeartbeats();
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.SSD, 1, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.DISK, 2, 30000, this.dfs);
            this.waitForBlocksMovementAttemptReport(1L, 30000);
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMultipleFilesForSatisfyStoragePolicy() throws Exception {
        try {
            this.createCluster();
            ArrayList<String> files = new ArrayList<String>();
            files.add(FILE);
            for (int i = 0; i < 4; ++i) {
                String file1 = "/testMoveWhenStoragePolicyNotSatisfying_" + i;
                files.add(file1);
                this.writeContent(file1);
            }
            for (String fileName : files) {
                this.dfs.setStoragePolicy(new Path(fileName), ONE_SSD);
                this.dfs.satisfyStoragePolicy(new Path(fileName));
            }
            StorageType[][] newtypes = new StorageType[][]{{StorageType.SSD, StorageType.DISK}};
            this.startAdditionalDNs(this.config, 1, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
            this.hdfsCluster.triggerHeartbeats();
            for (String fileName : files) {
                DFSTestUtil.waitExpectedStorageType(fileName, StorageType.SSD, 1, 30000, this.dfs);
                DFSTestUtil.waitExpectedStorageType(fileName, StorageType.DISK, 2, 30000, this.dfs);
            }
            this.waitForBlocksMovementAttemptReport(files.size(), 30000);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testSatisfyFileWithHdfsAdmin() throws Exception {
        try {
            this.createCluster();
            HdfsAdmin hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.config), this.config);
            this.dfs.setStoragePolicy(new Path(FILE), COLD);
            StorageType[][] newtypes = new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}};
            this.startAdditionalDNs(this.config, 3, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
            hdfsAdmin.satisfyStoragePolicy(new Path(FILE));
            this.hdfsCluster.triggerHeartbeats();
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.ARCHIVE, 3, 30000, this.dfs);
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSatisfyDirWithHdfsAdmin() throws Exception {
        try {
            this.createCluster();
            HdfsAdmin hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.config), this.config);
            String subDir = "/subDir";
            String subFile1 = "/subDir/subFile1";
            String subDir2 = "/subDir/subDir2";
            String subFile2 = "/subDir/subDir2/subFile2";
            this.dfs.mkdirs(new Path("/subDir"));
            this.writeContent("/subDir/subFile1");
            this.dfs.mkdirs(new Path("/subDir/subDir2"));
            this.writeContent("/subDir/subDir2/subFile2");
            this.dfs.setStoragePolicy(new Path("/subDir"), ONE_SSD);
            StorageType[][] newtypes = new StorageType[][]{{StorageType.SSD, StorageType.DISK}};
            this.startAdditionalDNs(this.config, 1, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
            hdfsAdmin.satisfyStoragePolicy(new Path("/subDir"));
            this.hdfsCluster.triggerHeartbeats();
            DFSTestUtil.waitExpectedStorageType("/subDir/subFile1", StorageType.SSD, 1, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType("/subDir/subFile1", StorageType.DISK, 2, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType("/subDir/subDir2/subFile2", StorageType.SSD, 1, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType("/subDir/subDir2/subFile2", StorageType.DISK, 2, 30000, this.dfs);
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSatisfyWithExceptions() throws Exception {
        try {
            this.createCluster();
            String nonExistingFile = "/noneExistingFile";
            this.hdfsCluster.getConfiguration(0).setBoolean("dfs.storage.policy.enabled", false);
            this.restartNamenode();
            HdfsAdmin hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.config), this.config);
            try {
                hdfsAdmin.satisfyStoragePolicy(new Path(FILE));
                Assert.fail((String)String.format("Should failed to satisfy storage policy for %s since %s is set to false.", FILE, "dfs.storage.policy.enabled"));
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains((String)String.format("Failed to satisfy storage policy since %s is set to false.", "dfs.storage.policy.enabled"), (Throwable)e);
            }
            this.hdfsCluster.getConfiguration(0).setBoolean("dfs.storage.policy.enabled", true);
            this.restartNamenode();
            hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.config), this.config);
            try {
                hdfsAdmin.satisfyStoragePolicy(new Path("/noneExistingFile"));
                Assert.fail((String)"Should throw FileNotFoundException for /noneExistingFile");
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            try {
                hdfsAdmin.satisfyStoragePolicy(new Path(FILE));
                hdfsAdmin.satisfyStoragePolicy(new Path(FILE));
            }
            catch (Exception e) {
                Assert.fail((String)String.format("Allow to invoke mutlipe times #satisfyStoragePolicy() api for a path %s , internally just skipping addtion to satisfy movement queue.", FILE));
            }
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testWhenOnlyFewTargetDatanodeAreAvailableToSatisfyStoragePolicy() throws Exception {
        try {
            this.createCluster();
            this.dfs.setStoragePolicy(new Path(FILE), COLD);
            StorageType[][] newtypes = new StorageType[][]{{StorageType.ARCHIVE, StorageType.ARCHIVE}};
            this.startAdditionalDNs(this.config, 1, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
            this.dfs.satisfyStoragePolicy(new Path(FILE));
            this.hdfsCluster.triggerHeartbeats();
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.ARCHIVE, 1, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.DISK, 2, 30000, this.dfs);
            this.waitForBlocksMovementAttemptReport(1L, 30000);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testWhenNoTargetDatanodeToSatisfyStoragePolicy() throws Exception {
        try {
            this.createCluster();
            this.dfs.setStoragePolicy(new Path(FILE), COLD);
            StorageType[][] newtypes = new StorageType[][]{{StorageType.DISK, StorageType.DISK}};
            this.startAdditionalDNs(this.config, 1, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
            this.dfs.satisfyStoragePolicy(new Path(FILE));
            this.hdfsCluster.triggerHeartbeats();
            this.waitForAttemptedItems(1L, 30000);
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.DISK, 3, 30000, this.dfs);
            this.waitForAttemptedItems(1L, 30000);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=120000L)
    public void testMoveWithBlockPinning() throws Exception {
        try {
            this.config.setBoolean("dfs.datanode.block-pinning.enabled", true);
            this.hdfsCluster = this.startCluster(this.config, this.allDiskTypes, 3, 2, 0x20000000L);
            this.hdfsCluster.waitActive();
            this.dfs = this.hdfsCluster.getFileSystem();
            String file1 = this.createFileAndSimulateFavoredNodes(2);
            this.dfs.setStoragePolicy(new Path(file1), COLD);
            StorageType[][] newtypes = new StorageType[][]{{StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}};
            this.startAdditionalDNs(this.config, 3, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
            this.dfs.satisfyStoragePolicy(new Path(file1));
            this.hdfsCluster.triggerHeartbeats();
            this.waitForAttemptedItems(1L, 30000);
            this.waitForBlocksMovementAttemptReport(1L, 30000);
            DFSTestUtil.waitExpectedStorageType(file1, StorageType.ARCHIVE, 1, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType(file1, StorageType.DISK, 2, 30000, this.dfs);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testWhenOnlyFewSourceNodesHaveMatchingTargetNodes() throws Exception {
        try {
            int numOfDns = 5;
            this.config.setLong("dfs.block.size", 1024L);
            this.allDiskTypes = new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.ARCHIVE}};
            this.hdfsCluster = this.startCluster(this.config, this.allDiskTypes, numOfDns, 2, 0x20000000L);
            this.dfs = this.hdfsCluster.getFileSystem();
            this.writeContent(FILE, (short)5);
            this.dfs.setStoragePolicy(new Path(FILE), COLD);
            this.dfs.satisfyStoragePolicy(new Path(FILE));
            this.hdfsCluster.triggerHeartbeats();
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.ARCHIVE, 2, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.DISK, 3, 30000, this.dfs);
            this.waitForBlocksMovementAttemptReport(1L, 30000);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testBlockMoveInSameDatanodeWithONESSD() throws Exception {
        StorageType[][] diskTypes = new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.SSD}, {StorageType.DISK, StorageType.RAM_DISK}};
        this.config.setLong("dfs.block.size", 1024L);
        try {
            this.hdfsCluster = this.startCluster(this.config, diskTypes, 3, 2, 0x20000000L);
            this.dfs = this.hdfsCluster.getFileSystem();
            this.writeContent(FILE);
            this.dfs.setStoragePolicy(new Path(FILE), ONE_SSD);
            this.dfs.satisfyStoragePolicy(new Path(FILE));
            this.hdfsCluster.triggerHeartbeats();
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.SSD, 1, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.DISK, 2, 30000, this.dfs);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testBlockMoveInSameAndRemoteDatanodesWithWARM() throws Exception {
        StorageType[][] diskTypes = new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.SSD}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}};
        this.config.setLong("dfs.block.size", 1024L);
        try {
            this.hdfsCluster = this.startCluster(this.config, diskTypes, diskTypes.length, 2, 0x20000000L);
            this.dfs = this.hdfsCluster.getFileSystem();
            this.writeContent(FILE);
            this.dfs.setStoragePolicy(new Path(FILE), "WARM");
            this.dfs.satisfyStoragePolicy(new Path(FILE));
            this.hdfsCluster.triggerHeartbeats();
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.DISK, 1, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.ARCHIVE, 2, 30000, this.dfs);
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testSPSWhenReplicaWithExpectedStorageAlreadyAvailableInSource() throws Exception {
        StorageType[][] diskTypes = new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}};
        try {
            this.hdfsCluster = this.startCluster(this.config, diskTypes, diskTypes.length, 2, 0x20000000L);
            this.dfs = this.hdfsCluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)this.dfs, new Path(FILE), 1024L, (short)2, 0L);
            this.dfs.setStoragePolicy(new Path(FILE), COLD);
            this.dfs.setReplication(new Path(FILE), (short)3);
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.DISK, 2, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.ARCHIVE, 1, 30000, this.dfs);
            this.dfs.setStoragePolicy(new Path(FILE), "HOT");
            this.dfs.satisfyStoragePolicy(new Path(FILE));
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.DISK, 3, 30000, this.dfs);
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testChooseInSameDatanodeWithONESSDShouldNotChooseIfNoSpace() throws Exception {
        StorageType[][] diskTypes = new StorageType[][]{{StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.SSD}, {StorageType.DISK, StorageType.DISK}};
        this.config.setLong("dfs.block.size", 2048L);
        long dnCapacity = 1050623L;
        try {
            this.hdfsCluster = this.startCluster(this.config, diskTypes, 3, 2, dnCapacity);
            this.dfs = this.hdfsCluster.getFileSystem();
            this.writeContent(FILE);
            this.dfs.setStoragePolicy(new Path(FILE), ONE_SSD);
            Path filePath = new Path("/testChooseInSameDatanode");
            try (FSDataOutputStream out = this.dfs.create(filePath, false, 100, (short)1, 2048L);){
                this.dfs.setStoragePolicy(filePath, ONE_SSD);
                long remaining = this.dfs.getStatus().getRemaining() / 6L;
                int i = 0;
                while ((long)i < remaining) {
                    out.write(i);
                    ++i;
                }
            }
            this.hdfsCluster.triggerHeartbeats();
            ArrayList<DataNode> dataNodes = this.hdfsCluster.getDataNodes();
            for (DataNode dataNode : dataNodes) {
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dataNode, true);
            }
            this.dfs.satisfyStoragePolicy(new Path(FILE));
            this.waitForAttemptedItems(1L, 30000);
            for (DataNode dataNode : dataNodes) {
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dataNode, false);
            }
            this.hdfsCluster.triggerHeartbeats();
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.DISK, 3, 30000, this.dfs);
            DFSTestUtil.waitExpectedStorageType(FILE, StorageType.SSD, 0, 30000, this.dfs);
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSPSShouldNotLeakXattrIfSatisfyStoragePolicyCallOnECFiles() throws Exception {
        StorageType[][] diskTypes = new StorageType[][]{{StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.DISK, StorageType.SSD}, {StorageType.DISK, StorageType.SSD}, {StorageType.DISK, StorageType.SSD}, {StorageType.DISK, StorageType.SSD}, {StorageType.DISK, StorageType.SSD}};
        int defaultStripedBlockSize = StripedFileTestUtil.getDefaultECPolicy().getCellSize() * 4;
        this.config.setLong("dfs.blocksize", (long)defaultStripedBlockSize);
        this.config.setLong("dfs.heartbeat.interval", 1L);
        this.config.setLong("dfs.namenode.redundancy.interval.seconds", 1L);
        this.config.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        try {
            this.hdfsCluster = this.startCluster(this.config, diskTypes, diskTypes.length, 2, 0x20000000L);
            this.dfs = this.hdfsCluster.getFileSystem();
            this.dfs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            ClientProtocol client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)this.config, (URI)this.hdfsCluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            String fooDir = "/foo";
            client.mkdirs(fooDir, new FsPermission(777), true);
            client.setErasureCodingPolicy(fooDir, StripedFileTestUtil.getDefaultECPolicy().getName());
            String testFile = "/foo/bar";
            long fileLen = 20 * defaultStripedBlockSize;
            DFSTestUtil.createFile((FileSystem)this.dfs, new Path("/foo/bar"), fileLen, (short)3, 0L);
            client.setStoragePolicy(fooDir, ONE_SSD);
            this.dfs.satisfyStoragePolicy(new Path("/foo/bar"));
            LocatedBlocks locatedBlocks = client.getBlockLocations("/foo/bar", 0L, fileLen);
            for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                for (StorageType type : lb.getStorageTypes()) {
                    Assert.assertEquals((Object)StorageType.DISK, (Object)type);
                }
            }
            DFSTestUtil.waitForXattrRemoved("/foo/bar", "user.hdfs.sps", (Namesystem)this.hdfsCluster.getNamesystem(), 30000);
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSPSWhenFileLengthIsZero() throws Exception {
        try {
            this.hdfsCluster = this.startCluster(this.config, this.allDiskTypes, 3, 2, 0x20000000L);
            this.hdfsCluster.waitActive();
            DistributedFileSystem fs = this.hdfsCluster.getFileSystem();
            Path filePath = new Path("/zeroSizeFile");
            DFSTestUtil.createFile((FileSystem)fs, filePath, 0L, (short)1, 0L);
            FSEditLog editlog = this.hdfsCluster.getNameNode().getNamesystem().getEditLog();
            long lastWrittenTxId = editlog.getLastWrittenTxId();
            fs.satisfyStoragePolicy(filePath);
            Assert.assertEquals((String)"Xattr should not be added for the file", (long)lastWrittenTxId, (long)editlog.getLastWrittenTxId());
            INode inode = this.hdfsCluster.getNameNode().getNamesystem().getFSDirectory().getINode(filePath.toString());
            Assert.assertTrue((String)"XAttrFeature should be null for file", (inode.getXAttrFeature() == null ? 1 : 0) != 0);
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSPSWhenFileHasLowRedundancyBlocks() throws Exception {
        try {
            this.config.set("dfs.storage.policy.satisfier.recheck.timeout.millis", "3000");
            this.config.set("dfs.storage.policy.satisfier.self.retry.timeout.millis", "5000");
            StorageType[][] newtypes = new StorageType[][]{{StorageType.ARCHIVE, StorageType.DISK}, {StorageType.ARCHIVE, StorageType.DISK}, {StorageType.ARCHIVE, StorageType.DISK}};
            this.hdfsCluster = this.startCluster(this.config, newtypes, 3, 2, 0x20000000L);
            this.hdfsCluster.waitActive();
            DistributedFileSystem fs = this.hdfsCluster.getFileSystem();
            Path filePath = new Path("/zeroSizeFile");
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1024L, (short)3, 0L);
            fs.setStoragePolicy(filePath, COLD);
            ArrayList<MiniDFSCluster.DataNodeProperties> list = new ArrayList<MiniDFSCluster.DataNodeProperties>();
            list.add(this.hdfsCluster.stopDataNode(0));
            list.add(this.hdfsCluster.stopDataNode(0));
            list.add(this.hdfsCluster.stopDataNode(0));
            this.restartNamenode();
            this.hdfsCluster.restartDataNode((MiniDFSCluster.DataNodeProperties)list.get(0), false);
            this.hdfsCluster.restartDataNode((MiniDFSCluster.DataNodeProperties)list.get(1), false);
            this.hdfsCluster.waitActive();
            fs.satisfyStoragePolicy(filePath);
            DFSTestUtil.waitExpectedStorageType(filePath.toString(), StorageType.ARCHIVE, 2, 30000, this.hdfsCluster.getFileSystem());
            this.hdfsCluster.restartDataNode((MiniDFSCluster.DataNodeProperties)list.get(2), false);
            DFSTestUtil.waitExpectedStorageType(filePath.toString(), StorageType.ARCHIVE, 3, 30000, this.hdfsCluster.getFileSystem());
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSPSWhenFileHasExcessRedundancyBlocks() throws Exception {
        try {
            this.config.set("dfs.storage.policy.satisfier.recheck.timeout.millis", "3000");
            this.config.set("dfs.storage.policy.satisfier.self.retry.timeout.millis", "5000");
            StorageType[][] newtypes = new StorageType[][]{{StorageType.ARCHIVE, StorageType.DISK}, {StorageType.ARCHIVE, StorageType.DISK}, {StorageType.ARCHIVE, StorageType.DISK}, {StorageType.ARCHIVE, StorageType.DISK}, {StorageType.ARCHIVE, StorageType.DISK}};
            this.hdfsCluster = this.startCluster(this.config, newtypes, 5, 2, 0x20000000L);
            this.hdfsCluster.waitActive();
            DistributedFileSystem fs = this.hdfsCluster.getFileSystem();
            Path filePath = new Path("/zeroSizeFile");
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1024L, (short)5, 0L);
            fs.setReplication(filePath, (short)3);
            GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(BlockStorageMovementAttemptedItems.class));
            fs.setStoragePolicy(filePath, COLD);
            fs.satisfyStoragePolicy(filePath);
            DFSTestUtil.waitExpectedStorageType(filePath.toString(), StorageType.ARCHIVE, 3, 60000, this.hdfsCluster.getFileSystem());
            Assert.assertFalse((String)"Log output does not contain expected log message: ", (boolean)logs.getOutput().contains("some of the blocks are low redundant"));
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testSPSForEmptyDirectory() throws IOException, TimeoutException, InterruptedException {
        try {
            this.hdfsCluster = this.startCluster(this.config, this.allDiskTypes, 3, 2, 0x20000000L);
            this.hdfsCluster.waitActive();
            DistributedFileSystem fs = this.hdfsCluster.getFileSystem();
            Path emptyDir = new Path("/emptyDir");
            fs.mkdirs(emptyDir);
            fs.satisfyStoragePolicy(emptyDir);
            DFSTestUtil.waitForXattrRemoved("/emptyDir", "user.hdfs.sps", (Namesystem)this.hdfsCluster.getNamesystem(), 30000);
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSPSForNonExistDirectory() throws Exception {
        try {
            this.hdfsCluster = this.startCluster(this.config, this.allDiskTypes, 3, 2, 0x20000000L);
            this.hdfsCluster.waitActive();
            DistributedFileSystem fs = this.hdfsCluster.getFileSystem();
            Path emptyDir = new Path("/emptyDir");
            try {
                fs.satisfyStoragePolicy(emptyDir);
                Assert.fail((String)"FileNotFoundException should throw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test(timeout=300000L)
    public void testSPSWithDirectoryTreeWithoutFile() throws Exception {
        try {
            this.hdfsCluster = this.startCluster(this.config, this.allDiskTypes, 3, 2, 0x20000000L);
            this.hdfsCluster.waitActive();
            DistributedFileSystem fs = this.hdfsCluster.getFileSystem();
            fs.mkdirs(new Path("/root/C/H/O"));
            fs.mkdirs(new Path("/root/A"));
            fs.mkdirs(new Path("/root/D"));
            fs.mkdirs(new Path("/root/C/G"));
            fs.mkdirs(new Path("/root/C/I"));
            fs.satisfyStoragePolicy(new Path("/root"));
            DFSTestUtil.waitForXattrRemoved("/root", "user.hdfs.sps", (Namesystem)this.hdfsCluster.getNamesystem(), 30000);
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSPSSatisfyAndThenDeleteFileBeforeStartSPS() throws Exception {
        try {
            this.createCluster();
            HdfsAdmin hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.config), this.config);
            StorageType[][] newtypes = new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}};
            this.startAdditionalDNs(this.config, 3, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
            this.stopExternalSps();
            this.dfs.setStoragePolicy(new Path(FILE), COLD);
            hdfsAdmin.satisfyStoragePolicy(new Path(FILE));
            this.dfs.delete(new Path(FILE), true);
            this.startExternalSps();
            String file1 = "/testMoveToSatisfyStoragePolicy_1";
            this.writeContent(file1);
            this.dfs.setStoragePolicy(new Path(file1), COLD);
            hdfsAdmin.satisfyStoragePolicy(new Path(file1));
            this.hdfsCluster.triggerHeartbeats();
            DFSTestUtil.waitExpectedStorageType(file1, StorageType.ARCHIVE, 3, 30000, this.dfs);
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMultipleLevelDirectoryForSatisfyStoragePolicy() throws Exception {
        try {
            StorageType[][] diskTypes = new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.SSD}, {StorageType.DISK, StorageType.DISK}};
            this.config.setLong("dfs.block.size", 1024L);
            this.hdfsCluster = this.startCluster(this.config, diskTypes, diskTypes.length, 2, 0x20000000L);
            this.dfs = this.hdfsCluster.getFileSystem();
            TestExternalStoragePolicySatisfier.createDirectoryTree(this.dfs);
            List<String> files = this.getDFSListOfTree();
            this.dfs.setStoragePolicy(new Path("/root"), COLD);
            this.dfs.satisfyStoragePolicy(new Path("/root"));
            for (String fileName : files) {
                DFSTestUtil.waitExpectedStorageType(fileName, StorageType.ARCHIVE, 2, 30000, this.dfs);
            }
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMoveBlocksWithUnderReplicatedBlocks() throws Exception {
        try {
            Path filePath;
            int i;
            this.config.setInt("dfs.namenode.replication.max-streams", 3);
            this.config.setLong("dfs.block.size", 1024L);
            this.config.set("dfs.storage.policy.satisfier.recheck.timeout.millis", "3000");
            this.config.set("dfs.storage.policy.satisfier.self.retry.timeout.millis", "5000");
            StorageType[][] storagetypes = new StorageType[][]{{StorageType.ARCHIVE, StorageType.DISK}, {StorageType.ARCHIVE, StorageType.DISK}};
            this.hdfsCluster = this.startCluster(this.config, storagetypes, 2, 2, 0x20000000L);
            this.hdfsCluster.waitActive();
            this.dfs = this.hdfsCluster.getFileSystem();
            for (int i2 = 1; i2 <= 20; ++i2) {
                Path filePath2 = new Path("/file" + i2);
                DFSTestUtil.createFile((FileSystem)this.dfs, filePath2, 5120L, (short)2, 0L);
            }
            StorageType[][] newtypes = new StorageType[][]{{StorageType.DISK, StorageType.SSD}, {StorageType.DISK, StorageType.SSD}};
            this.startAdditionalDNs(this.config, 2, 3, newtypes, 2, 0x20000000L, this.hdfsCluster);
            for (i = 1; i <= 10; ++i) {
                filePath = new Path("/file" + i);
                this.dfs.setReplication(filePath, (short)4);
            }
            for (i = 11; i <= 20; ++i) {
                filePath = new Path("/file" + i);
                this.dfs.setStoragePolicy(filePath, "ALL_SSD");
                this.dfs.satisfyStoragePolicy(filePath);
            }
            for (i = 1; i <= 10; ++i) {
                filePath = new Path("/file" + i);
                DFSTestUtil.waitExpectedStorageType(filePath.toString(), StorageType.DISK, 4, 60000, this.hdfsCluster.getFileSystem());
            }
            for (i = 11; i <= 20; ++i) {
                filePath = new Path("/file" + i);
                DFSTestUtil.waitExpectedStorageType(filePath.toString(), StorageType.SSD, 2, 30000, this.hdfsCluster.getFileSystem());
            }
        }
        finally {
            this.shutdownCluster();
        }
    }

    private static void createDirectoryTree(DistributedFileSystem dfs) throws Exception {
        dfs.mkdirs(new Path("/root"));
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/A"), 1024L, (short)3, 0L);
        dfs.mkdirs(new Path("/root/B"));
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/C"), 1024L, (short)3, 0L);
        dfs.mkdirs(new Path("/root/D"));
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/E"), 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/B/F"), 1024L, (short)3, 0L);
        dfs.mkdirs(new Path("/root/B/G"));
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/B/H"), 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/B/I"), 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/D/J"), 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/D/K"), 1024L, (short)3, 0L);
        dfs.mkdirs(new Path("/root/D/L"));
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/D/M"), 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/B/G/N"), 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/B/G/O"), 1024L, (short)3, 0L);
        dfs.mkdirs(new Path("/root/B/G/P"));
        dfs.mkdirs(new Path("/root/D/L/Q"));
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/D/L/R"), 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/D/L/S"), 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/B/G/P/T"), 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/root/D/L/Q/U"), 1024L, (short)3, 0L);
    }

    private List<String> getDFSListOfTree() {
        ArrayList<String> dfsList = new ArrayList<String>();
        dfsList.add("/root/A");
        dfsList.add("/root/B/F");
        dfsList.add("/root/B/G/N");
        dfsList.add("/root/B/G/O");
        dfsList.add("/root/B/G/P/T");
        dfsList.add("/root/B/H");
        dfsList.add("/root/B/I");
        dfsList.add("/root/C");
        dfsList.add("/root/D/J");
        dfsList.add("/root/D/K");
        dfsList.add("/root/D/L/Q/U");
        dfsList.add("/root/D/L/R");
        dfsList.add("/root/D/L/S");
        dfsList.add("/root/D/M");
        dfsList.add("/root/E");
        return dfsList;
    }

    private String createFileAndSimulateFavoredNodes(int favoredNodesCount) throws IOException {
        StorageType[] storageTypes;
        ArrayList<DataNode> dns = this.hdfsCluster.getDataNodes();
        String file1 = "/testMoveWithBlockPinning";
        InetSocketAddress[] favoredNodes = new InetSocketAddress[favoredNodesCount];
        for (int i = 0; i < favoredNodesCount; ++i) {
            favoredNodes[i] = dns.get(i).getXferAddress();
        }
        DFSTestUtil.createFile((FileSystem)this.dfs, new Path("/testMoveWithBlockPinning"), false, 1024, 100L, 1024L, (short)3, 0L, false, favoredNodes);
        LocatedBlocks locatedBlocks = this.dfs.getClient().getLocatedBlocks("/testMoveWithBlockPinning", 0L);
        Assert.assertEquals((String)"Wrong block count", (long)1L, (long)locatedBlocks.locatedBlockCount());
        LocatedBlock lb = locatedBlocks.get(0);
        for (StorageType storageType : storageTypes = lb.getStorageTypes()) {
            Assert.assertTrue((StorageType.DISK == storageType ? 1 : 0) != 0);
        }
        DatanodeInfo[] locations = lb.getLocations();
        Assert.assertEquals((long)3L, (long)locations.length);
        Assert.assertTrue((favoredNodesCount < locations.length ? 1 : 0) != 0);
        for (DatanodeInfo dnInfo : locations) {
            LOG.info("Simulate block pinning in datanode {}", (Object)locations[favoredNodesCount]);
            DataNode dn = this.hdfsCluster.getDataNode(dnInfo.getIpcPort());
            InternalDataNodeTestUtils.mockDatanodeBlkPinning(dn, true);
            if (--favoredNodesCount <= 0) break;
        }
        return "/testMoveWithBlockPinning";
    }

    public void waitForAttemptedItems(final long expectedBlkMovAttemptedCount, int timeout) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                LOG.info("expectedAttemptedItemsCount={} actualAttemptedItemsCount={}", (Object)expectedBlkMovAttemptedCount, (Object)TestExternalStoragePolicySatisfier.this.externalSps.getAttemptedItemsMonitor().getAttemptedItemsCount());
                return (long)TestExternalStoragePolicySatisfier.this.externalSps.getAttemptedItemsMonitor().getAttemptedItemsCount() == expectedBlkMovAttemptedCount;
            }
        }, (long)100L, (long)timeout);
    }

    public void waitForBlocksMovementAttemptReport(final long expectedMovementFinishedBlocksCount, int timeout) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                int actualCount = TestExternalStoragePolicySatisfier.this.externalSps.getAttemptedItemsMonitor().getAttemptedItemsCount();
                LOG.info("MovementFinishedBlocks: expectedCount={} actualCount={}", (Object)expectedMovementFinishedBlocksCount, (Object)actualCount);
                return (long)actualCount >= expectedMovementFinishedBlocksCount;
            }
        }, (long)100L, (long)timeout);
    }

    public void writeContent(String fileName) throws IOException {
        this.writeContent(fileName, (short)3);
    }

    private void writeContent(String fileName, short replicatonFactor) throws IOException {
        FSDataOutputStream out = this.dfs.create(new Path(fileName), replicatonFactor);
        for (int i = 0; i < 1024; ++i) {
            out.write(i);
        }
        out.close();
    }

    private void startAdditionalDNs(Configuration conf, int newNodesRequired, int existingNodesNum, StorageType[][] newTypes, int storagesPerDn, long nodeCapacity, MiniDFSCluster cluster) throws IOException {
        existingNodesNum += newNodesRequired;
        long[][] capacities = new long[newNodesRequired][storagesPerDn];
        for (int i = 0; i < newNodesRequired; ++i) {
            for (int j = 0; j < storagesPerDn; ++j) {
                capacities[i][j] = nodeCapacity;
            }
        }
        cluster.startDataNodes(conf, newNodesRequired, newTypes, true, null, null, null, capacities, null, false, false, false, null);
        cluster.triggerHeartbeats();
    }

    public static final class ExternalBlockMovementListener
    implements BlockMovementListener {
        private List<Block> actualBlockMovements = new ArrayList<Block>();

        public void notifyMovementTriedBlocks(Block[] moveAttemptFinishedBlks) {
            for (Block block : moveAttemptFinishedBlks) {
                this.actualBlockMovements.add(block);
            }
            LOG.info("Movement attempted blocks:{}", this.actualBlockMovements);
        }

        public List<Block> getActualBlockMovements() {
            return this.actualBlockMovements;
        }

        public void clear() {
            this.actualBlockMovements.clear();
        }
    }
}

