/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirWriteFileOp;
import org.apache.hadoop.net.Node;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFSDirWriteFileOp {
    @Test
    public void testIgnoreClientLocality() throws IOException {
        FSDirWriteFileOp.ValidateAddBlockResult addBlockResult = new FSDirWriteFileOp.ValidateAddBlockResult(1024L, 3, 1, null, null, null);
        EnumSet<AddBlockFlag> addBlockFlags = EnumSet.of(AddBlockFlag.IGNORE_CLIENT_LOCALITY);
        BlockManager bmMock = (BlockManager)Mockito.mock(BlockManager.class);
        ArgumentCaptor nodeCaptor = ArgumentCaptor.forClass(Node.class);
        Mockito.when((Object)bmMock.chooseTarget4NewBlock(Matchers.anyString(), Matchers.anyInt(), (Node)Matchers.any(), Matchers.anySet(), Matchers.anyLong(), Matchers.anyList(), Matchers.anyByte(), (BlockType)Matchers.any(), (ErasureCodingPolicy)Matchers.any(), (EnumSet)Matchers.any())).thenReturn(null);
        FSDirWriteFileOp.chooseTargetForNewBlock((BlockManager)bmMock, (String)"localhost", null, null, addBlockFlags, (FSDirWriteFileOp.ValidateAddBlockResult)addBlockResult);
        ((BlockManager)Mockito.verify((Object)bmMock, (VerificationMode)Mockito.times((int)1))).chooseTarget4NewBlock(Matchers.anyString(), Matchers.anyInt(), (Node)nodeCaptor.capture(), Matchers.anySet(), Matchers.anyLong(), Matchers.anyList(), Matchers.anyByte(), (BlockType)Matchers.any(), (ErasureCodingPolicy)Matchers.any(), (EnumSet)Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{bmMock});
        Assert.assertNull((String)"Source node was assigned a value. Expected 'null' value because chooseTarget was flagged to ignore source node locality", (Object)nodeCaptor.getValue());
    }
}

