/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFsLinkFallback {
    private static FileSystem fsDefault;
    private FileSystem fsTarget;
    private static MiniDFSCluster cluster;
    private static URI viewFsDefaultClusterUri;
    private Path targetTestRoot;

    @BeforeClass
    public static void clusterSetupAtBeginning() throws IOException, URISyntaxException {
        int nameSpacesCount = 3;
        int dataNodesCount = 3;
        int fsIndexDefault = 0;
        Configuration conf = new Configuration();
        FileSystem[] fsHdfs = new FileSystem[nameSpacesCount];
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(nameSpacesCount)).numDataNodes(dataNodesCount).build();
        cluster.waitClusterUp();
        for (int i = 0; i < nameSpacesCount; ++i) {
            fsHdfs[i] = cluster.getFileSystem(i);
        }
        fsDefault = fsHdfs[fsIndexDefault];
        viewFsDefaultClusterUri = new URI("viewfs", "default", "/", null, null);
    }

    @AfterClass
    public static void clusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fsDefault;
        this.initializeTargetTestRoot();
    }

    private void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = fsDefault.makeQualified(new Path("/"));
        for (FileStatus status : fsDefault.listStatus(this.targetTestRoot)) {
            fsDefault.delete(status.getPath(), true);
        }
    }

    @Test
    public void testMkdirOfLinkParentWithFallbackLinkWithSameMountDirectoryTree() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path dir1 = new Path(this.targetTestRoot, "fallbackDir/user1/hive/warehouse/partition-0");
        this.fsTarget.mkdirs(dir1);
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path p = new Path("/user1/hive/warehouse/test");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)p);
        Assert.assertFalse((boolean)this.fsTarget.exists(test));
        vfs.mkdir(p, null, true);
        Assert.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testMkdirOfRootWithFallbackLinkAndMountWithSameDirTree() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path dir1 = new Path(this.targetTestRoot, "fallbackDir/user1");
        this.fsTarget.mkdirs(dir1);
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path p = new Path("/");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)p);
        Assert.assertTrue((boolean)this.fsTarget.exists(test));
        vfs.mkdir(p, null, true);
        Assert.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testMkdirOfNewDirWithOutMatchingToMountOrFallbackDirTree() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path p = new Path("/user2");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)p);
        Assert.assertFalse((boolean)this.fsTarget.exists(test));
        vfs.mkdir(p, null, true);
        Assert.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testMkdirWithFallbackLinkWithMountPathMatchingDirExist() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path immediateLevelToInternalDir = new Path("/user1/test");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)immediateLevelToInternalDir);
        Assert.assertFalse((boolean)this.fsTarget.exists(test));
        vfs.mkdir(immediateLevelToInternalDir, null, true);
        Assert.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testMkdirOfDeepTreeWithFallbackLinkAndMountPathMatchingDirExist() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path multipleLevelToInternalDir = new Path("/user1/test/test");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)multipleLevelToInternalDir);
        Assert.assertFalse((boolean)this.fsTarget.exists(test));
        vfs.mkdir(multipleLevelToInternalDir, null, true);
        Assert.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testMkdirShouldCreateParentDirInFallbackWhenMountDirExist() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/test", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path multipleLevelToInternalDir = new Path("/user1/hive/test1");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)multipleLevelToInternalDir);
        Assert.assertFalse((boolean)this.fsTarget.exists(test));
        Assert.assertNotNull((Object)vfs.getFileStatus(new Path("/user1/hive")));
        Assert.assertFalse((boolean)this.fsTarget.exists(test.getParent()));
        vfs.mkdir(multipleLevelToInternalDir, FsPermission.getDirDefault(), false);
        Assert.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testMkdirShouldFailWhenFallbackFSNotAvailable() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/test", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path nextLevelToInternalDir = new Path("/user1/test1");
        Path test = Path.mergePaths((Path)fallbackTarget, (Path)nextLevelToInternalDir);
        Assert.assertFalse((boolean)this.fsTarget.exists(test));
        Assert.assertNotNull((Object)vfs.getFileStatus(new Path("/user1")));
        Assert.assertFalse((boolean)this.fsTarget.exists(test.getParent()));
        cluster.shutdownNameNodes();
        try {
            vfs.mkdir(nextLevelToInternalDir, FsPermission.getDirDefault(), false);
            Assert.fail((String)"It should throw IOE when fallback fs not available.");
        }
        catch (IOException e) {
            cluster.restartNameNodes();
            vfs.mkdir(nextLevelToInternalDir, FsPermission.getDirDefault(), false);
        }
        Assert.assertTrue((boolean)this.fsTarget.exists(test));
    }

    @Test
    public void testCreateFileOnInternalMountDirWithSameDirTreeExistInFallback() throws Exception {
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        Path dir1 = new Path(fallbackTarget, "user1/hive/warehouse/partition-0");
        this.fsTarget.mkdirs(dir1);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path vfsTestFile = new Path("/user1/hive/warehouse/test.file");
        Path testFileInFallback = Path.mergePaths((Path)fallbackTarget, (Path)vfsTestFile);
        Assert.assertFalse((boolean)this.fsTarget.exists(testFileInFallback));
        Assert.assertTrue((boolean)this.fsTarget.exists(testFileInFallback.getParent()));
        vfs.create(vfsTestFile, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
        Assert.assertTrue((boolean)this.fsTarget.exists(testFileInFallback));
    }

    @Test
    public void testCreateNewFileWithOutMatchingToMountDirOrFallbackDirPath() throws Exception {
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path vfsTestFile = new Path("/user2/test.file");
        Path testFileInFallback = Path.mergePaths((Path)fallbackTarget, (Path)vfsTestFile);
        Assert.assertFalse((boolean)this.fsTarget.exists(testFileInFallback));
        Assert.assertFalse((boolean)this.fsTarget.exists(testFileInFallback.getParent()));
        vfs.create(vfsTestFile, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault()), Options.CreateOpts.createParent()}).close();
        Assert.assertTrue((boolean)this.fsTarget.exists(testFileInFallback));
    }

    @Test
    public void testCreateFileOnRootWithFallbackEnabled() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path vfsTestFile = new Path("/test.file");
        Path testFileInFallback = Path.mergePaths((Path)fallbackTarget, (Path)vfsTestFile);
        Assert.assertFalse((boolean)this.fsTarget.exists(testFileInFallback));
        vfs.create(vfsTestFile, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
        Assert.assertTrue((boolean)this.fsTarget.exists(testFileInFallback));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateFileOnRootWithFallbackWithFileAlreadyExist() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        Path testFile = new Path(fallbackTarget, "test.file");
        this.fsTarget.create(testFile).close();
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path vfsTestFile = new Path("/test.file");
        Assert.assertTrue((boolean)this.fsTarget.exists(testFile));
        vfs.create(vfsTestFile, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateFileWhereThePathIsSameAsItsMountLinkPath() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path vfsTestDir = new Path("/user1/hive");
        Assert.assertFalse((boolean)this.fsTarget.exists(Path.mergePaths((Path)fallbackTarget, (Path)vfsTestDir)));
        vfs.create(vfsTestDir, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateFileSameAsInternalDirPath() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        AbstractFileSystem vfs = AbstractFileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        Path vfsTestDir = new Path("/user1");
        Assert.assertFalse((boolean)this.fsTarget.exists(Path.mergePaths((Path)fallbackTarget, (Path)vfsTestDir)));
        vfs.create(vfsTestDir, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())}).close();
    }
}

