/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionEngine;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;

class NullEncryption
extends EncryptionEngine {
    NullEncryption() {
    }

    @Override
    public EncryptionType getEncryptionType() {
        return EncryptionType.NULL;
    }

    @Override
    public int getChecksumLength() {
        return 0;
    }

    @Override
    public int getConfounderLength() {
        return 0;
    }

    @Override
    public byte[] getDecryptedData(EncryptionKey key, EncryptedData data, KeyUsage usage) throws KerberosException {
        return data.getCipher();
    }

    @Override
    public EncryptedData getEncryptedData(EncryptionKey key, byte[] plainText, KeyUsage usage) {
        return new EncryptedData(this.getEncryptionType(), key.getKeyVersion(), plainText);
    }

    @Override
    public byte[] encrypt(byte[] plainText, byte[] keyBytes) {
        return plainText;
    }

    @Override
    public byte[] decrypt(byte[] cipherText, byte[] keyBytes) {
        return cipherText;
    }

    @Override
    public byte[] calculateIntegrity(byte[] plainText, byte[] key, KeyUsage usage) {
        return null;
    }
}

