/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.unbindRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.UnbindRequestDecorator;
import org.apache.directory.api.ldap.model.message.UnbindRequest;
import org.apache.directory.api.ldap.model.message.UnbindRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitUnbindRequest
extends GrammarAction<LdapMessageContainer<UnbindRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitUnbindRequest.class);

    public InitUnbindRequest() {
        super("Unbind Request initialization");
    }

    public void action(LdapMessageContainer<UnbindRequestDecorator> container) throws DecoderException {
        UnbindRequestImpl unbindRequestInternal = new UnbindRequestImpl();
        unbindRequestInternal.setMessageId(container.getMessageId());
        UnbindRequestDecorator unbindRequest = new UnbindRequestDecorator(container.getLdapCodecService(), (UnbindRequest)unbindRequestInternal);
        container.setMessage(unbindRequest);
        TLV tlv = container.getCurrentTLV();
        int expectedLength = tlv.getLength();
        if (expectedLength != 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04071, (Object[])new Object[]{expectedLength}));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04072, (Object[])new Object[0]));
        }
        container.setGrammarEndAllowed(true);
    }
}

