/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.StoredProcedureParameter;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureRequestDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureStatesEnum;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StoredProcedureGrammar
extends AbstractGrammar<StoredProcedureContainer> {
    static final Logger LOG = LoggerFactory.getLogger(StoredProcedureGrammar.class);
    private static StoredProcedureGrammar instance = new StoredProcedureGrammar();

    private StoredProcedureGrammar() {
        this.setName(StoredProcedureGrammar.class.getName());
        this.transitions = new GrammarTransition[StoredProcedureStatesEnum.LAST_STORED_PROCEDURE_STATE.ordinal()][256];
        this.transitions[StoredProcedureStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.START_STATE, (Enum)StoredProcedureStatesEnum.STORED_PROCEDURE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[StoredProcedureStatesEnum.STORED_PROCEDURE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.STORED_PROCEDURE_STATE, (Enum)StoredProcedureStatesEnum.LANGUAGE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<StoredProcedureContainer>("Stores the language"){

            public void action(StoredProcedureContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                StoredProcedureRequestDecorator storedProcedure = container.getStoredProcedure();
                if (storedProcedure == null) {
                    storedProcedure = new StoredProcedureRequestDecorator(LdapApiServiceFactory.getSingleton());
                    container.setStoredProcedure(storedProcedure);
                }
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04038, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                String language = Strings.utf8ToString((byte[])tlv.getValue().getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SP language found: " + language);
                }
                storedProcedure.setLanguage(language);
            }
        });
        this.transitions[StoredProcedureStatesEnum.LANGUAGE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.LANGUAGE_STATE, (Enum)StoredProcedureStatesEnum.PROCEDURE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<StoredProcedureContainer>("Stores the procedure"){

            public void action(StoredProcedureContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                StoredProcedureRequestDecorator storedProcedure = container.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04039, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                byte[] procedure = tlv.getValue().getData();
                storedProcedure.setProcedure(procedure);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Procedure found : " + storedProcedure.getProcedureSpecification());
                }
            }
        });
        this.transitions[StoredProcedureStatesEnum.PROCEDURE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.PROCEDURE_STATE, (Enum)StoredProcedureStatesEnum.PARAMETERS_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<StoredProcedureContainer>("Stores the parameters"){

            public void action(StoredProcedureContainer container) throws DecoderException {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETERS_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.PARAMETERS_STATE, (Enum)StoredProcedureStatesEnum.PARAMETER_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[StoredProcedureStatesEnum.PARAMETER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.PARAMETER_STATE, (Enum)StoredProcedureStatesEnum.PARAMETER_TYPE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<StoredProcedureContainer>("Store parameter type"){

            public void action(StoredProcedureContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                StoredProcedureRequestDecorator storedProcedure = container.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04040, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                StoredProcedureParameter parameter = new StoredProcedureParameter();
                byte[] parameterType = tlv.getValue().getData();
                parameter.setType(parameterType);
                storedProcedure.setCurrentParameter(parameter);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parameter type found : " + Strings.dumpBytes((byte[])parameterType));
                }
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETER_TYPE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.PARAMETER_TYPE_STATE, (Enum)StoredProcedureStatesEnum.PARAMETER_VALUE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<StoredProcedureContainer>("Store parameter value"){

            public void action(StoredProcedureContainer container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = container;
                TLV tlv = storedProcedureContainer.getCurrentTLV();
                StoredProcedureRequestDecorator storedProcedure = storedProcedureContainer.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04041, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                byte[] parameterValue = tlv.getValue().getData();
                if (parameterValue.length != 0) {
                    StoredProcedureParameter parameter = storedProcedure.getCurrentParameter();
                    parameter.setValue(parameterValue);
                    storedProcedure.addParameter(parameter);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Parameter value found : " + Strings.dumpBytes((byte[])parameterValue));
                    }
                } else {
                    String msg = I18n.err((I18n)I18n.ERR_04042, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETER_VALUE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.PARAMETER_VALUE_STATE, (Enum)StoredProcedureStatesEnum.PARAMETER_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
    }

    public static StoredProcedureGrammar getInstance() {
        return instance;
    }
}

