/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RntbdTransportClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdContextNegotiator;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestEncoder;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestManager;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdResponseDecoder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.Objects;
import javax.net.ssl.SSLEngine;

public final class RntbdClientChannelInitializer
extends ChannelInitializer<NioSocketChannel> {
    private final LogLevel logLevel;
    private final RntbdTransportClient.Options options;
    private final RntbdRequestManager requestManager;
    private final SslContext sslContext;
    private final UserAgentContainer userAgent;

    public RntbdClientChannelInitializer(UserAgentContainer userAgent, SslContext sslContext, LogLevel logLevel, RntbdTransportClient.Options options) {
        Objects.requireNonNull(sslContext, "sslContext");
        Objects.requireNonNull(userAgent, "userAgent");
        Objects.requireNonNull(options, "options");
        this.requestManager = new RntbdRequestManager();
        this.sslContext = sslContext;
        this.userAgent = userAgent;
        this.logLevel = logLevel;
        this.options = options;
    }

    public RntbdRequestManager getRequestManager() {
        return this.requestManager;
    }

    protected void initChannel(NioSocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst(new ChannelHandler[]{new RntbdContextNegotiator(this.requestManager, this.userAgent), new RntbdResponseDecoder(), new RntbdRequestEncoder(), this.requestManager});
        if (this.logLevel != null) {
            pipeline.addFirst(new ChannelHandler[]{new LoggingHandler(this.logLevel)});
        }
        int readerIdleTime = (int)this.options.getReceiveHangDetectionTime().toNanos();
        int writerIdleTime = (int)this.options.getSendHangDetectionTime().toNanos();
        SSLEngine sslEngine = this.sslContext.newEngine(channel.alloc());
        pipeline.addFirst(new ChannelHandler[]{new SslHandler(sslEngine)});
    }
}

