/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp.dao;

import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptInfo;
import org.apache.hadoop.yarn.util.Times;

@XmlRootElement(name="taskAttempt")
public class ReduceTaskAttemptInfo
extends TaskAttemptInfo {
    protected long shuffleFinishTime;
    protected long mergeFinishTime;
    protected long elapsedShuffleTime;
    protected long elapsedMergeTime;
    protected long elapsedReduceTime;

    public ReduceTaskAttemptInfo() {
    }

    public ReduceTaskAttemptInfo(TaskAttempt ta) {
        this(ta, false);
    }

    public ReduceTaskAttemptInfo(TaskAttempt ta, Boolean isRunning) {
        super(ta, TaskType.REDUCE, isRunning);
        this.shuffleFinishTime = ta.getShuffleFinishTime();
        this.mergeFinishTime = ta.getSortFinishTime();
        this.elapsedShuffleTime = Times.elapsed((long)this.startTime, (long)this.shuffleFinishTime, (boolean)false);
        if (this.elapsedShuffleTime == -1L) {
            this.elapsedShuffleTime = 0L;
        }
        this.elapsedMergeTime = Times.elapsed((long)this.shuffleFinishTime, (long)this.mergeFinishTime, (boolean)false);
        if (this.elapsedMergeTime == -1L) {
            this.elapsedMergeTime = 0L;
        }
        this.elapsedReduceTime = Times.elapsed((long)this.mergeFinishTime, (long)this.finishTime, (boolean)false);
        if (this.elapsedReduceTime == -1L) {
            this.elapsedReduceTime = 0L;
        }
    }

    public long getShuffleFinishTime() {
        return this.shuffleFinishTime;
    }

    public long getMergeFinishTime() {
        return this.mergeFinishTime;
    }

    public long getElapsedShuffleTime() {
        return this.elapsedShuffleTime;
    }

    public long getElapsedMergeTime() {
        return this.elapsedMergeTime;
    }

    public long getElapsedReduceTime() {
        return this.elapsedReduceTime;
    }
}

