/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRpcServerHandoff {
    public static final Logger LOG = LoggerFactory.getLogger(TestRpcServerHandoff.class);
    private static final String BIND_ADDRESS = "0.0.0.0";
    private static final Configuration conf = new Configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDeferredResponse() throws IOException, InterruptedException, ExecutionException {
        ServerForHandoffTest server = new ServerForHandoffTest(2);
        server.start();
        try {
            InetSocketAddress serverAddress = NetUtils.getConnectAddress((Server)server);
            byte[] requestBytes = this.generateRandomBytes(1024);
            ClientCallable clientCallable = new ClientCallable(serverAddress, conf, requestBytes);
            FutureTask<Writable> future = new FutureTask<Writable>(clientCallable);
            Thread clientThread = new Thread(future);
            clientThread.start();
            server.awaitInvocation();
            this.awaitResponseTimeout(future);
            server.sendResponse();
            BytesWritable response = (BytesWritable)future.get();
            Assert.assertEquals((Object)new BytesWritable(requestBytes), (Object)response);
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDeferredException() throws IOException, InterruptedException, ExecutionException {
        ServerForHandoffTest server = new ServerForHandoffTest(2);
        server.start();
        try {
            InetSocketAddress serverAddress = NetUtils.getConnectAddress((Server)server);
            byte[] requestBytes = this.generateRandomBytes(1024);
            ClientCallable clientCallable = new ClientCallable(serverAddress, conf, requestBytes);
            FutureTask<Writable> future = new FutureTask<Writable>(clientCallable);
            Thread clientThread = new Thread(future);
            clientThread.start();
            server.awaitInvocation();
            this.awaitResponseTimeout(future);
            server.sendError();
            try {
                future.get();
                Assert.fail((String)"Call succeeded. Was expecting an exception");
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Assert.assertTrue((boolean)(cause instanceof RemoteException));
                RemoteException re = (RemoteException)cause;
                Assert.assertTrue((boolean)re.toString().contains("DeferredError"));
            }
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    private void awaitResponseTimeout(FutureTask<Writable> future) throws ExecutionException, InterruptedException {
        for (long sleepTime = 3000L; sleepTime > 0L; sleepTime -= 200L) {
            try {
                future.get(200L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"Expected to timeout since the deferred response hasn't been registered");
                continue;
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        LOG.info("Done sleeping");
    }

    private byte[] generateRandomBytes(int length) {
        Random random = new Random();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(97 + random.nextInt(26));
        }
        return bytes;
    }

    private static class ClientCallable
    implements Callable<Writable> {
        private final InetSocketAddress address;
        private final Configuration conf;
        final byte[] requestBytes;

        private ClientCallable(InetSocketAddress address, Configuration conf, byte[] requestBytes) {
            this.address = address;
            this.conf = conf;
            this.requestBytes = requestBytes;
        }

        @Override
        public Writable call() throws Exception {
            Client client = new Client(BytesWritable.class, this.conf);
            BytesWritable param = new BytesWritable(this.requestBytes);
            Client.ConnectionId remoteId = Client.ConnectionId.getConnectionId((InetSocketAddress)this.address, null, null, (int)0, null, (Configuration)this.conf);
            Writable result = client.call(RPC.RpcKind.RPC_BUILTIN, (Writable)param, remoteId, new AtomicBoolean(false));
            return result;
        }
    }

    public static class ServerForHandoffTest
    extends Server {
        private final AtomicBoolean invoked = new AtomicBoolean(false);
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition invokedCondition = this.lock.newCondition();
        private volatile Writable request;
        private volatile Server.Call deferredCall;

        protected ServerForHandoffTest(int handlerCount) throws IOException {
            super(TestRpcServerHandoff.BIND_ADDRESS, 0, BytesWritable.class, handlerCount, conf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Writable call(RPC.RpcKind rpcKind, String protocol, Writable param, long receiveTime) throws Exception {
            this.request = param;
            this.deferredCall = (Server.Call)Server.getCurCall().get();
            ((Server.Call)Server.getCurCall().get()).deferResponse();
            this.lock.lock();
            try {
                this.invoked.set(true);
                this.invokedCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }

        void awaitInvocation() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.invoked.get()) {
                    this.invokedCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        void sendResponse() {
            this.deferredCall.setDeferredResponse(this.request);
        }

        void sendError() {
            this.deferredCall.setDeferredError((Throwable)new IOException("DeferredError"));
        }
    }
}

