/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public final class ClientSnapshotDescriptionUtils {
    private ClientSnapshotDescriptionUtils() {
    }

    public static void assertSnapshotRequestIsValid(HBaseProtos.SnapshotDescription snapshot) throws IllegalArgumentException {
        TableName tableName;
        TableName.isLegalTableQualifierName((byte[])Bytes.toBytes((String)snapshot.getName()), (boolean)true);
        if (snapshot.hasTable() && (tableName = TableName.valueOf((String)snapshot.getTable())).isSystemTable()) {
            throw new IllegalArgumentException("System table snapshots are not allowed");
        }
    }

    public static String toString(HBaseProtos.SnapshotDescription snapshot) {
        if (snapshot == null) {
            return null;
        }
        return "{ ss=" + snapshot.getName() + " table=" + (snapshot.hasTable() ? TableName.valueOf((String)snapshot.getTable()) : "") + " type=" + snapshot.getType() + " ttl=" + snapshot.getTtl() + " }";
    }
}

