/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.model.PartETag;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.apache.hadoop.fs.aliyun.oss.OSSDataBlocks;
import org.apache.hadoop.fs.aliyun.oss.statistics.BlockOutputStreamStatistics;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOSSBlockOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(AliyunOSSBlockOutputStream.class);
    private AliyunOSSFileSystemStore store;
    private Configuration conf;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private String key;
    private int blockSize;
    private int blockId = 0;
    private long blockWritten = 0L;
    private String uploadId = null;
    private final List<ListenableFuture<PartETag>> partETagsFutures;
    private final OSSDataBlocks.BlockFactory blockFactory;
    private final BlockOutputStreamStatistics statistics;
    private OSSDataBlocks.DataBlock activeBlock;
    private final ListeningExecutorService executorService;
    private final byte[] singleByte = new byte[1];

    public AliyunOSSBlockOutputStream(Configuration conf, AliyunOSSFileSystemStore store, String key, int blockSize, OSSDataBlocks.BlockFactory blockFactory, BlockOutputStreamStatistics statistics, ExecutorService executorService) throws IOException {
        this.store = store;
        this.conf = conf;
        this.key = key;
        this.blockSize = blockSize;
        this.blockFactory = blockFactory;
        this.statistics = statistics;
        this.partETagsFutures = new ArrayList<ListenableFuture<PartETag>>(2);
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
    }

    private synchronized OSSDataBlocks.DataBlock createBlockIfNeeded() throws IOException {
        if (this.activeBlock == null) {
            ++this.blockId;
            this.activeBlock = this.blockFactory.create(this.blockId, this.blockSize, this.statistics);
        }
        return this.activeBlock;
    }

    void checkOpen() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed.");
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkOpen();
        OSSDataBlocks.DataBlock dataBlock = this.getActiveBlock();
        if (dataBlock != null) {
            dataBlock.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        block10: {
            if (this.closed.get()) {
                LOG.debug("Ignoring close() as stream is already closed");
                return;
            }
            try {
                List<PartETag> partETags;
                if (this.uploadId == null) {
                    OSSDataBlocks.DataBlock dataBlock = this.getActiveBlock();
                    if (dataBlock == null) {
                        this.store.storeEmptyFile(this.key);
                    } else {
                        OSSDataBlocks.BlockUploadData uploadData = dataBlock.startUpload();
                        if (uploadData.hasFile()) {
                            this.store.uploadObject(this.key, uploadData.getFile());
                        } else {
                            this.store.uploadObject(this.key, uploadData.getUploadStream(), dataBlock.dataSize());
                        }
                    }
                    break block10;
                }
                if (this.blockWritten > 0L) {
                    this.uploadCurrentBlock();
                }
                if (null == (partETags = this.waitForAllPartUploads())) {
                    throw new IOException("Failed to multipart upload to oss, abort it.");
                }
                this.store.completeMultipartUpload(this.key, this.uploadId, new ArrayList<PartETag>(partETags));
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.getActiveBlock(), this.blockFactory});
                this.closed.set(true);
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.getActiveBlock(), this.blockFactory});
        this.closed.set(true);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.singleByte[0] = (byte)b;
        this.write(this.singleByte, 0, 1);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int totalWritten = 0;
        while (totalWritten < len) {
            int written = this.internalWrite(b, off + totalWritten, len - totalWritten);
            LOG.debug("Buffer len {}, written {},  total written {}", new Object[]{len, written, totalWritten += written});
        }
    }

    private synchronized int internalWrite(byte[] b, int off, int len) throws IOException {
        OSSDataBlocks.validateWriteArgs(b, off, len);
        this.checkOpen();
        if (len == 0) {
            return 0;
        }
        OSSDataBlocks.DataBlock block = this.createBlockIfNeeded();
        int written = block.write(b, off, len);
        this.blockWritten += (long)written;
        int remainingCapacity = block.remainingCapacity();
        if (written < len) {
            LOG.debug("writing more data than block has capacity -triggering upload");
            this.uploadCurrentBlock();
        } else if (remainingCapacity == 0) {
            this.uploadCurrentBlock();
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearActiveBlock() {
        if (this.activeBlock != null) {
            LOG.debug("Clearing active block");
        }
        AliyunOSSBlockOutputStream aliyunOSSBlockOutputStream = this;
        synchronized (aliyunOSSBlockOutputStream) {
            this.activeBlock = null;
        }
    }

    private synchronized OSSDataBlocks.DataBlock getActiveBlock() {
        return this.activeBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadCurrentBlock() throws IOException {
        if (this.uploadId == null) {
            this.uploadId = this.store.getUploadId(this.key);
        }
        int currentBlockId = this.blockId;
        OSSDataBlocks.DataBlock dataBlock = this.getActiveBlock();
        long size = dataBlock.dataSize();
        OSSDataBlocks.BlockUploadData uploadData = dataBlock.startUpload();
        try {
            ListenableFuture partETagFuture = this.executorService.submit(() -> {
                PartETag partETag;
                try {
                    PartETag partETag2;
                    partETag = partETag2 = this.store.uploadPart(uploadData, size, this.key, this.uploadId, currentBlockId);
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{uploadData, dataBlock});
                    throw throwable;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{uploadData, dataBlock});
                return partETag;
            });
            this.partETagsFutures.add((ListenableFuture<PartETag>)partETagFuture);
        }
        finally {
            this.blockWritten = 0L;
            this.clearActiveBlock();
        }
    }

    private List<PartETag> waitForAllPartUploads() throws IOException {
        LOG.debug("Waiting for {} uploads to complete", (Object)this.partETagsFutures.size());
        try {
            return (List)Futures.allAsList(this.partETagsFutures).get();
        }
        catch (InterruptedException ie) {
            LOG.warn("Interrupted partUpload", (Throwable)ie);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException ee) {
            LOG.debug("While waiting for upload completion", (Throwable)ee);
            LOG.debug("Cancelling futures");
            for (ListenableFuture<PartETag> future : this.partETagsFutures) {
                future.cancel(true);
            }
            this.store.abortMultipartUpload(this.key, this.uploadId);
            throw new IOException("Multi-part upload with id '" + this.uploadId + "' to " + this.key, ee);
        }
    }
}

