/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public abstract class TypeUtils {
    public static final long HOURS_PER_CENTURY = 876582L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    private static final String HEX = "#";
    private static final char START = '{';

    public static String format(String messagePattern, Object ... args) {
        if (messagePattern == null) {
            return null;
        }
        int tmpPatternSize = messagePattern.length();
        int tmpArgsCount = args.length;
        int tmpFirst = 0;
        int tmpLimit = tmpPatternSize;
        StringBuilder retVal = new StringBuilder(tmpPatternSize + tmpArgsCount * 20);
        for (int a = 0; a < tmpArgsCount; ++a) {
            tmpLimit = messagePattern.indexOf(123, tmpFirst);
            if (tmpLimit == -1) {
                retVal.append(' ');
                retVal.append(args[a]);
                continue;
            }
            retVal.append(messagePattern.substring(tmpFirst, tmpLimit));
            retVal.append(args[a]);
            tmpFirst = tmpLimit + 2;
        }
        retVal.append(messagePattern.substring(tmpFirst, tmpPatternSize));
        return retVal.toString();
    }

    public static final GregorianCalendar getHundredYearsAgo() {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.add(1, -100);
        return retVal;
    }

    public static final GregorianCalendar getThousandYearsAgo() {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.add(1, -1000);
        return retVal;
    }

    public static final GregorianCalendar getThousandYearsFromNow() {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.add(1, 1000);
        return retVal;
    }

    public static BigDecimal toBigDecimal(Number number) {
        BigDecimal retVal = BigMath.ZERO;
        if (number != null) {
            if (number instanceof BigDecimal) {
                retVal = (BigDecimal)number;
            } else if (number instanceof Scalar) {
                retVal = ((Scalar)((Object)number)).toBigDecimal();
            } else {
                try {
                    retVal = new BigDecimal(number.toString());
                }
                catch (NumberFormatException exception) {
                    double tmpVal = number.doubleValue();
                    retVal = Double.isNaN(tmpVal) ? BigMath.ZERO : (Double.isInfinite(tmpVal) && tmpVal > PrimitiveMath.ZERO ? BigMath.VERY_POSITIVE : (Double.isInfinite(tmpVal) && tmpVal < PrimitiveMath.ZERO ? BigMath.VERY_NEGATIVE : BigDecimal.valueOf(tmpVal)));
                }
            }
        }
        return retVal;
    }

    public static BigDecimal toBigDecimal(Number number, NumberContext context) {
        return context.enforce(TypeUtils.toBigDecimal(number));
    }

    public static String toHexString(int colour) {
        return HEX + Integer.toHexString(colour).substring(2);
    }

    static boolean isSameDate(Calendar aCal1, Calendar aCal2) {
        boolean retVal = aCal1.get(1) == aCal2.get(1);
        retVal = retVal && aCal1.get(2) == aCal2.get(2);
        retVal = retVal && aCal1.get(5) == aCal2.get(5);
        return retVal;
    }

    static boolean isSameTime(Calendar aCal1, Calendar aCal2) {
        boolean retVal = aCal1.get(11) == aCal2.get(11);
        retVal = retVal && aCal1.get(12) == aCal2.get(12);
        retVal = retVal && aCal1.get(13) == aCal2.get(13);
        return retVal;
    }

    protected TypeUtils() {
    }
}

