/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.RegexMountPoint;
import org.apache.hadoop.fs.viewfs.RegexMountPointResolvedDstPathReplaceInterceptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRegexMountPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TestRegexMountPoint.class.getName());
    private InodeTree inodeTree;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        ConfigUtil.addLink((Configuration)this.conf, (String)TestRegexMountPoint.class.getName(), (String)"/mnt", (URI)URI.create("file:///"));
        this.inodeTree = new InodeTree<TestRegexMountPointFileSystem>(this.conf, TestRegexMountPoint.class.getName(), null, false){

            protected Function<URI, TestRegexMountPointFileSystem> initAndGetTargetFs() {
                return new Function<URI, TestRegexMountPointFileSystem>(){

                    @Override
                    public TestRegexMountPointFileSystem apply(URI uri) {
                        return new TestRegexMountPointFileSystem(uri);
                    }
                };
            }

            protected TestRegexMountPointFileSystem getTargetFileSystem(InodeTree.INodeDir<TestRegexMountPointFileSystem> dir) {
                return new TestRegexMountPointFileSystem(null);
            }

            protected TestRegexMountPointFileSystem getTargetFileSystem(String settings, URI[] mergeFsURIList) {
                return new TestRegexMountPointFileSystem(null);
            }
        };
    }

    @After
    public void tearDown() throws Exception {
        this.inodeTree = null;
    }

    @Test
    public void testGetVarListInString() throws IOException {
        String srcRegex = "/(\\w+)";
        String target = "/$0/${1}/$1/${2}/${2}";
        RegexMountPoint regexMountPoint = new RegexMountPoint(this.inodeTree, srcRegex, target, null);
        regexMountPoint.initialize();
        Map varMap = regexMountPoint.getVarInDestPathMap();
        Assert.assertEquals((long)varMap.size(), (long)3L);
        Assert.assertEquals((long)((Set)varMap.get("0")).size(), (long)1L);
        Assert.assertTrue((boolean)((Set)varMap.get("0")).contains("$0"));
        Assert.assertEquals((long)((Set)varMap.get("1")).size(), (long)2L);
        Assert.assertTrue((boolean)((Set)varMap.get("1")).contains("${1}"));
        Assert.assertTrue((boolean)((Set)varMap.get("1")).contains("$1"));
        Assert.assertEquals((long)((Set)varMap.get("2")).size(), (long)1L);
        Assert.assertTrue((boolean)((Set)varMap.get("2")).contains("${2}"));
    }

    @Test
    public void testResolve() throws IOException {
        String regexStr = "^/user/(?<username>\\w+)";
        String dstPathStr = "/namenode1/testResolve/$username";
        String settingsStr = null;
        RegexMountPoint regexMountPoint = new RegexMountPoint(this.inodeTree, regexStr, dstPathStr, settingsStr);
        regexMountPoint.initialize();
        InodeTree.ResolveResult resolveResult = regexMountPoint.resolve("/user/hadoop/file1", true);
        Assert.assertEquals((Object)resolveResult.kind, (Object)InodeTree.ResultKind.EXTERNAL_DIR);
        Assert.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestRegexMountPointFileSystem));
        Assert.assertEquals((Object)"/user/hadoop", (Object)resolveResult.resolvedPath);
        Assert.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestRegexMountPointFileSystem));
        Assert.assertEquals((Object)"/namenode1/testResolve/hadoop", (Object)((TestRegexMountPointFileSystem)resolveResult.targetFileSystem).getUri().toString());
        Assert.assertEquals((Object)"/file1", (Object)resolveResult.remainingPath.toString());
    }

    @Test
    public void testResolveWithInterceptor() throws IOException {
        String regexStr = "^/user/(?<username>\\w+)";
        String dstPathStr = "/namenode1/testResolve/$username";
        RegexMountPointResolvedDstPathReplaceInterceptor interceptor = new RegexMountPointResolvedDstPathReplaceInterceptor("_", "-");
        String settingsStr = interceptor.serializeToString();
        RegexMountPoint regexMountPoint = new RegexMountPoint(this.inodeTree, regexStr, dstPathStr, settingsStr);
        regexMountPoint.initialize();
        InodeTree.ResolveResult resolveResult = regexMountPoint.resolve("/user/hadoop_user1/file_index", true);
        Assert.assertEquals((Object)resolveResult.kind, (Object)InodeTree.ResultKind.EXTERNAL_DIR);
        Assert.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestRegexMountPointFileSystem));
        Assert.assertEquals((Object)"/user/hadoop_user1", (Object)resolveResult.resolvedPath);
        Assert.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestRegexMountPointFileSystem));
        Assert.assertEquals((Object)"/namenode1/testResolve/hadoop-user1", (Object)((TestRegexMountPointFileSystem)resolveResult.targetFileSystem).getUri().toString());
        Assert.assertEquals((Object)"/file_index", (Object)resolveResult.remainingPath.toString());
    }

    class TestRegexMountPointFileSystem {
        private URI uri;

        public URI getUri() {
            return this.uri;
        }

        TestRegexMountPointFileSystem(URI uri) {
            String uriStr = uri == null ? "null" : uri.toString();
            LOGGER.info("Create TestRegexMountPointFileSystem Via URI:" + uriStr);
            this.uri = uri;
        }
    }
}

