/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.messages;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.javax.websocket.MessageHandler;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageAppender;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.MessageHandlerWrapper;

public class BinaryPartialMessage
implements MessageAppender {
    private final MessageHandlerWrapper msgWrapper;
    private final MessageHandler.Partial<Object> partialHandler;

    public BinaryPartialMessage(MessageHandlerWrapper wrapper) {
        this.msgWrapper = wrapper;
        this.partialHandler = (MessageHandler.Partial)wrapper.getHandler();
    }

    public void appendFrame(ByteBuffer payload, boolean isLast) throws IOException {
        if (this.msgWrapper.isMessageType(ByteBuffer.class)) {
            this.partialHandler.onMessage(payload == null ? BufferUtil.EMPTY_BUFFER : payload.slice(), isLast);
            return;
        }
        if (this.msgWrapper.isMessageType(byte[].class)) {
            this.partialHandler.onMessage(payload == null ? new byte[]{} : BufferUtil.toArray((ByteBuffer)payload), isLast);
            return;
        }
        StringBuilder err = new StringBuilder();
        err.append(this.msgWrapper.getHandler().getClass());
        err.append(" does not implement an expected ");
        err.append(MessageHandler.Partial.class.getName());
        err.append(" of type ");
        err.append(ByteBuffer.class.getName());
        err.append(" or byte[]");
        throw new IllegalStateException(err.toString());
    }

    public void messageComplete() {
    }
}

