/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.domain;

import org.apache.groovy.contracts.util.Validate;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;

public abstract class Assertion<T extends Assertion> {
    private BlockStatement originalBlockStatement;
    private BooleanExpression booleanExpression;

    public Assertion() {
        this.booleanExpression = GeneralUtils.boolX((Expression)ConstantExpression.TRUE);
    }

    public Assertion(BlockStatement blockStatement, BooleanExpression booleanExpression) {
        Validate.notNull(booleanExpression);
        this.originalBlockStatement = blockStatement;
        this.booleanExpression = booleanExpression;
    }

    public BooleanExpression booleanExpression() {
        return this.booleanExpression;
    }

    public BlockStatement originalBlockStatement() {
        return this.originalBlockStatement;
    }

    public void renew(BooleanExpression booleanExpression) {
        Validate.notNull(booleanExpression);
        this.booleanExpression = booleanExpression;
    }

    public void and(T other) {
        Validate.notNull(other);
        BooleanExpression newBooleanExpression = GeneralUtils.boolX((Expression)GeneralUtils.andX((Expression)this.booleanExpression(), (Expression)((Assertion)other).booleanExpression()));
        newBooleanExpression.setSourcePosition((ASTNode)this.booleanExpression());
        this.renew(newBooleanExpression);
    }

    public void or(T other) {
        Validate.notNull(other);
        BooleanExpression newBooleanExpression = GeneralUtils.boolX((Expression)GeneralUtils.orX((Expression)this.booleanExpression(), (Expression)((Assertion)other).booleanExpression()));
        newBooleanExpression.setSourcePosition((ASTNode)this.booleanExpression());
        this.renew(newBooleanExpression);
    }
}

