/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactions.lean;

import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.GammaObject;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;
import org.multiverse.stms.gamma.transactions.GammaTxnConfig;
import org.multiverse.utils.Bugshaker;

public final class LeanFixedLengthGammaTxn
extends GammaTxn {
    public Tranlocal head;
    public int size = 0;
    public boolean hasReads = false;
    public final Listeners[] listenersArray;

    public LeanFixedLengthGammaTxn(GammaStm stm) {
        this(new GammaTxnConfig(stm));
    }

    public LeanFixedLengthGammaTxn(GammaTxnConfig config) {
        super(config, 2);
        this.listenersArray = new Listeners[config.maxFixedLengthTransactionSize];
        Tranlocal h = null;
        for (int k = 0; k < config.maxFixedLengthTransactionSize; ++k) {
            Tranlocal newNode = new Tranlocal();
            if (h != null) {
                h.previous = newNode;
                newNode.next = h;
            }
            h = newNode;
        }
        this.head = h;
    }

    @Override
    public final boolean isReadConsistent(Tranlocal justAdded) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void commit() {
        int s = this.status;
        if (s == 4) {
            return;
        }
        if (s != 1 && s != 2) {
            throw this.abortCommitOnBadStatus();
        }
        if (this.hasWrites) {
            BaseGammaTxnRef owner;
            GammaObject conflictingObject;
            if (s == 1 && (conflictingObject = this.prepareChainForCommit()) != null) {
                throw this.abortOnReadWriteConflict(conflictingObject);
            }
            if (this.commitConflict) {
                this.config.globalConflictCounter.signalConflict();
            }
            int listenersIndex = 0;
            Tranlocal node = this.head;
            while ((owner = node.owner) != null) {
                Listeners listeners;
                if (SHAKE_BUGS) {
                    Bugshaker.shakeBugs();
                }
                if ((listeners = owner.leanCommit(node)) != null) {
                    this.listenersArray[listenersIndex] = listeners;
                    ++listenersIndex;
                }
                if ((node = node.next) != null) continue;
            }
            if (this.listenersArray != null) {
                Listeners.openAll(this.listenersArray, this.pool);
            }
        } else {
            this.releaseReadonlyChain();
        }
        this.status = 4;
    }

    @Override
    public final void prepare() {
        if (this.status == 2) {
            return;
        }
        if (this.status != 1) {
            throw this.abortPrepareOnBadStatus();
        }
        GammaObject conflictingObject = this.prepareChainForCommit();
        if (conflictingObject != null) {
            throw this.abortOnReadWriteConflict(conflictingObject);
        }
        this.status = 2;
    }

    private GammaObject prepareChainForCommit() {
        Tranlocal node = this.head;
        do {
            BaseGammaTxnRef owner;
            if ((owner = node.owner) == null) {
                return null;
            }
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if (node.mode == 4) continue;
            long version = node.version;
            if (owner.version != version) {
                return owner;
            }
            int arriveStatus = owner.arriveAndExclusiveLock(64);
            if (arriveStatus == 0) {
                return owner;
            }
            if ((arriveStatus & 4) != 0) {
                this.commitConflict = true;
            }
            node.hasDepartObligation = (arriveStatus & 2) == 0;
            node.lockMode = 3;
            if (owner.version != version) {
                return owner;
            }
            node = node.next;
        } while (node != null);
        return null;
    }

    @Override
    public final void abort() {
        if (this.status == 3) {
            return;
        }
        if (this.status == 4) {
            throw this.failAbortOnAlreadyCommitted();
        }
        this.releaseChainForAbort();
        this.status = 3;
    }

    private void releaseChainForAbort() {
        Tranlocal node = this.head;
        do {
            BaseGammaTxnRef owner;
            if ((owner = node.owner) == null) {
                return;
            }
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if (node.isWrite() && node.getLockMode() == 3) {
                if (node.hasDepartObligation()) {
                    node.setDepartObligation(false);
                    owner.departAfterFailureAndUnlock();
                } else {
                    owner.unlockByUnregistered();
                }
                node.setLockMode(0);
            }
            node.owner = null;
            node.ref_oldValue = null;
            node.ref_value = null;
        } while ((node = node.next) != null);
    }

    private void releaseReadonlyChain() {
        Tranlocal node = this.head;
        do {
            BaseGammaTxnRef owner;
            if ((owner = node.owner) == null) {
                return;
            }
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            node.owner = null;
            node.ref_oldValue = null;
            node.ref_value = null;
        } while ((node = node.next) != null);
    }

    @Override
    public final Tranlocal getRefTranlocal(BaseGammaTxnRef ref) {
        Tranlocal node = this.head;
        do {
            if (node.owner == ref) {
                return node;
            }
            if (node.owner != null) continue;
            return null;
        } while ((node = node.next) != null);
        return null;
    }

    @Override
    public final void retry() {
        if (this.status != 1) {
            throw this.abortRetryOnBadStatus();
        }
        if (!this.config.isBlockingAllowed()) {
            throw this.abortRetryOnNoBlockingAllowed();
        }
        if (this.size == 0) {
            throw this.abortRetryOnNoRetryPossible();
        }
        this.retryListener.reset();
        long listenerEra = this.retryListener.getEra();
        boolean furtherRegistrationNeeded = true;
        boolean atLeastOneRegistration = false;
        Tranlocal tranlocal = this.head;
        do {
            BaseGammaTxnRef owner = tranlocal.owner;
            if (furtherRegistrationNeeded) {
                switch (owner.registerChangeListener(this.retryListener, tranlocal, this.pool, listenerEra)) {
                    case 0: {
                        atLeastOneRegistration = true;
                        break;
                    }
                    case 1: {
                        furtherRegistrationNeeded = false;
                        atLeastOneRegistration = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            owner.releaseAfterFailure(tranlocal, this.pool);
        } while ((tranlocal = tranlocal.next) != null && tranlocal.owner != null);
        this.status = 3;
        if (!atLeastOneRegistration) {
            throw this.abortRetryOnNoRetryPossible();
        }
        throw this.newRetryError();
    }

    @Override
    public final Tranlocal locate(BaseGammaTxnRef o) {
        if (this.status != 1) {
            throw this.abortLocateOnBadStatus(o);
        }
        if (o == null) {
            throw this.abortLocateOnNullArgument();
        }
        return this.getRefTranlocal(o);
    }

    @Override
    public final void hardReset() {
        this.status = 1;
        this.hasWrites = false;
        this.size = 0;
        this.remainingTimeoutNs = this.config.timeoutNs;
        this.attempt = 1;
        this.commitConflict = false;
        this.hasReads = false;
    }

    @Override
    public final boolean softReset() {
        if (this.attempt >= this.config.getMaxRetries()) {
            return false;
        }
        this.commitConflict = false;
        this.status = 1;
        this.hasWrites = false;
        this.size = 0;
        this.hasReads = false;
        ++this.attempt;
        return true;
    }

    public final void shiftInFront(Tranlocal newHead) {
        if (newHead == this.head) {
            return;
        }
        this.head.previous = newHead;
        if (newHead.next != null) {
            newHead.next.previous = newHead.previous;
        }
        newHead.previous.next = newHead.next;
        newHead.next = this.head;
        newHead.previous = null;
        this.head = newHead;
    }

    @Override
    public void initLocalConflictCounter() {
    }
}

