/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.connector.GenericColumn;
import org.apache.gravitino.connector.GenericTable;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.ColumnEntity;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.PrincipalUtils;

public abstract class ManagedTableOperations
implements TableCatalog {
    private static final Joiner DOT = Joiner.on((String)".");

    protected abstract EntityStore store();

    protected abstract SupportsSchemas schemas();

    protected abstract IdGenerator idGenerator();

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        try {
            List<TableEntity> tables = this.store().list(namespace, TableEntity.class, Entity.EntityType.TABLE);
            return (NameIdentifier[])tables.stream().map(t -> NameIdentifier.of((Namespace)namespace, (String)t.name())).toArray(NameIdentifier[]::new);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchSchemaException((Throwable)e, "Schema %s does not exist", new Object[]{namespace});
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to list tables in schema " + String.valueOf(namespace), e);
        }
    }

    public Table loadTable(NameIdentifier ident) throws NoSuchTableException {
        try {
            TableEntity tableEntity = this.store().get(ident, Entity.EntityType.TABLE, TableEntity.class);
            return this.toGenericTable(tableEntity);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchTableException((Throwable)e, "Table %s does not exist", new Object[]{ident});
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load table " + String.valueOf(ident), e);
        }
    }

    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        StringIdentifier stringId = StringIdentifier.fromProperties(properties);
        Preconditions.checkArgument((stringId != null ? 1 : 0) != 0, (Object)"Property String identifier should not be null");
        AuditInfo auditInfo = AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build();
        TableEntity tableEntity = TableEntity.builder().withName(ident.name()).withId(stringId.id()).withNamespace(ident.namespace()).withComment(comment).withColumns(this.toColumnEntities(columns, auditInfo, this.idGenerator())).withProperties(properties).withPartitioning(partitions).withDistribution(distribution).withSortOrders(sortOrders).withIndexes(indexes).withAuditInfo(auditInfo).build();
        try {
            this.store().put(tableEntity, false);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchSchemaException((Throwable)e, "Schema %s does not exist", new Object[]{ident.namespace()});
        }
        catch (EntityAlreadyExistsException e) {
            throw new TableAlreadyExistsException((Throwable)((Object)e), "Table %s already exists", new Object[]{ident});
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create table " + String.valueOf(ident), e);
        }
        return this.toGenericTable(tableEntity);
    }

    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        try {
            TableEntity newTableEntity = this.store().update(ident, TableEntity.class, Entity.EntityType.TABLE, oldEntity -> this.applyChanges((TableEntity)oldEntity, changes));
            return this.toGenericTable(newTableEntity);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchTableException((Throwable)e, "Table %s does not exist", new Object[]{ident});
        }
        catch (EntityAlreadyExistsException e) {
            throw new IllegalArgumentException("Failed to rename table " + String.valueOf(ident) + " due to table already exists: ", (Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to alter table " + String.valueOf(ident), e);
        }
    }

    public boolean purgeTable(NameIdentifier ident) {
        return this.dropTable(ident);
    }

    public boolean dropTable(NameIdentifier ident) {
        try {
            return this.store().delete(ident, Entity.EntityType.TABLE);
        }
        catch (NoSuchEntityException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to drop metadata for table " + String.valueOf(ident), e);
        }
    }

    private TableEntity applyChanges(TableEntity oldTableEntity, TableChange ... changes) {
        String newName = oldTableEntity.name();
        String newComment = oldTableEntity.comment();
        HashMap newProps = Maps.newHashMap(oldTableEntity.properties());
        List<Object> newColumns = Lists.newArrayList(oldTableEntity.columns());
        ArrayList newIndexes = Lists.newArrayList((Object[])oldTableEntity.indexes());
        Map<Boolean, List<TableChange>> splitChanges = Arrays.stream(changes).collect(Collectors.partitioningBy(change -> change instanceof TableChange.ColumnChange));
        List<TableChange.ColumnChange> columnChanges = splitChanges.get(true).stream().map(change -> (TableChange.ColumnChange)change).collect(Collectors.toList());
        List<TableChange> tableChanges = splitChanges.get(false);
        for (TableChange change2 : tableChanges) {
            if (change2 instanceof TableChange.RenameTable) {
                TableChange.RenameTable rename = (TableChange.RenameTable)change2;
                if (rename.getNewSchemaName().isPresent()) {
                    throw new IllegalArgumentException("Gravitino managed table doesn't support renaming the table across schemas for now");
                }
                newName = rename.getNewName();
                continue;
            }
            if (change2 instanceof TableChange.UpdateComment) {
                TableChange.UpdateComment updateComment = (TableChange.UpdateComment)change2;
                newComment = updateComment.getNewComment();
                continue;
            }
            if (change2 instanceof TableChange.SetProperty) {
                TableChange.SetProperty setProperty = (TableChange.SetProperty)change2;
                newProps.put(setProperty.getProperty(), setProperty.getValue());
                continue;
            }
            if (change2 instanceof TableChange.RemoveProperty) {
                TableChange.RemoveProperty removeProperty = (TableChange.RemoveProperty)change2;
                newProps.remove(removeProperty.getProperty());
                continue;
            }
            if (change2 instanceof TableChange.AddIndex) {
                TableChange.AddIndex addIndex = (TableChange.AddIndex)change2;
                Index newIndex = Indexes.IndexImpl.builder().withName(addIndex.getName()).withFieldNames(addIndex.getFieldNames()).withIndexType(addIndex.getType()).build();
                newIndexes.add(newIndex);
                continue;
            }
            if (change2 instanceof TableChange.DeleteIndex) {
                TableChange.DeleteIndex deleteIndex = (TableChange.DeleteIndex)change2;
                boolean removed = newIndexes.removeIf(idx -> idx.name().equals(deleteIndex.getName()));
                if (removed || deleteIndex.isIfExists()) continue;
                throw new IllegalArgumentException(String.format("Index %s does not exist while ifExists is false", deleteIndex.getName()));
            }
            throw new IllegalArgumentException("Unsupported table change: " + String.valueOf(change2));
        }
        newColumns = this.applyColumnChanges(newColumns, columnChanges);
        return TableEntity.builder().withId(oldTableEntity.id()).withName(newName).withNamespace(oldTableEntity.namespace()).withComment(newComment).withColumns(newColumns).withProperties(newProps).withPartitioning(oldTableEntity.partitioning()).withDistribution(oldTableEntity.distribution()).withSortOrders(oldTableEntity.sortOrders()).withIndexes((Index[])newIndexes.toArray(Index[]::new)).withAuditInfo(AuditInfo.builder().withCreator(oldTableEntity.auditInfo().creator()).withCreateTime(oldTableEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build();
    }

    private List<ColumnEntity> applyColumnChanges(List<ColumnEntity> oldColumns, List<TableChange.ColumnChange> columnChanges) {
        List<ColumnEntity> newColumns = Lists.newArrayList(oldColumns).stream().sorted(Comparator.comparingInt(ColumnEntity::position)).collect(Collectors.toList());
        for (TableChange.ColumnChange change : columnChanges) {
            if (change instanceof TableChange.AddColumn) {
                TableChange.AddColumn addColumn = (TableChange.AddColumn)change;
                String columnName = DOT.join((Object[])addColumn.getFieldName());
                boolean exists = newColumns.stream().anyMatch(col -> col.name().equals(columnName));
                if (exists) {
                    throw new IllegalArgumentException(String.format("Column %s already exists", columnName));
                }
                int position = this.calculateColumnPosition(newColumns, addColumn.getPosition(), true);
                ColumnEntity columnToAdd = ColumnEntity.builder().withId(this.idGenerator().nextId()).withName(DOT.join((Object[])addColumn.getFieldName())).withDataType(addColumn.getDataType()).withPosition(position).withComment(addColumn.getComment()).withNullable(addColumn.isNullable()).withAutoIncrement(addColumn.isAutoIncrement()).withDefaultValue(addColumn.getDefaultValue()).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
                newColumns.add(position, columnToAdd);
                continue;
            }
            if (change instanceof TableChange.RenameColumn || change instanceof TableChange.UpdateColumnDefaultValue || change instanceof TableChange.UpdateColumnType || change instanceof TableChange.UpdateColumnComment || change instanceof TableChange.UpdateColumnPosition || change instanceof TableChange.UpdateColumnNullability || change instanceof TableChange.UpdateColumnAutoIncrement) {
                Optional<Boolean> optional;
                Optional<Boolean> newNullable;
                Optional<String> newComment;
                Optional<Type> newDataType;
                Optional<Expression> newDefaultValue;
                ColumnEntity oldColumn = null;
                for (int i = 0; i < newColumns.size(); ++i) {
                    ColumnEntity col2 = newColumns.get(i);
                    if (!col2.name().equals(DOT.join((Object[])change.fieldName()))) continue;
                    oldColumn = col2;
                    break;
                }
                if (oldColumn == null) {
                    throw new IllegalArgumentException(String.format("Column %s not found for %s", DOT.join((Object[])change.fieldName()), change.getClass().getSimpleName()));
                }
                newColumns.remove(oldColumn);
                Optional<String> newName = Optional.empty();
                if (change instanceof TableChange.RenameColumn) {
                    TableChange.RenameColumn rename = (TableChange.RenameColumn)change;
                    boolean columnExists = newColumns.stream().anyMatch(col -> col.name().equals(rename.getNewName()));
                    if (columnExists) {
                        throw new IllegalArgumentException(String.format("Column %s already exists when renaming column %s", rename.getNewName(), DOT.join((Object[])change.fieldName())));
                    }
                    newName = Optional.of(rename.getNewName());
                }
                if (change instanceof TableChange.UpdateColumnDefaultValue) {
                    TableChange.UpdateColumnDefaultValue updateDefault = (TableChange.UpdateColumnDefaultValue)change;
                    v0 = Optional.of(updateDefault.getNewDefaultValue());
                } else {
                    v0 = newDefaultValue = Optional.empty();
                }
                if (change instanceof TableChange.UpdateColumnType) {
                    TableChange.UpdateColumnType updateType = (TableChange.UpdateColumnType)change;
                    v1 = Optional.of(updateType.getNewDataType());
                } else {
                    v1 = newDataType = Optional.empty();
                }
                if (change instanceof TableChange.UpdateColumnComment) {
                    TableChange.UpdateColumnComment updateComment = (TableChange.UpdateColumnComment)change;
                    v2 = Optional.of(updateComment.getNewComment());
                } else {
                    v2 = newComment = Optional.empty();
                }
                if (change instanceof TableChange.UpdateColumnNullability) {
                    TableChange.UpdateColumnNullability updateNullability = (TableChange.UpdateColumnNullability)change;
                    v3 = Optional.of(updateNullability.nullable());
                } else {
                    v3 = newNullable = Optional.empty();
                }
                if (change instanceof TableChange.UpdateColumnAutoIncrement) {
                    TableChange.UpdateColumnAutoIncrement updateAutoIncrement = (TableChange.UpdateColumnAutoIncrement)change;
                    optional = Optional.of(updateAutoIncrement.isAutoIncrement());
                } else {
                    optional = Optional.empty();
                }
                Optional<Boolean> newAutoIncrement = optional;
                Optional<Integer> newPosition = Optional.empty();
                if (change instanceof TableChange.UpdateColumnPosition) {
                    TableChange.UpdateColumnPosition updateColumnPosition = (TableChange.UpdateColumnPosition)change;
                    newPosition = Optional.of(this.calculateColumnPosition(newColumns, updateColumnPosition.getPosition(), false));
                }
                ColumnEntity newColumn = this.updateColumnEntity(oldColumn, newName, newDefaultValue, newDataType, newComment, newPosition, newNullable, newAutoIncrement);
                newColumns.add(newColumn.position(), newColumn);
                continue;
            }
            if (change instanceof TableChange.DeleteColumn) {
                TableChange.DeleteColumn deleteColumn = (TableChange.DeleteColumn)change;
                boolean removed = newColumns.removeIf(col -> col.name().equals(DOT.join((Object[])deleteColumn.fieldName())));
                if (removed || deleteColumn.getIfExists().booleanValue()) continue;
                throw new IllegalArgumentException(String.format("Column %s not found for deletion while ifExists is false", DOT.join((Object[])deleteColumn.fieldName())));
            }
            throw new IllegalArgumentException("Unsupported column change: " + String.valueOf(change));
        }
        return this.updateColumnPositions(newColumns);
    }

    private ColumnEntity updateColumnEntity(ColumnEntity oldColumn, Optional<String> newName, Optional<Expression> newDefaultValue, Optional<Type> newDataType, Optional<String> newComment, Optional<Integer> newPosition, Optional<Boolean> newNullable, Optional<Boolean> newAutoIncrement) {
        return ColumnEntity.builder().withId(oldColumn.id()).withName(newName.orElse(oldColumn.name())).withDataType(newDataType.orElse(oldColumn.dataType())).withPosition(newPosition.orElse(oldColumn.position())).withComment(newComment.orElse(oldColumn.comment())).withNullable(newNullable.orElse(oldColumn.nullable())).withAutoIncrement(newAutoIncrement.orElse(oldColumn.autoIncrement())).withDefaultValue(newDefaultValue.orElse(oldColumn.defaultValue())).withAuditInfo(AuditInfo.builder().withCreator(oldColumn.auditInfo().creator()).withCreateTime(oldColumn.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build();
    }

    private GenericColumn toGenericColumn(ColumnEntity columnEntity) {
        return (GenericColumn)((GenericColumn.Builder)((GenericColumn.Builder)((GenericColumn.Builder)((GenericColumn.Builder)((GenericColumn.Builder)((GenericColumn.Builder)GenericColumn.builder().withName(columnEntity.name())).withComment(columnEntity.comment())).withAutoIncrement(columnEntity.autoIncrement())).withNullable(columnEntity.nullable())).withType(columnEntity.dataType())).withDefaultValue(columnEntity.defaultValue())).build();
    }

    private GenericTable toGenericTable(TableEntity tableEntity) {
        return (GenericTable)((GenericTable.Builder)((GenericTable.Builder)((GenericTable.Builder)((GenericTable.Builder)((GenericTable.Builder)((GenericTable.Builder)((GenericTable.Builder)((GenericTable.Builder)((GenericTable.Builder)GenericTable.builder().withName(tableEntity.name())).withComment(tableEntity.comment())).withColumns((Column[])tableEntity.columns().stream().map(this::toGenericColumn).toArray(Column[]::new))).withProperties(tableEntity.properties())).withAuditInfo(tableEntity.auditInfo())).withSortOrders(tableEntity.sortOrders())).withPartitioning(tableEntity.partitioning())).withDistribution(tableEntity.distribution())).withIndexes(tableEntity.indexes())).build();
    }

    private List<ColumnEntity> toColumnEntities(Column[] columns, AuditInfo audit, IdGenerator idGenerator) {
        return columns == null ? Collections.emptyList() : IntStream.range(0, columns.length).mapToObj(i -> ColumnEntity.toColumnEntity(columns[i], i, idGenerator.nextId(), audit)).collect(Collectors.toList());
    }

    private List<ColumnEntity> updateColumnPositions(List<ColumnEntity> columns) {
        ArrayList updatedColumns = Lists.newArrayList();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnEntity oldColumn = columns.get(i);
            if (oldColumn.position() != i) {
                ColumnEntity newColumn = ColumnEntity.builder().withId(oldColumn.id()).withName(oldColumn.name()).withDataType(oldColumn.dataType()).withPosition(i).withComment(oldColumn.comment()).withNullable(oldColumn.nullable()).withAutoIncrement(oldColumn.autoIncrement()).withDefaultValue(oldColumn.defaultValue()).withAuditInfo((AuditInfo)oldColumn.auditInfo()).build();
                updatedColumns.add(newColumn);
                continue;
            }
            updatedColumns.add(oldColumn);
        }
        return updatedColumns;
    }

    int calculateColumnPosition(List<ColumnEntity> existingColumns, TableChange.ColumnPosition position, boolean forAdd) {
        if (position == TableChange.ColumnPosition.first()) {
            return 0;
        }
        if (position instanceof TableChange.After) {
            TableChange.After afterColumn = (TableChange.After)position;
            for (int i = 0; i < existingColumns.size(); ++i) {
                if (!existingColumns.get(i).name().equals(afterColumn.getColumn())) continue;
                return i + 1;
            }
            throw new IllegalArgumentException(String.format("Column %s not found for adding column after it", afterColumn.getColumn()));
        }
        if (forAdd && position == TableChange.ColumnPosition.defaultPos()) {
            return existingColumns.size();
        }
        throw new IllegalArgumentException("Unsupported column position: " + String.valueOf(position));
    }
}

