/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.GenericPolicy;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.policy.PolicyDTO;
import org.apache.gravitino.dto.requests.PoliciesAssociateRequest;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.PolicyListResponse;
import org.apache.gravitino.dto.responses.PolicyResponse;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.SupportsPolicies;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;

class MetadataObjectPolicyOperations
implements SupportsPolicies {
    private final String metalakeName;
    private final RESTClient restClient;
    private final String policyRequestPath;

    MetadataObjectPolicyOperations(String metalakeName, MetadataObject metadataObject, RESTClient restClient) {
        this.metalakeName = metalakeName;
        this.restClient = restClient;
        this.policyRequestPath = String.format("api/metalakes/%s/objects/%s/%s/policies", RESTUtils.encodeString((String)metalakeName), metadataObject.type().name().toLowerCase(Locale.ROOT), RESTUtils.encodeString((String)metadataObject.fullName()));
    }

    public String[] listPolicies() {
        NameListResponse resp = this.restClient.get(this.policyRequestPath, NameListResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        resp.validate();
        return resp.getNames();
    }

    public Policy[] listPolicyInfos() {
        PolicyListResponse resp = this.restClient.get(this.policyRequestPath, (Map<String, String>)ImmutableMap.of((Object)"details", (Object)"true"), PolicyListResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        resp.validate();
        return (Policy[])Arrays.stream(resp.getPolicies()).map(policyDTO -> new GenericPolicy((PolicyDTO)policyDTO, this.restClient, this.metalakeName)).toArray(Policy[]::new);
    }

    public Policy getPolicy(String name) throws NoSuchPolicyException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"Policy name must not be null or empty");
        PolicyResponse resp = this.restClient.get(this.policyRequestPath + "/" + RESTUtils.encodeString((String)name), PolicyResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        resp.validate();
        return new GenericPolicy(resp.getPolicy(), this.restClient, this.metalakeName);
    }

    public String[] associatePolicies(String[] policiesToAdd, String[] policiesToRemove) {
        PoliciesAssociateRequest request = new PoliciesAssociateRequest(policiesToAdd, policiesToRemove);
        request.validate();
        NameListResponse resp = this.restClient.post(this.policyRequestPath, (RESTRequest)request, NameListResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        resp.validate();
        return resp.getNames();
    }
}

