/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.oss.credential;

import java.util.Map;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialProvider;
import org.apache.gravitino.credential.OSSSecretKeyCredential;
import org.apache.gravitino.credential.config.OSSCredentialConfig;

public class OSSSecretKeyProvider
implements CredentialProvider {
    private String accessKey;
    private String secretKey;

    public void initialize(Map<String, String> properties) {
        OSSCredentialConfig ossCredentialConfig = new OSSCredentialConfig(properties);
        this.accessKey = ossCredentialConfig.accessKeyID();
        this.secretKey = ossCredentialConfig.secretAccessKey();
    }

    public void close() {
    }

    public String credentialType() {
        return "oss-secret-key";
    }

    public Credential getCredential(CredentialContext context) {
        return new OSSSecretKeyCredential(this.accessKey, this.secretKey);
    }
}

