/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class DecimalColumnVector
extends ColumnVector {
    public HiveDecimalWritable[] vector;
    public short scale;
    public short precision;

    public DecimalColumnVector(int precision, int scale) {
        this(1024, precision, scale);
    }

    public DecimalColumnVector(int size, int precision, int scale) {
        super(size);
        this.precision = (short)precision;
        this.scale = (short)scale;
        this.vector = new HiveDecimalWritable[size];
        for (int i = 0; i < size; ++i) {
            this.vector[i] = new HiveDecimalWritable(0L);
        }
    }

    public void fill(HiveDecimal value) {
        this.noNulls = true;
        this.isRepeating = true;
        if (this.vector[0] == null) {
            this.vector[0] = new HiveDecimalWritable(value);
        } else {
            this.vector[0].set(value);
        }
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.isRepeating) {
            inputElementNum = 0;
        }
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            this.vector[outElementNum].set(((DecimalColumnVector)inputVector).vector[inputElementNum], (int)this.precision, (int)this.scale);
            if (!this.vector[outElementNum].isSet()) {
                this.isNull[outElementNum] = true;
                this.noNulls = false;
            } else {
                this.isNull[outElementNum] = false;
            }
        } else {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append(this.vector[row].toString());
        } else {
            buffer.append("null");
        }
    }

    public void set(int elementNum, HiveDecimalWritable writeable) {
        this.vector[elementNum].set(writeable, (int)this.precision, (int)this.scale);
        if (!this.vector[elementNum].isSet()) {
            this.noNulls = false;
            this.isNull[elementNum] = true;
        } else {
            this.isNull[elementNum] = false;
        }
    }

    public void set(int elementNum, HiveDecimal hiveDec) {
        this.vector[elementNum].set(hiveDec, (int)this.precision, (int)this.scale);
        if (!this.vector[elementNum].isSet()) {
            this.noNulls = false;
            this.isNull[elementNum] = true;
        } else {
            this.isNull[elementNum] = false;
        }
    }

    public void setNullDataValue(int elementNum) {
        this.vector[elementNum].setFromLongAndScale(1L, this.scale);
    }

    @Override
    public void ensureSize(int size, boolean preserveData) {
        super.ensureSize(size, preserveData);
        if (size <= this.vector.length) {
            return;
        }
        HiveDecimalWritable[] oldArray = this.vector;
        this.vector = new HiveDecimalWritable[size];
        int initPos = 0;
        if (preserveData) {
            initPos = oldArray.length;
            System.arraycopy(oldArray, 0, this.vector, 0, oldArray.length);
        }
        for (int i = initPos; i < this.vector.length; ++i) {
            this.vector[i] = new HiveDecimalWritable(0L);
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        DecimalColumnVector other = (DecimalColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.scale = this.scale;
        other.precision = this.precision;
        other.vector = this.vector;
    }
}

