/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.gcs.credential;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.CredentialAccessBoundary;
import com.google.auth.oauth2.DownscopedCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialGenerator;
import org.apache.gravitino.credential.GCSTokenCredential;
import org.apache.gravitino.credential.PathBasedCredentialContext;
import org.apache.gravitino.credential.config.GCSCredentialConfig;

public class GCSTokenGenerator
implements CredentialGenerator<GCSTokenCredential> {
    private static final String INITIAL_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private GoogleCredentials sourceCredentials;

    public void initialize(Map<String, String> properties) {
        GCSCredentialConfig gcsCredentialConfig = new GCSCredentialConfig(properties);
        try {
            this.sourceCredentials = this.getSourceCredentials(gcsCredentialConfig).createScoped(new String[]{INITIAL_SCOPE});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GCSTokenCredential generate(CredentialContext context) throws IOException {
        if (!(context instanceof PathBasedCredentialContext)) {
            return null;
        }
        PathBasedCredentialContext pathBasedCredentialContext = (PathBasedCredentialContext)context;
        AccessToken accessToken = this.getToken(this.sourceCredentials, pathBasedCredentialContext.getReadPaths(), pathBasedCredentialContext.getWritePaths());
        String tokenValue = accessToken.getTokenValue();
        long expireTime = accessToken.getExpirationTime().toInstant().toEpochMilli();
        return new GCSTokenCredential(tokenValue, expireTime);
    }

    private AccessToken getToken(GoogleCredentials sourceCredentials, Set<String> readLocations, Set<String> writeLocations) throws IOException {
        DownscopedCredentials downscopedCredentials = DownscopedCredentials.newBuilder().setSourceCredential(sourceCredentials).setCredentialAccessBoundary(this.getAccessBoundary(readLocations, writeLocations)).build();
        return downscopedCredentials.refreshAccessToken();
    }

    private List<String> getReadExpressions(String bucketName, String resourcePath) {
        ArrayList<String> readExpressions = new ArrayList<String>();
        readExpressions.add(String.format("resource.name.startsWith('projects/_/buckets/%s/objects/%s')", bucketName, resourcePath));
        GCSTokenGenerator.getAllResources(resourcePath).forEach(parentResourcePath -> readExpressions.add(String.format("resource.name == 'projects/_/buckets/%s/objects/%s'", bucketName, parentResourcePath)));
        return readExpressions;
    }

    static List<String> getAllResources(String resourcePath) {
        if (resourcePath == null || resourcePath.isEmpty() || resourcePath.equals("/")) {
            return Arrays.asList("");
        }
        if (resourcePath.endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        Preconditions.checkArgument((!resourcePath.startsWith("/") ? 1 : 0) != 0, (Object)(resourcePath + " should not start with /"));
        List<String> parts = Arrays.asList(resourcePath.split("/"));
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder parent = new StringBuilder();
        for (int i = 0; i < parts.size() - 1; ++i) {
            String part = parts.get(i);
            results.add(String.valueOf(parent) + part);
            parent.append(part).append("/");
            results.add(parent.toString());
        }
        results.add(String.valueOf(parent) + parts.get(parts.size() - 1));
        return results;
    }

    static String normalizeUriPath(String resourcePath) {
        if (resourcePath.isEmpty() || "/".equals(resourcePath)) {
            return "";
        }
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if (resourcePath.endsWith("/")) {
            return resourcePath;
        }
        return resourcePath + "/";
    }

    private CredentialAccessBoundary getAccessBoundary(Set<String> readLocations, Set<String> writeLocations) {
        HashMap readExpressions = new HashMap();
        HashMap writeExpressions = new HashMap();
        HashSet readBuckets = new HashSet();
        HashSet writeBuckets = new HashSet();
        Stream.concat(readLocations.stream(), writeLocations.stream()).distinct().forEach(location -> {
            URI uri = URI.create(location);
            String bucketName = GCSTokenGenerator.getBucketName(uri);
            readBuckets.add(bucketName);
            String resourcePath = GCSTokenGenerator.normalizeUriPath(uri.getPath());
            List resourceExpressions = readExpressions.computeIfAbsent(bucketName, key -> new ArrayList());
            resourceExpressions.addAll(this.getReadExpressions(bucketName, resourcePath));
            resourceExpressions.add(String.format("api.getAttribute('storage.googleapis.com/objectListPrefix', '').startsWith('%s')", resourcePath));
            if (writeLocations.contains(location)) {
                writeBuckets.add(bucketName);
                resourceExpressions = writeExpressions.computeIfAbsent(bucketName, key -> new ArrayList());
                resourceExpressions.add(String.format("resource.name.startsWith('projects/_/buckets/%s/objects/%s')", bucketName, resourcePath));
            }
        });
        CredentialAccessBoundary.Builder credentialAccessBoundaryBuilder = CredentialAccessBoundary.newBuilder();
        readBuckets.forEach(bucket -> {
            CredentialAccessBoundary.AccessBoundaryRule bucketInfoRule = CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource(GCSTokenGenerator.toGCSBucketResource(bucket)).setAvailablePermissions(Arrays.asList("inRole:roles/storage.insightsCollectorService")).build();
            credentialAccessBoundaryBuilder.addRule(bucketInfoRule);
            List readConditions = (List)readExpressions.get(bucket);
            CredentialAccessBoundary.AccessBoundaryRule rule = this.getAccessBoundaryRule((String)bucket, readConditions, Arrays.asList("inRole:roles/storage.objectViewer"));
            if (rule != null) {
                credentialAccessBoundaryBuilder.addRule(rule);
            }
        });
        writeBuckets.forEach(bucket -> {
            List writeConditions = (List)writeExpressions.get(bucket);
            CredentialAccessBoundary.AccessBoundaryRule rule = this.getAccessBoundaryRule((String)bucket, writeConditions, Arrays.asList("inRole:roles/storage.legacyBucketWriter"));
            if (rule != null) {
                credentialAccessBoundaryBuilder.addRule(rule);
            }
        });
        return credentialAccessBoundaryBuilder.build();
    }

    private CredentialAccessBoundary.AccessBoundaryRule getAccessBoundaryRule(String bucketName, List<String> resourceExpression, List<String> permissions) {
        if (resourceExpression == null || resourceExpression.isEmpty()) {
            return null;
        }
        return CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource(GCSTokenGenerator.toGCSBucketResource(bucketName)).setAvailabilityCondition(CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression(String.join((CharSequence)" || ", resourceExpression)).build()).setAvailablePermissions(permissions).build();
    }

    private static String toGCSBucketResource(String bucketName) {
        return "//storage.googleapis.com/projects/_/buckets/" + bucketName;
    }

    private static String getBucketName(URI uri) {
        return uri.getHost();
    }

    private GoogleCredentials getSourceCredentials(GCSCredentialConfig gcsCredentialConfig) throws IOException {
        GoogleCredentials googleCredentials;
        block9: {
            String gcsCredentialFilePath = gcsCredentialConfig.gcsCredentialFilePath();
            if (StringUtils.isBlank((CharSequence)gcsCredentialFilePath)) {
                return GoogleCredentials.getApplicationDefault();
            }
            Path credentialsFilePath = Paths.get(gcsCredentialFilePath, new String[0]);
            InputStream fileInputStream = Files.newInputStream(credentialsFilePath, new OpenOption[0]);
            try {
                googleCredentials = GoogleCredentials.fromStream((InputStream)fileInputStream);
                if (fileInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    throw new IOException("GCS credential file does not exist." + gcsCredentialFilePath, e);
                }
            }
            fileInputStream.close();
        }
        return googleCredentials;
    }

    public void close() throws IOException {
    }
}

