/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.ThreadPools;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergHiveCachedClientPool
implements ClientPool<IMetaStoreClient, TException>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergHiveCachedClientPool.class);
    private static final String CONF_ELEMENT_PREFIX = "conf:";
    private static Cache<Key, HiveClientPool> clientPoolCache;
    private final Configuration conf;
    private final Map<String, String> properties;
    private final int clientPoolSize;
    private final long evictionInterval;
    private ScheduledExecutorService scheduledExecutorService;

    public IcebergHiveCachedClientPool(Configuration conf, Map<String, String> properties) {
        this.conf = conf;
        this.clientPoolSize = PropertyUtil.propertyAsInt(properties, (String)"clients", (int)2);
        this.evictionInterval = PropertyUtil.propertyAsLong(properties, (String)"client.pool.cache.eviction-interval-ms", (long)CatalogProperties.CLIENT_POOL_CACHE_EVICTION_INTERVAL_MS_DEFAULT);
        this.properties = properties;
        this.init();
    }

    @VisibleForTesting
    HiveClientPool clientPool() {
        Key key = IcebergHiveCachedClientPool.extractKey(this.properties.get("client-pool-cache-keys"), this.conf);
        return (HiveClientPool)clientPoolCache.get((Object)key, k -> {
            HiveClientPool hiveClientPool = new HiveClientPool(this.clientPoolSize, this.conf);
            LOG.info("Created a new HiveClientPool instance: {} for Key: {}", (Object)hiveClientPool, (Object)key);
            return hiveClientPool;
        });
    }

    private synchronized void init() {
        if (clientPoolCache == null) {
            this.scheduledExecutorService = ThreadPools.newScheduledPool((String)"hive-metastore-cleaner", (int)1);
            clientPoolCache = Caffeine.newBuilder().expireAfterAccess(this.evictionInterval, TimeUnit.MILLISECONDS).removalListener((key, value, cause) -> {
                HiveClientPool hiveClientPool = (HiveClientPool)value;
                if (hiveClientPool != null) {
                    LOG.info("Removing an expired HiveClientPool instance: {} for Key: {}", (Object)hiveClientPool, key);
                    hiveClientPool.close();
                }
            }).scheduler(Scheduler.forScheduledExecutorService((ScheduledExecutorService)this.scheduledExecutorService)).build();
        }
    }

    @VisibleForTesting
    static Cache<Key, HiveClientPool> clientPoolCache() {
        return clientPoolCache;
    }

    public <R> R run(ClientPool.Action<R, IMetaStoreClient, TException> action) throws TException, InterruptedException {
        return (R)this.clientPool().run(action);
    }

    public <R> R run(ClientPool.Action<R, IMetaStoreClient, TException> action, boolean retry) throws TException, InterruptedException {
        return (R)this.clientPool().run(action, retry);
    }

    @VisibleForTesting
    static Key extractKey(String cacheKeys, Configuration conf) {
        ArrayList elements = Lists.newArrayList();
        elements.add(conf.get(HiveConf.ConfVars.METASTOREURIS.varname, ""));
        elements.add(conf.get("HIVE_CONF_CATALOG", "hive"));
        if (cacheKeys == null || cacheKeys.isEmpty()) {
            return Key.of(elements);
        }
        TreeSet types = Sets.newTreeSet(Comparator.comparingInt(Enum::ordinal));
        TreeMap confElements = Maps.newTreeMap();
        block11: for (String element : cacheKeys.split(",", -1)) {
            String trimmed = element.trim();
            if (trimmed.toLowerCase(Locale.ROOT).startsWith(CONF_ELEMENT_PREFIX)) {
                String key = trimmed.substring(CONF_ELEMENT_PREFIX.length());
                ValidationException.check((!confElements.containsKey(key) ? 1 : 0) != 0, (String)"Conf key element %s already specified", (Object[])new Object[]{key});
                confElements.put(key, conf.get(key));
                continue;
            }
            KeyElementType type = KeyElementType.valueOf(trimmed.toUpperCase());
            switch (type) {
                case UGI: 
                case USER_NAME: {
                    ValidationException.check((!types.contains((Object)type) ? 1 : 0) != 0, (String)"%s key element already specified", (Object[])new Object[]{type.name()});
                    types.add(type);
                    continue block11;
                }
                default: {
                    throw new ValidationException("Unknown key element %s", new Object[]{trimmed});
                }
            }
        }
        block12: for (KeyElementType type : types) {
            switch (type) {
                case UGI: {
                    try {
                        elements.add(UserGroupInformation.getCurrentUser());
                        continue block12;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                case USER_NAME: {
                    try {
                        elements.add(UserGroupInformation.getCurrentUser().getUserName());
                        continue block12;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            throw new RuntimeException("Unexpected key element " + type.name());
        }
        return Key.of(elements);
    }

    @Override
    public void close() throws IOException {
        clientPoolCache.asMap().forEach((key, value) -> value.close());
        clientPoolCache.invalidateAll();
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
    }

    static class Key {
        private final List<Object> elements;

        List<Object> elements() {
            return this.elements;
        }

        public Key(List<Object> elements) {
            this.elements = elements;
        }

        static Key of(List<Object> elements) {
            return new Key(elements);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.elements, key.elements);
        }

        public int hashCode() {
            return Objects.hash(this.elements);
        }
    }

    private static enum KeyElementType {
        UGI,
        USER_NAME,
        CONF;

    }
}

