/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.cache;

import java.util.Optional;
import org.apache.gravitino.iceberg.common.cache.SupportsMetadataLocation;
import org.apache.gravitino.iceberg.common.cache.TableMetadataCache;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.TableIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTableMetadataCache
implements TableMetadataCache {
    public static final Logger LOG = LoggerFactory.getLogger(BaseTableMetadataCache.class);
    private SupportsMetadataLocation supportsMetadataLocation;

    protected abstract Optional<TableMetadata> doGetTableMetadata(TableIdentifier var1);

    protected void initialize(SupportsMetadataLocation supportsMetadataLocation) {
        this.supportsMetadataLocation = supportsMetadataLocation;
    }

    @Override
    public Optional<TableMetadata> getTableMetadata(TableIdentifier tableIdentifier) {
        Optional<TableMetadata> tableMetadataOptional = this.doGetTableMetadata(tableIdentifier);
        if (!tableMetadataOptional.isPresent()) {
            return Optional.empty();
        }
        TableMetadata tableMetadata = tableMetadataOptional.get();
        String latestLocation = this.supportsMetadataLocation.metadataLocation(tableIdentifier);
        if (latestLocation == null) {
            return Optional.empty();
        }
        if (latestLocation.equals(tableMetadata.metadataFileLocation())) {
            return Optional.of(tableMetadata);
        }
        LOG.debug("The cached table metadata is not latest, table identifier: {}, table metadata location in cache: {}, latest metadata location: {}", new Object[]{tableIdentifier, tableMetadata.metadataFileLocation(), latestLocation});
        this.invalidate(tableIdentifier);
        return Optional.empty();
    }
}

