/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.GroupMetaMapper;
import org.apache.gravitino.storage.relational.mapper.GroupRoleRelMapper;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.po.GroupPO;
import org.apache.gravitino.storage.relational.po.GroupRoleRelPO;
import org.apache.gravitino.storage.relational.po.RolePO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.service.RoleMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class GroupMetaService {
    private static final GroupMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;

    public static GroupMetaService getInstance() {
        return INSTANCE;
    }

    private GroupMetaService() {
    }

    private GroupPO getGroupPOByMetalakeIdAndName(Long metalakeId, String groupName) {
        GroupPO GroupPO2 = SessionUtils.getWithoutCommit(GroupMetaMapper.class, mapper -> mapper.selectGroupMetaByMetalakeIdAndName(metalakeId, groupName));
        if (GroupPO2 == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.GROUP.name().toLowerCase(), groupName});
        }
        return GroupPO2;
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getGroupIdByMetalakeIdAndName")
    public Long getGroupIdByMetalakeIdAndName(Long metalakeId, String groupName) {
        Long l = metalakeId;
        String string = groupName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)l, (Object)string);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = GroupMetaService.class.getDeclaredMethod("getGroupIdByMetalakeIdAndName", Long.class, String.class).getAnnotation(Monitored.class);
        }
        return (Long)GroupMetaService.getGroupIdByMetalakeIdAndName_aroundBody1$advice(this, l, string, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getGroupByIdentifier")
    public GroupEntity getGroupByIdentifier(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = GroupMetaService.class.getDeclaredMethod("getGroupByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (GroupEntity)GroupMetaService.getGroupByIdentifier_aroundBody3$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listGroupsByRoleIdent")
    public List<GroupEntity> listGroupsByRoleIdent(NameIdentifier roleIdent) {
        NameIdentifier nameIdentifier = roleIdent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = GroupMetaService.class.getDeclaredMethod("listGroupsByRoleIdent", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (List)GroupMetaService.listGroupsByRoleIdent_aroundBody5$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertGroup")
    public void insertGroup(GroupEntity groupEntity, boolean overwritten) throws IOException {
        GroupEntity groupEntity2 = groupEntity;
        boolean bl = overwritten;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)groupEntity2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = GroupMetaService.class.getDeclaredMethod("insertGroup", GroupEntity.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        GroupMetaService.insertGroup_aroundBody7$advice(this, groupEntity2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteGroup")
    public boolean deleteGroup(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = GroupMetaService.class.getDeclaredMethod("deleteGroup", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)GroupMetaService.deleteGroup_aroundBody9$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateGroup")
    public <E extends Entity & HasIdentifier> GroupEntity updateGroup(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = identifier;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = GroupMetaService.class.getDeclaredMethod("updateGroup", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (GroupEntity)GroupMetaService.updateGroup_aroundBody11$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listGroupsByNamespace")
    public List<GroupEntity> listGroupsByNamespace(Namespace namespace, boolean allFields) {
        Namespace namespace2 = namespace;
        boolean bl = allFields;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)namespace2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = GroupMetaService.class.getDeclaredMethod("listGroupsByNamespace", Namespace.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        return (List)GroupMetaService.listGroupsByNamespace_aroundBody13$advice(this, namespace2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteGroupMetasByLegacyTimeline")
    public int deleteGroupMetasByLegacyTimeline(long legacyTimeline, int limit) {
        long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = GroupMetaService.class.getDeclaredMethod("deleteGroupMetasByLegacyTimeline", Long.TYPE, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)GroupMetaService.deleteGroupMetasByLegacyTimeline_aroundBody15$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    private static /* synthetic */ void lambda$updateGroup$19(Set deleteRoleIds, GroupEntity newEntity) {
        if (deleteRoleIds.isEmpty()) {
            return;
        }
        SessionUtils.doWithoutCommit(GroupRoleRelMapper.class, mapper -> mapper.softDeleteGroupRoleRelByGroupAndRoles(newEntity.id(), Lists.newArrayList((Iterable)deleteRoleIds)));
    }

    private static /* synthetic */ void lambda$updateGroup$17(Set insertRoleIds, GroupEntity newEntity) {
        if (insertRoleIds.isEmpty()) {
            return;
        }
        SessionUtils.doWithoutCommit(GroupRoleRelMapper.class, mapper -> mapper.batchInsertGroupRoleRel(POConverters.initializeGroupRoleRelsPOWithVersion(newEntity, Lists.newArrayList((Iterable)insertRoleIds))));
    }

    static {
        GroupMetaService.ajc$preClinit();
        INSTANCE = new GroupMetaService();
    }

    private static final /* synthetic */ Long getGroupIdByMetalakeIdAndName_aroundBody0(GroupMetaService ajc$this, Long metalakeId, String groupName, JoinPoint joinPoint) {
        Long groupId = SessionUtils.getWithoutCommit(GroupMetaMapper.class, mapper -> mapper.selectGroupIdBySchemaIdAndName(metalakeId, groupName));
        if (groupId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.GROUP.name().toLowerCase(), groupName});
        }
        return groupId;
    }

    private static final /* synthetic */ Object getGroupIdByMetalakeIdAndName_aroundBody1$advice(GroupMetaService ajc$this, Long metalakeId, String groupName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Long l;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return GroupMetaService.getGroupIdByMetalakeIdAndName_aroundBody0(ajc$this, metalakeId, groupName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return GroupMetaService.getGroupIdByMetalakeIdAndName_aroundBody0(ajc$this, metalakeId, groupName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Long result = GroupMetaService.getGroupIdByMetalakeIdAndName_aroundBody0(ajc$this, metalakeId, groupName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                l = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return l;
    }

    private static final /* synthetic */ GroupEntity getGroupByIdentifier_aroundBody2(GroupMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        AuthorizationUtils.checkGroup(identifier);
        NameIdentifier metalakeIdent = NameIdentifier.of((String[])new String[]{NameIdentifierUtil.getMetalake(identifier)});
        long metalakeId = EntityIdService.getEntityId(metalakeIdent, Entity.EntityType.METALAKE);
        GroupPO groupPO = ajc$this.getGroupPOByMetalakeIdAndName(metalakeId, identifier.name());
        List<RolePO> rolePOs = RoleMetaService.getInstance().listRolesByGroupId(groupPO.getGroupId());
        return POConverters.fromGroupPO(groupPO, rolePOs, identifier.namespace());
    }

    private static final /* synthetic */ Object getGroupByIdentifier_aroundBody3$advice(GroupMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        GroupEntity groupEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return GroupMetaService.getGroupByIdentifier_aroundBody2(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return GroupMetaService.getGroupByIdentifier_aroundBody2(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                GroupEntity result = GroupMetaService.getGroupByIdentifier_aroundBody2(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                groupEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return groupEntity;
    }

    private static final /* synthetic */ List listGroupsByRoleIdent_aroundBody4(GroupMetaService ajc$this, NameIdentifier roleIdent, JoinPoint joinPoint) {
        RoleEntity roleEntity = RoleMetaService.getInstance().getRoleByIdentifier(roleIdent);
        List groupPOs = SessionUtils.getWithoutCommit(GroupMetaMapper.class, mapper -> mapper.listGroupsByRoleId(roleEntity.id()));
        return groupPOs.stream().map(po -> POConverters.fromGroupPO(po, Collections.emptyList(), AuthorizationUtils.ofGroupNamespace(roleIdent.namespace().level(0)))).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listGroupsByRoleIdent_aroundBody5$advice(GroupMetaService ajc$this, NameIdentifier roleIdent, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return GroupMetaService.listGroupsByRoleIdent_aroundBody4(ajc$this, roleIdent, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return GroupMetaService.listGroupsByRoleIdent_aroundBody4(ajc$this, roleIdent, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = GroupMetaService.listGroupsByRoleIdent_aroundBody4(ajc$this, roleIdent, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ void insertGroup_aroundBody6(GroupMetaService ajc$this, GroupEntity groupEntity, boolean overwritten, JoinPoint joinPoint) {
        try {
            AuthorizationUtils.checkGroup(groupEntity.nameIdentifier());
            NameIdentifier metalakeIdent = NameIdentifier.of((String[])new String[]{NameIdentifierUtil.getMetalake(groupEntity.nameIdentifier())});
            Long metalakeId = EntityIdService.getEntityId(metalakeIdent, Entity.EntityType.METALAKE);
            GroupPO.Builder builder = GroupPO.builder().withMetalakeId(metalakeId);
            GroupPO GroupPO2 = POConverters.initializeGroupPOWithVersion(groupEntity, builder);
            List<Long> roleIds = Optional.ofNullable(groupEntity.roleIds()).orElse(Lists.newArrayList());
            List<GroupRoleRelPO> groupRoleRelPOS = POConverters.initializeGroupRoleRelsPOWithVersion(groupEntity, roleIds);
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(GroupMetaMapper.class, mapper -> {
                if (overwritten) {
                    mapper.insertGroupMetaOnDuplicateKeyUpdate(GroupPO2);
                } else {
                    mapper.insertGroupMeta(GroupPO2);
                }
            }), () -> SessionUtils.doWithoutCommit(GroupRoleRelMapper.class, mapper -> {
                if (overwritten) {
                    mapper.softDeleteGroupRoleRelByGroupId(groupEntity.id());
                }
                if (!groupRoleRelPOS.isEmpty()) {
                    mapper.batchInsertGroupRoleRel(groupRoleRelPOS);
                }
            }));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.GROUP, groupEntity.nameIdentifier().toString());
            throw re;
        }
    }

    private static final /* synthetic */ Object insertGroup_aroundBody7$advice(GroupMetaService ajc$this, GroupEntity groupEntity, boolean overwritten, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                GroupMetaService.insertGroup_aroundBody6(ajc$this, groupEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                GroupMetaService.insertGroup_aroundBody6(ajc$this, groupEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                GroupMetaService.insertGroup_aroundBody6(ajc$this, groupEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ boolean deleteGroup_aroundBody8(GroupMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        AuthorizationUtils.checkGroup(identifier);
        Long groupId = EntityIdService.getEntityId(identifier, Entity.EntityType.GROUP);
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(GroupMetaMapper.class, mapper -> mapper.softDeleteGroupMetaByGroupId(groupId)), () -> SessionUtils.doWithoutCommit(GroupRoleRelMapper.class, mapper -> mapper.softDeleteGroupRoleRelByGroupId(groupId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByOwnerIdAndType(groupId, Entity.EntityType.GROUP.name())));
        return true;
    }

    private static final /* synthetic */ Object deleteGroup_aroundBody9$advice(GroupMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)GroupMetaService.deleteGroup_aroundBody8(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)GroupMetaService.deleteGroup_aroundBody8(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)GroupMetaService.deleteGroup_aroundBody8(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ GroupEntity updateGroup_aroundBody10(GroupMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint joinPoint) {
        AuthorizationUtils.checkGroup(identifier);
        NameIdentifier metalakeIdent = NameIdentifier.of((String[])new String[]{NameIdentifierUtil.getMetalake(identifier)});
        Long metalakeId = EntityIdService.getEntityId(metalakeIdent, Entity.EntityType.METALAKE);
        GroupPO oldGroupPO = ajc$this.getGroupPOByMetalakeIdAndName(metalakeId, identifier.name());
        List<RolePO> rolePOs = RoleMetaService.getInstance().listRolesByGroupId(oldGroupPO.getGroupId());
        GroupEntity oldGroupEntity = POConverters.fromGroupPO(oldGroupPO, rolePOs, identifier.namespace());
        GroupEntity newEntity = (GroupEntity)updater.apply(oldGroupEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldGroupEntity.id(), newEntity.id()), (String)"The updated group entity id: %s should be same with the group entity id before: %s", (Object)newEntity.id(), (Object)oldGroupEntity.id());
        HashSet oldRoleIds = oldGroupEntity.roleIds() == null ? Sets.newHashSet() : Sets.newHashSet(oldGroupEntity.roleIds());
        HashSet newRoleIds = newEntity.roleIds() == null ? Sets.newHashSet() : Sets.newHashSet(newEntity.roleIds());
        Sets.SetView insertRoleIds = Sets.difference((Set)newRoleIds, (Set)oldRoleIds);
        Sets.SetView deleteRoleIds = Sets.difference((Set)oldRoleIds, (Set)newRoleIds);
        if (insertRoleIds.isEmpty() && deleteRoleIds.isEmpty()) {
            return newEntity;
        }
        try {
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(GroupMetaMapper.class, mapper -> mapper.updateGroupMeta(POConverters.updateGroupPOWithVersion(oldGroupPO, newEntity), oldGroupPO)), () -> GroupMetaService.lambda$updateGroup$17((Set)insertRoleIds, newEntity), () -> GroupMetaService.lambda$updateGroup$19((Set)deleteRoleIds, newEntity));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.GROUP, newEntity.nameIdentifier().toString());
            throw re;
        }
        return newEntity;
    }

    private static final /* synthetic */ Object updateGroup_aroundBody11$advice(GroupMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        GroupEntity groupEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return GroupMetaService.updateGroup_aroundBody10(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return GroupMetaService.updateGroup_aroundBody10(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                GroupEntity result = GroupMetaService.updateGroup_aroundBody10(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                groupEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return groupEntity;
    }

    private static final /* synthetic */ List listGroupsByNamespace_aroundBody12(GroupMetaService ajc$this, Namespace namespace, boolean allFields, JoinPoint joinPoint) {
        AuthorizationUtils.checkGroupNamespace(namespace);
        String metalakeName = namespace.level(0);
        if (allFields) {
            NameIdentifier metalakeIdent = NameIdentifier.of((String[])new String[]{metalakeName});
            long metalakeId = EntityIdService.getEntityId(metalakeIdent, Entity.EntityType.METALAKE);
            List groupPOs = SessionUtils.getWithoutCommit(GroupMetaMapper.class, mapper -> mapper.listExtendedGroupPOsByMetalakeId(metalakeId));
            return groupPOs.stream().map(po -> POConverters.fromExtendedGroupPO(po, AuthorizationUtils.ofGroupNamespace(metalakeName))).collect(Collectors.toList());
        }
        List groupPOs = SessionUtils.getWithoutCommit(GroupMetaMapper.class, mapper -> mapper.listGroupPOsByMetalake(metalakeName));
        return groupPOs.stream().map(po -> POConverters.fromGroupPO(po, Collections.emptyList(), AuthorizationUtils.ofGroupNamespace(metalakeName))).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listGroupsByNamespace_aroundBody13$advice(GroupMetaService ajc$this, Namespace namespace, boolean allFields, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return GroupMetaService.listGroupsByNamespace_aroundBody12(ajc$this, namespace, allFields, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return GroupMetaService.listGroupsByNamespace_aroundBody12(ajc$this, namespace, allFields, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = GroupMetaService.listGroupsByNamespace_aroundBody12(ajc$this, namespace, allFields, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ int deleteGroupMetasByLegacyTimeline_aroundBody14(GroupMetaService ajc$this, long legacyTimeline, int limit, JoinPoint joinPoint) {
        int[] groupDeletedCount = new int[]{0};
        int[] groupRoleRelDeletedCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            groupDeletedCount[0] = SessionUtils.getWithoutCommit(GroupMetaMapper.class, mapper -> mapper.deleteGroupMetasByLegacyTimeline(legacyTimeline, limit));
        }, () -> {
            groupRoleRelDeletedCount[0] = SessionUtils.getWithoutCommit(GroupRoleRelMapper.class, mapper -> mapper.deleteGroupRoleRelMetasByLegacyTimeline(legacyTimeline, limit));
        });
        return groupDeletedCount[0] + groupRoleRelDeletedCount[0];
    }

    private static final /* synthetic */ Object deleteGroupMetasByLegacyTimeline_aroundBody15$advice(GroupMetaService ajc$this, long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)GroupMetaService.deleteGroupMetasByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)GroupMetaService.deleteGroupMetasByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)GroupMetaService.deleteGroupMetasByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GroupMetaService.java", GroupMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupIdByMetalakeIdAndName", "org.apache.gravitino.storage.relational.service.GroupMetaService", "java.lang.Long:java.lang.String", "metalakeId:groupName", "", "java.lang.Long"), 84);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupByIdentifier", "org.apache.gravitino.storage.relational.service.GroupMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "org.apache.gravitino.meta.GroupEntity"), 102);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listGroupsByRoleIdent", "org.apache.gravitino.storage.relational.service.GroupMetaService", "org.apache.gravitino.NameIdentifier", "roleIdent", "", "java.util.List"), 116);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertGroup", "org.apache.gravitino.storage.relational.service.GroupMetaService", "org.apache.gravitino.meta.GroupEntity:boolean", "groupEntity:overwritten", "java.io.IOException", "void"), 133);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteGroup", "org.apache.gravitino.storage.relational.service.GroupMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "boolean"), 178);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateGroup", "org.apache.gravitino.storage.relational.service.GroupMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "identifier:updater", "java.io.IOException", "org.apache.gravitino.meta.GroupEntity"), 202);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listGroupsByNamespace", "org.apache.gravitino.storage.relational.service.GroupMetaService", "org.apache.gravitino.Namespace:boolean", "namespace:allFields", "", "java.util.List"), 275);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteGroupMetasByLegacyTimeline", "org.apache.gravitino.storage.relational.service.GroupMetaService", "long:int", "legacyTimeline:limit", "", "int"), 309);
    }
}

