/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.types;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.gravitino.rel.types.Type;

public class Types {
    public static boolean allowAutoIncrement(Type dataType) {
        return dataType instanceof IntegerType || dataType instanceof LongType;
    }

    private Types() {
    }

    public static class IntegerType
    extends Type.IntegralType {
        private static final IntegerType INSTANCE = new IntegerType(true);
        private static final IntegerType UNSIGNED_INSTANCE = new IntegerType(false);

        public static IntegerType unsigned() {
            return UNSIGNED_INSTANCE;
        }

        public static IntegerType get() {
            return INSTANCE;
        }

        private IntegerType(boolean signed) {
            super(signed);
        }

        @Override
        public Type.Name name() {
            return Type.Name.INTEGER;
        }

        @Override
        public String simpleString() {
            return this.signed() ? "integer" : "integer unsigned";
        }
    }

    public static class LongType
    extends Type.IntegralType {
        private static final LongType INSTANCE = new LongType(true);
        private static final LongType UNSIGNED_INSTANCE = new LongType(false);

        public static LongType unsigned() {
            return UNSIGNED_INSTANCE;
        }

        public static LongType get() {
            return INSTANCE;
        }

        private LongType(boolean signed) {
            super(signed);
        }

        @Override
        public Type.Name name() {
            return Type.Name.LONG;
        }

        @Override
        public String simpleString() {
            return this.signed() ? "long" : "long unsigned";
        }
    }

    public static class ExternalType
    implements Type {
        private final String catalogString;

        public static ExternalType of(String catalogString) {
            return new ExternalType(catalogString);
        }

        private ExternalType(String catalogString) {
            this.catalogString = catalogString;
        }

        public String catalogString() {
            return this.catalogString;
        }

        @Override
        public Type.Name name() {
            return Type.Name.EXTERNAL;
        }

        @Override
        public String simpleString() {
            return String.format("external(%s)", this.catalogString);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExternalType)) {
                return false;
            }
            ExternalType that = (ExternalType)o;
            return Objects.equals(this.catalogString, that.catalogString);
        }

        public int hashCode() {
            return Objects.hash(this.catalogString);
        }

        public String toString() {
            return this.simpleString();
        }
    }

    public static class UnparsedType
    implements Type {
        private final String unparsedType;

        public static UnparsedType of(String unparsedType) {
            return new UnparsedType(unparsedType);
        }

        private UnparsedType(String unparsedType) {
            this.unparsedType = unparsedType;
        }

        public String unparsedType() {
            return this.unparsedType;
        }

        @Override
        public Type.Name name() {
            return Type.Name.UNPARSED;
        }

        @Override
        public String simpleString() {
            return String.format("unparsed(%s)", this.unparsedType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnparsedType)) {
                return false;
            }
            UnparsedType that = (UnparsedType)o;
            return Objects.equals(this.unparsedType, that.unparsedType);
        }

        public int hashCode() {
            return Objects.hash(this.unparsedType);
        }

        public String toString() {
            return this.unparsedType;
        }
    }

    public static class UnionType
    extends Type.ComplexType {
        private final Type[] types;

        public static UnionType of(Type ... types) {
            return new UnionType(types);
        }

        private UnionType(Type[] types) {
            this.types = types;
        }

        public Type[] types() {
            return this.types;
        }

        @Override
        public Type.Name name() {
            return Type.Name.UNION;
        }

        @Override
        public String simpleString() {
            StringJoiner separator = new StringJoiner(",", "union<", ">");
            Arrays.stream(this.types).forEach(type -> separator.add(type.simpleString()));
            return separator.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnionType)) {
                return false;
            }
            UnionType unionType = (UnionType)o;
            return Arrays.equals(this.types, unionType.types);
        }

        public int hashCode() {
            return Arrays.hashCode(this.types);
        }
    }

    public static class MapType
    extends Type.ComplexType {
        private final Type keyType;
        private final Type valueType;
        private final boolean valueNullable;

        public static MapType valueNullable(Type keyType, Type valueType) {
            return MapType.of(keyType, valueType, true);
        }

        public static MapType valueNotNull(Type keyType, Type valueType) {
            return MapType.of(keyType, valueType, false);
        }

        public static MapType of(Type keyType, Type valueType, boolean valueNullable) {
            return new MapType(keyType, valueType, valueNullable);
        }

        private MapType(Type keyType, Type valueType, boolean valueNullable) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.valueNullable = valueNullable;
        }

        @Override
        public Type.Name name() {
            return Type.Name.MAP;
        }

        public Type keyType() {
            return this.keyType;
        }

        public Type valueType() {
            return this.valueType;
        }

        public boolean valueNullable() {
            return this.valueNullable;
        }

        @Override
        public String simpleString() {
            return this.valueNullable ? "map<" + this.keyType.simpleString() + "," + this.valueType.simpleString() + ">" : "map<" + this.keyType.simpleString() + "," + this.valueType.simpleString() + ", NOT NULL>";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MapType)) {
                return false;
            }
            MapType mapType = (MapType)o;
            return this.valueNullable == mapType.valueNullable && Objects.equals(this.keyType, mapType.keyType) && Objects.equals(this.valueType, mapType.valueType);
        }

        public int hashCode() {
            return Objects.hash(this.keyType, this.valueType, this.valueNullable);
        }
    }

    public static class ListType
    extends Type.ComplexType {
        private final Type elementType;
        private final boolean elementNullable;

        public static ListType nullable(Type elementType) {
            return ListType.of(elementType, true);
        }

        public static ListType notNull(Type elementType) {
            return ListType.of(elementType, false);
        }

        public static ListType of(Type elementType, boolean elementNullable) {
            return new ListType(elementType, elementNullable);
        }

        private ListType(Type elementType, boolean elementNullable) {
            Preconditions.checkArgument((elementType != null ? 1 : 0) != 0, (Object)"elementType cannot be null");
            this.elementType = elementType;
            this.elementNullable = elementNullable;
        }

        public Type elementType() {
            return this.elementType;
        }

        public boolean elementNullable() {
            return this.elementNullable;
        }

        @Override
        public Type.Name name() {
            return Type.Name.LIST;
        }

        @Override
        public String simpleString() {
            return this.elementNullable ? "list<" + this.elementType.simpleString() + ">" : "list<" + this.elementType.simpleString() + ", NOT NULL>";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListType)) {
                return false;
            }
            ListType listType = (ListType)o;
            return this.elementNullable == listType.elementNullable && Objects.equals(this.elementType, listType.elementType);
        }

        public int hashCode() {
            return Objects.hash(this.elementType, this.elementNullable);
        }
    }

    public static class StructType
    extends Type.ComplexType {
        private final Field[] fields;

        public static StructType of(Field ... fields) {
            Preconditions.checkArgument((fields != null && fields.length > 0 ? 1 : 0) != 0, (Object)"fields cannot be null or empty");
            return new StructType(fields);
        }

        private StructType(Field[] fields) {
            this.fields = fields;
        }

        public Field[] fields() {
            return this.fields;
        }

        @Override
        public Type.Name name() {
            return Type.Name.STRUCT;
        }

        @Override
        public String simpleString() {
            StringJoiner separator = new StringJoiner(",", "struct<", ">");
            Arrays.stream(this.fields).forEach(field -> separator.add(field.simpleString()));
            return separator.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StructType)) {
                return false;
            }
            StructType that = (StructType)o;
            return Arrays.equals(this.fields, that.fields);
        }

        public int hashCode() {
            return Arrays.hashCode(this.fields);
        }

        public static class Field {
            private final String name;
            private final Type type;
            private final boolean nullable;
            private final String comment;

            public static Field notNullField(String name, Type type) {
                return Field.notNullField(name, type, null);
            }

            public static Field notNullField(String name, Type type, String comment) {
                return Field.of(name, type, false, comment);
            }

            public static Field nullableField(String name, Type type) {
                return Field.nullableField(name, type, null);
            }

            public static Field nullableField(String name, Type type, String comment) {
                return Field.of(name, type, true, comment);
            }

            public static Field of(String name, Type type, boolean nullable, String comment) {
                return new Field(name, type, nullable, comment);
            }

            private Field(String name, Type type, boolean nullable, String comment) {
                Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
                Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
                this.name = name;
                this.type = type;
                this.nullable = nullable;
                this.comment = comment;
            }

            public String name() {
                return this.name;
            }

            public Type type() {
                return this.type;
            }

            public boolean nullable() {
                return this.nullable;
            }

            public String comment() {
                return this.comment;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Field)) {
                    return false;
                }
                Field field = (Field)o;
                return this.nullable == field.nullable && Objects.equals(this.name, field.name) && Objects.equals(this.type, field.type);
            }

            public int hashCode() {
                return Objects.hash(this.name, this.type, this.nullable);
            }

            public String simpleString() {
                return String.format("%s: %s %s COMMENT %s", this.name, this.type.simpleString(), this.nullable ? "NULL" : "NOT NULL", this.comment == null ? "" : "'" + this.comment + "'");
            }
        }
    }

    public static class BinaryType
    extends Type.PrimitiveType {
        private static final BinaryType INSTANCE = new BinaryType();

        public static BinaryType get() {
            return INSTANCE;
        }

        private BinaryType() {
        }

        @Override
        public Type.Name name() {
            return Type.Name.BINARY;
        }

        @Override
        public String simpleString() {
            return "binary";
        }
    }

    public static class FixedCharType
    extends Type.PrimitiveType {
        private final int length;

        public static FixedCharType of(int length) {
            return new FixedCharType(length);
        }

        private FixedCharType(int length) {
            this.length = length;
        }

        @Override
        public Type.Name name() {
            return Type.Name.FIXEDCHAR;
        }

        public int length() {
            return this.length;
        }

        @Override
        public String simpleString() {
            return String.format("char(%d)", this.length);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FixedCharType)) {
                return false;
            }
            FixedCharType that = (FixedCharType)o;
            return this.length == that.length;
        }

        public int hashCode() {
            return Objects.hash(this.length);
        }
    }

    public static class VarCharType
    extends Type.PrimitiveType {
        private final int length;

        public static VarCharType of(int length) {
            return new VarCharType(length);
        }

        private VarCharType(int length) {
            this.length = length;
        }

        @Override
        public Type.Name name() {
            return Type.Name.VARCHAR;
        }

        public int length() {
            return this.length;
        }

        @Override
        public String simpleString() {
            return String.format("varchar(%d)", this.length);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VarCharType)) {
                return false;
            }
            VarCharType that = (VarCharType)o;
            return this.length == that.length;
        }

        public int hashCode() {
            return Objects.hash(this.length);
        }
    }

    public static class FixedType
    extends Type.PrimitiveType {
        private final int length;

        public static FixedType of(int length) {
            return new FixedType(length);
        }

        private FixedType(int length) {
            this.length = length;
        }

        @Override
        public Type.Name name() {
            return Type.Name.FIXED;
        }

        public int length() {
            return this.length;
        }

        @Override
        public String simpleString() {
            return String.format("fixed(%d)", this.length);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FixedType)) {
                return false;
            }
            FixedType fixedType = (FixedType)o;
            return this.length == fixedType.length;
        }

        public int hashCode() {
            return Objects.hash(this.length);
        }
    }

    public static class UUIDType
    extends Type.PrimitiveType {
        private static final UUIDType INSTANCE = new UUIDType();

        public static UUIDType get() {
            return INSTANCE;
        }

        private UUIDType() {
        }

        @Override
        public Type.Name name() {
            return Type.Name.UUID;
        }

        @Override
        public String simpleString() {
            return "uuid";
        }
    }

    public static class StringType
    extends Type.PrimitiveType {
        private static final StringType INSTANCE = new StringType();

        public static StringType get() {
            return INSTANCE;
        }

        private StringType() {
        }

        @Override
        public Type.Name name() {
            return Type.Name.STRING;
        }

        @Override
        public String simpleString() {
            return "string";
        }
    }

    public static class IntervalDayType
    extends Type.IntervalType {
        private static final IntervalDayType INSTANCE = new IntervalDayType();

        public static IntervalDayType get() {
            return INSTANCE;
        }

        private IntervalDayType() {
        }

        @Override
        public Type.Name name() {
            return Type.Name.INTERVAL_DAY;
        }

        @Override
        public String simpleString() {
            return "interval_day";
        }
    }

    public static class IntervalYearType
    extends Type.IntervalType {
        private static final IntervalYearType INSTANCE = new IntervalYearType();

        public static IntervalYearType get() {
            return INSTANCE;
        }

        private IntervalYearType() {
        }

        @Override
        public Type.Name name() {
            return Type.Name.INTERVAL_YEAR;
        }

        @Override
        public String simpleString() {
            return "interval_year";
        }
    }

    public static class TimestampType
    extends Type.DateTimeType {
        private static final TimestampType INSTANCE_WITHOUT_TIME_ZONE = new TimestampType(false);
        private static final TimestampType INSTANCE_WITH_TIME_ZONE = new TimestampType(true);
        private final boolean withTimeZone;
        private final int precision;

        public static TimestampType withoutTimeZone() {
            return INSTANCE_WITHOUT_TIME_ZONE;
        }

        public static TimestampType withTimeZone() {
            return INSTANCE_WITH_TIME_ZONE;
        }

        public static TimestampType withoutTimeZone(int precision) {
            Preconditions.checkArgument((precision >= 0 && precision <= 12 ? 1 : 0) != 0, (String)"precision must be in range [%s, %s]: precision: %s", (Object)0, (Object)12, (Object)precision);
            return new TimestampType(false, precision);
        }

        public static TimestampType withTimeZone(int precision) {
            Preconditions.checkArgument((precision >= 0 && precision <= 12 ? 1 : 0) != 0, (String)"precision must be in range [%s, %s]: precision: %s", (Object)0, (Object)12, (Object)precision);
            return new TimestampType(true, precision);
        }

        private TimestampType(boolean withTimeZone) {
            this(withTimeZone, -1);
        }

        private TimestampType(boolean withTimeZone, int precision) {
            this.withTimeZone = withTimeZone;
            this.precision = precision;
        }

        public boolean hasTimeZone() {
            return this.withTimeZone;
        }

        public int precision() {
            return this.precision;
        }

        public boolean hasPrecisionSet() {
            return this.precision != -1;
        }

        @Override
        public Type.Name name() {
            return Type.Name.TIMESTAMP;
        }

        @Override
        public String simpleString() {
            return this.hasPrecisionSet() ? (this.withTimeZone ? String.format("timestamp_tz(%d)", this.precision) : String.format("timestamp(%d)", this.precision)) : (this.withTimeZone ? "timestamp_tz" : "timestamp");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TimestampType)) {
                return false;
            }
            TimestampType that = (TimestampType)o;
            return this.withTimeZone == that.withTimeZone && this.precision == that.precision;
        }

        public int hashCode() {
            return Objects.hash(this.withTimeZone, this.precision);
        }

        public String toString() {
            return "TimestampType{withTimeZone=" + this.withTimeZone + ", precision=" + this.precision + "}";
        }
    }

    public static class TimeType
    extends Type.DateTimeType {
        private static final TimeType INSTANCE = new TimeType();
        private final int precision;

        public static TimeType get() {
            return INSTANCE;
        }

        public static TimeType of(int precision) {
            Preconditions.checkArgument((precision >= 0 && precision <= 12 ? 1 : 0) != 0, (String)"precision must be in range [%s, %s]: precision: %s", (Object)0, (Object)12, (Object)precision);
            return new TimeType(precision);
        }

        private TimeType() {
            this(-1);
        }

        private TimeType(int precision) {
            this.precision = precision;
        }

        public int precision() {
            return this.precision;
        }

        public boolean hasPrecisionSet() {
            return this.precision != -1;
        }

        @Override
        public Type.Name name() {
            return Type.Name.TIME;
        }

        @Override
        public String simpleString() {
            return this.hasPrecisionSet() ? String.format("time(%d)", this.precision) : "time";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TimeType)) {
                return false;
            }
            TimeType that = (TimeType)o;
            return this.precision == that.precision;
        }

        public int hashCode() {
            return this.precision;
        }

        public String toString() {
            return "TimeType{precision=" + this.precision + "}";
        }
    }

    public static class DateType
    extends Type.DateTimeType {
        private static final DateType INSTANCE = new DateType();

        public static DateType get() {
            return INSTANCE;
        }

        private DateType() {
        }

        @Override
        public Type.Name name() {
            return Type.Name.DATE;
        }

        @Override
        public String simpleString() {
            return "date";
        }
    }

    public static class DecimalType
    extends Type.FractionType {
        private final int precision;
        private final int scale;

        public static DecimalType of(int precision, int scale) {
            return new DecimalType(precision, scale);
        }

        private DecimalType(int precision, int scale) {
            DecimalType.checkPrecisionScale(precision, scale);
            this.precision = precision;
            this.scale = scale;
        }

        static void checkPrecisionScale(int precision, int scale) {
            Preconditions.checkArgument((precision > 0 && precision <= 38 ? 1 : 0) != 0, (String)"Decimal precision must be in range[1, 38]: precision: %s", (int)precision);
            Preconditions.checkArgument((scale >= 0 && scale <= precision ? 1 : 0) != 0, (String)"Decimal scale must be in range [0, precision (%s)]: scala: %s", (int)precision, (int)scale);
        }

        @Override
        public Type.Name name() {
            return Type.Name.DECIMAL;
        }

        public int precision() {
            return this.precision;
        }

        public int scale() {
            return this.scale;
        }

        @Override
        public String simpleString() {
            return String.format("decimal(%d,%d)", this.precision, this.scale);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DecimalType)) {
                return false;
            }
            DecimalType that = (DecimalType)o;
            return this.precision == that.precision && this.scale == that.scale;
        }

        public int hashCode() {
            return Objects.hash(this.precision, this.scale);
        }
    }

    public static class DoubleType
    extends Type.FractionType {
        private static final DoubleType INSTANCE = new DoubleType();

        public static DoubleType get() {
            return INSTANCE;
        }

        private DoubleType() {
        }

        @Override
        public Type.Name name() {
            return Type.Name.DOUBLE;
        }

        @Override
        public String simpleString() {
            return "double";
        }
    }

    public static class FloatType
    extends Type.FractionType {
        private static final FloatType INSTANCE = new FloatType();

        public static FloatType get() {
            return INSTANCE;
        }

        private FloatType() {
        }

        @Override
        public Type.Name name() {
            return Type.Name.FLOAT;
        }

        @Override
        public String simpleString() {
            return "float";
        }
    }

    public static class ShortType
    extends Type.IntegralType {
        private static final ShortType INSTANCE = new ShortType(true);
        private static final ShortType UNSIGNED_INSTANCE = new ShortType(false);

        public static ShortType unsigned() {
            return UNSIGNED_INSTANCE;
        }

        public static ShortType get() {
            return INSTANCE;
        }

        private ShortType(boolean signed) {
            super(signed);
        }

        @Override
        public Type.Name name() {
            return Type.Name.SHORT;
        }

        @Override
        public String simpleString() {
            return this.signed() ? "short" : "short unsigned";
        }
    }

    public static class ByteType
    extends Type.IntegralType {
        private static final ByteType INSTANCE = new ByteType(true);
        private static final ByteType UNSIGNED_INSTANCE = new ByteType(false);

        public static ByteType unsigned() {
            return UNSIGNED_INSTANCE;
        }

        public static ByteType get() {
            return INSTANCE;
        }

        private ByteType(boolean signed) {
            super(signed);
        }

        @Override
        public Type.Name name() {
            return Type.Name.BYTE;
        }

        @Override
        public String simpleString() {
            return this.signed() ? "byte" : "byte unsigned";
        }
    }

    public static class BooleanType
    extends Type.PrimitiveType {
        private static final BooleanType INSTANCE = new BooleanType();

        public static BooleanType get() {
            return INSTANCE;
        }

        private BooleanType() {
        }

        @Override
        public Type.Name name() {
            return Type.Name.BOOLEAN;
        }

        @Override
        public String simpleString() {
            return "boolean";
        }
    }

    public static class NullType
    implements Type {
        private static final NullType INSTANCE = new NullType();

        public static NullType get() {
            return INSTANCE;
        }

        private NullType() {
        }

        @Override
        public Type.Name name() {
            return Type.Name.NULL;
        }

        @Override
        public String simpleString() {
            return "null";
        }
    }
}

