/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.math.BigDecimal;
import java.math.BigInteger;
import ognl.ASTProperty;
import ognl.ExpressionNode;
import ognl.Node;
import ognl.NodeType;
import ognl.NumericExpression;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.enhance.UnsupportedCompilationException;

public class ASTConst
extends SimpleNode
implements NodeType {
    private static final long serialVersionUID = 6025967712275552286L;
    private Object value;
    private Class<?> getterClass;

    public ASTConst(int id) {
        super(id);
    }

    public ASTConst(OgnlParser p, int id) {
        super(p, id);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        return this.value;
    }

    @Override
    public boolean isNodeConstant(OgnlContext context) throws OgnlException {
        return true;
    }

    @Override
    public Class<?> getGetterClass() {
        if (this.getterClass == null) {
            return null;
        }
        return this.getterClass;
    }

    @Override
    public Class<?> getSetterClass() {
        return null;
    }

    @Override
    public String toString() {
        String result;
        if (this.value == null) {
            result = "null";
        } else if (this.value instanceof String) {
            result = '\"' + OgnlOps.getEscapeString(this.value.toString()) + '\"';
        } else if (this.value instanceof Character) {
            result = '\'' + OgnlOps.getEscapedChar(((Character)this.value).charValue()) + '\'';
        } else {
            result = this.value.toString();
            if (this.value instanceof Long) {
                result = result + "L";
            } else if (this.value instanceof BigDecimal) {
                result = result + "B";
            } else if (this.value instanceof BigInteger) {
                result = result + "H";
            } else if (this.value instanceof Node) {
                result = ":[ " + result + " ]";
            }
        }
        return result;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        if (this.value == null && this.parent instanceof ExpressionNode) {
            context.setCurrentType(null);
            return "null";
        }
        if (this.value == null) {
            context.setCurrentType(null);
            return "";
        }
        this.getterClass = this.value.getClass();
        if (this.parent instanceof ASTProperty) {
            context.setCurrentObject(this.value);
            return this.value.toString();
        }
        if (Number.class.isAssignableFrom(this.value.getClass())) {
            context.setCurrentType(OgnlRuntime.getPrimitiveWrapperClass(this.value.getClass()));
            context.setCurrentObject(this.value);
            return this.value.toString();
        }
        if ((this.parent == null || !NumericExpression.class.isAssignableFrom(this.parent.getClass())) && String.class.isAssignableFrom(this.value.getClass())) {
            context.setCurrentType(String.class);
            String retval = '\"' + OgnlOps.getEscapeString(this.value.toString()) + '\"';
            context.setCurrentObject(retval.toString());
            return retval.toString();
        }
        if (this.value instanceof Character) {
            Character val = (Character)this.value;
            context.setCurrentType(Character.class);
            String retval = Character.isLetterOrDigit(val.charValue()) ? "'" + this.value + "'" : "'" + OgnlOps.getEscapedChar(((Character)this.value).charValue()) + "'";
            context.setCurrentObject(retval);
            return retval.toString();
        }
        if (Boolean.class.isAssignableFrom(this.value.getClass())) {
            this.getterClass = Boolean.TYPE;
            context.setCurrentType(Boolean.TYPE);
            context.setCurrentObject(this.value);
            return this.value.toString();
        }
        return this.value.toString();
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        if (this.parent == null) {
            throw new UnsupportedCompilationException("Can't modify constant values.");
        }
        return this.toGetSourceString(context, target);
    }
}

