/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.exception.CompareNotSupportedException;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.Sequence;
import java.util.Map;

public abstract class AbstractSeqMinMaxFunction
extends AbstractFunction {
    private static final long serialVersionUID = 1236238221132010289L;

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        Object first = arg1.getValue(env);
        if (first == null) {
            return AviatorNil.NIL;
        }
        Sequence seq = RuntimeUtils.seq(first, env);
        boolean wasFirst = true;
        Object result = null;
        for (Object obj : seq) {
            result = this.compareObjects(result, obj, wasFirst);
            if (wasFirst) {
                wasFirst = false;
            }
            if (this.getOp() != Op.Min || result != null) continue;
            break;
        }
        return AviatorRuntimeJavaType.valueOf(result);
    }

    protected abstract Op getOp();

    private Object compareObjects(Object result, Object obj, boolean wasFirst) {
        if (obj == null) {
            switch (this.getOp()) {
                case Min: {
                    return obj;
                }
                case Max: {
                    return result;
                }
            }
        }
        if (!(obj instanceof Comparable)) {
            throw new CompareNotSupportedException("Element in sequence doesn't implement java.lang.Comparable.");
        }
        if (wasFirst || this.compare(result, obj)) {
            result = obj;
        }
        return result;
    }

    private boolean compare(Object result, Object obj) {
        try {
            int c = ((Comparable)obj).compareTo(result);
            switch (this.getOp()) {
                case Min: {
                    return c < 0;
                }
                case Max: {
                    return c > 0;
                }
            }
            return false;
        }
        catch (ClassCastException e) {
            throw new CompareNotSupportedException("Could not compare `" + obj + "` with `" + result + "`", e);
        }
    }

    static enum Op {
        Min,
        Max;

    }
}

