/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.internal;

import com.googlecode.aviator.runtime.function.AbstractVariadicFunction;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.Reflector;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Map;

public class NewInstanceFunction
extends AbstractVariadicFunction {
    private static final long serialVersionUID = -2257891325568093945L;
    public static final NewInstanceFunction INSTANCE = new NewInstanceFunction();

    private NewInstanceFunction() {
    }

    @Override
    public String getName() {
        return "__new";
    }

    @Override
    public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Missing className for new");
        }
        AviatorObject firstArg = args[0];
        if (firstArg.getAviatorType() != AviatorType.JavaType) {
            throw new IllegalArgumentException("Invalid class name: " + firstArg.desc(env));
        }
        String className = ((AviatorJavaType)firstArg).getName();
        try {
            assert (env instanceof Env);
            Class<?> clazz = ((Env)env).resolveClassSymbol(className);
            Constructor<?>[] constructors = clazz.getConstructors();
            Object[] constructArgs = new Object[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                constructArgs[i - 1] = args[i].getValue(env);
            }
            Constructor<?> bestMatch = null;
            for (Constructor<?> constructor : constructors) {
                Class<?>[] pTypes = constructor.getParameterTypes();
                if (pTypes.length != constructArgs.length || !Reflector.isCongruent(pTypes, constructArgs)) continue;
                bestMatch = constructor;
                for (int i = 0; i < constructArgs.length; ++i) {
                    constructArgs[i] = Reflector.boxArg(pTypes[i], constructArgs[i]);
                }
                break;
            }
            if (bestMatch == null) {
                throw new IllegalStateException("Could not find constructor for class " + className + " with arguments: " + Arrays.toString(constructArgs));
            }
            return AviatorRuntimeJavaType.valueOf(bestMatch.newInstance(constructArgs));
        }
        catch (Throwable t) {
            throw Reflector.sneakyThrow(t);
        }
    }
}

