/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.EOFException;
import java.io.IOException;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import org.apache.paimon.shade.it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import org.apache.paimon.utils.IntIterator;

public class IntFileUtils {
    public static IntIterator readInts(FileIO fileIO, Path path) throws IOException {
        final FastBufferedInputStream in = new FastBufferedInputStream(fileIO.newInputStream(path));
        return new IntIterator(){

            @Override
            public int next() throws IOException {
                return IntFileUtils.readInt(in);
            }

            @Override
            public void close() throws IOException {
                in.close();
            }
        };
    }

    public static void writeInts(FileIO fileIO, Path path, IntIterator input) throws IOException {
        try (FastBufferedOutputStream out = new FastBufferedOutputStream(fileIO.newOutputStream(path, false));){
            IntIterator iterator = input;
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        IntFileUtils.writeInt(out, iterator.next());
                    }
                }
                catch (EOFException ignored) {
                    if (iterator != null) {
                        if (throwable != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            iterator.close();
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (iterator != null) {
                        if (throwable != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            iterator.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
    }

    private static int readInt(FastBufferedInputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    private static void writeInt(FastBufferedOutputStream out, int v) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v & 0xFF);
    }
}

