/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import javax.annotation.Nullable;
import org.apache.paimon.compression.AirCompressorFactory;
import org.apache.paimon.compression.BlockCompressionType;
import org.apache.paimon.compression.BlockCompressor;
import org.apache.paimon.compression.BlockDecompressor;
import org.apache.paimon.compression.CompressOptions;
import org.apache.paimon.compression.Lz4BlockCompressionFactory;
import org.apache.paimon.compression.ZstdBlockCompressionFactory;
import org.apache.paimon.shade.io.airlift.compress.Compressor;
import org.apache.paimon.shade.io.airlift.compress.Decompressor;
import org.apache.paimon.shade.io.airlift.compress.lzo.LzoCompressor;
import org.apache.paimon.shade.io.airlift.compress.lzo.LzoDecompressor;

public interface BlockCompressionFactory {
    public BlockCompressionType getCompressionType();

    public BlockCompressor getCompressor();

    public BlockDecompressor getDecompressor();

    @Nullable
    public static BlockCompressionFactory create(CompressOptions compression) {
        switch (compression.compress().toUpperCase()) {
            case "NONE": {
                return null;
            }
            case "ZSTD": {
                return new ZstdBlockCompressionFactory(compression.zstdLevel());
            }
            case "LZ4": {
                return new Lz4BlockCompressionFactory();
            }
            case "LZO": {
                return new AirCompressorFactory(BlockCompressionType.LZO, (Compressor)new LzoCompressor(), (Decompressor)new LzoDecompressor());
            }
        }
        throw new IllegalStateException("Unknown CompressionMethod " + compression);
    }

    @Nullable
    public static BlockCompressionFactory create(BlockCompressionType compression) {
        switch (compression) {
            case NONE: {
                return null;
            }
            case ZSTD: {
                return new ZstdBlockCompressionFactory(1);
            }
            case LZ4: {
                return new Lz4BlockCompressionFactory();
            }
            case LZO: {
                return new AirCompressorFactory(BlockCompressionType.LZO, (Compressor)new LzoCompressor(), (Decompressor)new LzoDecompressor());
            }
        }
        throw new IllegalStateException("Unknown CompressionMethod " + (Object)((Object)compression));
    }
}

