/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.junit.Assert;

public class AsyncOps {

    public static class VoidCB
    extends AsyncCB
    implements AsyncCallback.VoidCallback {
        int version = 0;

        VoidCB(ZooKeeper zk) {
            this(zk, new CountDownLatch(1));
        }

        VoidCB(ZooKeeper zk, CountDownLatch latch) {
            super(zk, latch);
        }

        public void processResult(int rc, String path, Object ctx) {
            super.processResult(KeeperException.Code.get((int)rc), path, ctx);
        }

        public void delete() {
            this.zk.delete(this.path, this.version, (AsyncCallback.VoidCallback)this, (Object)this.toString());
        }

        public void verifyDelete() {
            new StringCB(this.zk).verifyCreate();
            this.delete();
            this.verify();
        }

        public void verifyDeleteFailure_NoNode() {
            this.rc = KeeperException.Code.NONODE;
            this.zk.delete(this.path, this.version, (AsyncCallback.VoidCallback)this, (Object)this.toString());
            this.verify();
        }

        public void verifyDeleteFailure_BadVersion() {
            new StringCB(this.zk).verifyCreate();
            this.rc = KeeperException.Code.BADVERSION;
            this.zk.delete(this.path, this.version + 1, (AsyncCallback.VoidCallback)this, (Object)this.toString());
            this.verify();
        }

        public void verifyDeleteFailure_NotEmpty() {
            StringCB scb = new StringCB(this.zk);
            scb.create();
            scb.setPath(this.path + "/bar");
            scb.create();
            this.rc = KeeperException.Code.NOTEMPTY;
            this.zk.delete(this.path, this.version, (AsyncCallback.VoidCallback)this, (Object)this.toString());
            this.verify();
        }

        public void sync() {
            this.zk.sync(this.path, (AsyncCallback.VoidCallback)this, (Object)this.toString());
        }

        public void verifySync() {
            this.sync();
            this.verify();
        }

        @Override
        public String toString() {
            return super.toString() + this.version;
        }
    }

    public static class StatCB
    extends AsyncCB
    implements AsyncCallback.StatCallback {
        List<ACL> acl = ZooDefs.Ids.CREATOR_ALL_ACL;
        int version = 0;
        Stat stat = new Stat();
        byte[] data = "testing".getBytes();

        StatCB(ZooKeeper zk) {
            this(zk, new CountDownLatch(1));
        }

        StatCB(ZooKeeper zk, CountDownLatch latch) {
            super(zk, latch);
            this.stat.setAversion(0);
            this.stat.setCversion(0);
            this.stat.setEphemeralOwner(0L);
            this.stat.setVersion(0);
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            this.stat = stat;
            super.processResult(KeeperException.Code.get((int)rc), path, ctx);
        }

        public void verifySetACL() {
            this.stat.setAversion(1);
            new StringCB(this.zk).verifyCreate();
            this.zk.setACL(this.path, this.acl, this.version, (AsyncCallback.StatCallback)this, (Object)this.toString());
            this.verify();
        }

        public void verifySetACLFailure_NoNode() {
            this.rc = KeeperException.Code.NONODE;
            this.stat = null;
            this.zk.setACL(this.path, this.acl, this.version, (AsyncCallback.StatCallback)this, (Object)this.toString());
            this.verify();
        }

        public void verifySetACLFailure_BadVersion() {
            new StringCB(this.zk).verifyCreate();
            this.rc = KeeperException.Code.BADVERSION;
            this.stat = null;
            this.zk.setACL(this.path, this.acl, this.version + 1, (AsyncCallback.StatCallback)this, (Object)this.toString());
            this.verify();
        }

        public void setData() {
            this.zk.setData(this.path, this.data, this.version, (AsyncCallback.StatCallback)this, (Object)this.toString());
        }

        public void verifySetData() {
            this.stat.setVersion(1);
            new StringCB(this.zk).verifyCreate();
            this.setData();
            this.verify();
        }

        public void verifySetDataFailure_NoNode() {
            this.rc = KeeperException.Code.NONODE;
            this.stat = null;
            this.zk.setData(this.path, this.data, this.version, (AsyncCallback.StatCallback)this, (Object)this.toString());
            this.verify();
        }

        public void verifySetDataFailure_BadVersion() {
            new StringCB(this.zk).verifyCreate();
            this.rc = KeeperException.Code.BADVERSION;
            this.stat = null;
            this.zk.setData(this.path, this.data, this.version + 1, (AsyncCallback.StatCallback)this, (Object)this.toString());
            this.verify();
        }

        public void verifyExists() {
            new StringCB(this.zk).verifyCreate();
            this.zk.exists(this.path, false, (AsyncCallback.StatCallback)this, (Object)this.toString());
            this.verify();
        }

        public void verifyExistsFailure_NoNode() {
            this.rc = KeeperException.Code.NONODE;
            this.stat = null;
            this.zk.exists(this.path, false, (AsyncCallback.StatCallback)this, (Object)this.toString());
            this.verify();
        }

        @Override
        public String toString() {
            return super.toString() + this.version + ":" + new String(this.data) + ":" + (this.stat == null ? "null" : this.stat.getAversion() + ":" + this.stat.getCversion() + ":" + this.stat.getEphemeralOwner() + ":" + this.stat.getVersion());
        }
    }

    public static class DataCB
    extends AsyncCB
    implements AsyncCallback.DataCallback {
        byte[] data = new byte[10];
        Stat stat = new Stat();

        DataCB(ZooKeeper zk) {
            this(zk, new CountDownLatch(1));
        }

        DataCB(ZooKeeper zk, CountDownLatch latch) {
            super(zk, latch);
            this.stat.setAversion(0);
            this.stat.setCversion(0);
            this.stat.setEphemeralOwner(0L);
            this.stat.setVersion(0);
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            this.data = data;
            this.stat = stat;
            super.processResult(KeeperException.Code.get((int)rc), path, ctx);
        }

        public void verifyGetData() {
            new StringCB(this.zk).verifyCreate();
            this.zk.getData(this.path, false, (AsyncCallback.DataCallback)this, (Object)this.toString());
            this.verify();
        }

        public void verifyGetDataFailure_NoNode() {
            this.rc = KeeperException.Code.NONODE;
            this.data = null;
            this.stat = null;
            this.zk.getData(this.path, false, (AsyncCallback.DataCallback)this, (Object)this.toString());
            this.verify();
        }

        @Override
        public String toString() {
            return super.toString() + ":" + (this.data == null ? "null" : new String(this.data)) + ":" + (this.stat == null ? "null" : this.stat.getAversion() + ":" + this.stat.getCversion() + ":" + this.stat.getEphemeralOwner() + ":" + this.stat.getVersion());
        }
    }

    public static class Children2CB
    extends AsyncCB
    implements AsyncCallback.Children2Callback {
        List<String> children = new ArrayList<String>();

        Children2CB(ZooKeeper zk) {
            this(zk, new CountDownLatch(1));
        }

        Children2CB(ZooKeeper zk, CountDownLatch latch) {
            super(zk, latch);
        }

        public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
            this.children = children == null ? new ArrayList() : children;
            Collections.sort(this.children);
            super.processResult(KeeperException.Code.get((int)rc), path, ctx);
        }

        public StringCB createNode() {
            StringCB parent = new StringCB(this.zk);
            parent.verifyCreate();
            return parent;
        }

        public StringCB createNode(StringCB parent) {
            String childName = "bar";
            return this.createNode(parent, childName);
        }

        public StringCB createNode(StringCB parent, String childName) {
            StringCB child = new StringCB(this.zk);
            child.setPath(parent.path + "/" + childName);
            child.verifyCreate();
            return child;
        }

        public void verifyGetChildrenEmpty() {
            StringCB parent = this.createNode();
            this.path = parent.path;
            this.verify();
        }

        public void verifyGetChildrenSingle() {
            StringCB parent = this.createNode();
            StringCB child = this.createNode(parent);
            this.path = parent.path;
            this.children.add(child.nodeName());
            this.verify();
        }

        public void verifyGetChildrenTwo() {
            StringCB parent = this.createNode();
            StringCB child1 = this.createNode(parent, "child1");
            StringCB child2 = this.createNode(parent, "child2");
            this.path = parent.path;
            this.children.add(child1.nodeName());
            this.children.add(child2.nodeName());
            this.verify();
        }

        public void verifyGetChildrenFailure_NoNode() {
            this.rc = KeeperException.Code.NONODE;
            this.verify();
        }

        @Override
        public void verify() {
            this.zk.getChildren(this.path, false, (AsyncCallback.Children2Callback)this, (Object)this.toString());
            super.verify();
        }

        @Override
        public String toString() {
            return super.toString() + this.children.toString();
        }
    }

    public static class ChildrenCB
    extends AsyncCB
    implements AsyncCallback.ChildrenCallback {
        List<String> children = new ArrayList<String>();

        ChildrenCB(ZooKeeper zk) {
            this(zk, new CountDownLatch(1));
        }

        ChildrenCB(ZooKeeper zk, CountDownLatch latch) {
            super(zk, latch);
        }

        public void processResult(int rc, String path, Object ctx, List<String> children) {
            this.children = children == null ? new ArrayList() : children;
            Collections.sort(this.children);
            super.processResult(KeeperException.Code.get((int)rc), path, ctx);
        }

        public StringCB createNode() {
            StringCB parent = new StringCB(this.zk);
            parent.verifyCreate();
            return parent;
        }

        public StringCB createNode(StringCB parent) {
            String childName = "bar";
            return this.createNode(parent, childName);
        }

        public StringCB createNode(StringCB parent, String childName) {
            StringCB child = new StringCB(this.zk);
            child.setPath(parent.path + "/" + childName);
            child.verifyCreate();
            return child;
        }

        public void verifyGetChildrenEmpty() {
            StringCB parent = this.createNode();
            this.path = parent.path;
            this.verify();
        }

        public void verifyGetChildrenSingle() {
            StringCB parent = this.createNode();
            StringCB child = this.createNode(parent);
            this.path = parent.path;
            this.children.add(child.nodeName());
            this.verify();
        }

        public void verifyGetChildrenTwo() {
            StringCB parent = this.createNode();
            StringCB child1 = this.createNode(parent, "child1");
            StringCB child2 = this.createNode(parent, "child2");
            this.path = parent.path;
            this.children.add(child1.nodeName());
            this.children.add(child2.nodeName());
            this.verify();
        }

        public void verifyGetChildrenFailure_NoNode() {
            this.rc = KeeperException.Code.NONODE;
            this.verify();
        }

        @Override
        public void verify() {
            this.zk.getChildren(this.path, false, (AsyncCallback.ChildrenCallback)this, (Object)this.toString());
            super.verify();
        }

        @Override
        public String toString() {
            return super.toString() + this.children.toString();
        }
    }

    public static class ACLCB
    extends AsyncCB
    implements AsyncCallback.ACLCallback {
        List<ACL> acl = ZooDefs.Ids.CREATOR_ALL_ACL;
        int version = 0;
        Stat stat = new Stat();
        byte[] data = "testing".getBytes();

        ACLCB(ZooKeeper zk) {
            this(zk, new CountDownLatch(1));
        }

        ACLCB(ZooKeeper zk, CountDownLatch latch) {
            super(zk, latch);
            this.stat.setAversion(0);
            this.stat.setCversion(0);
            this.stat.setEphemeralOwner(0L);
            this.stat.setVersion(0);
        }

        public void processResult(int rc, String path, Object ctx, List<ACL> acl, Stat stat) {
            this.acl = acl;
            this.stat = stat;
            super.processResult(KeeperException.Code.get((int)rc), path, ctx);
        }

        public void verifyGetACL() {
            new StringCB(this.zk).verifyCreate();
            this.zk.getACL(this.path, this.stat, (AsyncCallback.ACLCallback)this, (Object)this.toString());
            this.verify();
        }

        public void verifyGetACLFailure_NoNode() {
            this.rc = KeeperException.Code.NONODE;
            this.stat = null;
            this.acl = null;
            this.zk.getACL(this.path, this.stat, (AsyncCallback.ACLCallback)this, (Object)this.toString());
            this.verify();
        }

        public String toString(List<ACL> acls) {
            if (acls == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            for (ACL acl : acls) {
                result.append(acl.getPerms() + "::");
            }
            return result.toString();
        }

        @Override
        public String toString() {
            return super.toString() + this.toString(this.acl) + "::" + this.version + ":" + new String(this.data) + ":" + (this.stat == null ? "null" : this.stat.getAversion() + ":" + this.stat.getCversion() + ":" + this.stat.getEphemeralOwner() + ":" + this.stat.getVersion());
        }
    }

    public static class StringCB
    extends AsyncCB
    implements AsyncCallback.StringCallback {
        byte[] data = new byte[10];
        List<ACL> acl = ZooDefs.Ids.CREATOR_ALL_ACL;
        CreateMode flags = CreateMode.PERSISTENT;
        String name = this.path;

        StringCB(ZooKeeper zk) {
            this(zk, new CountDownLatch(1));
        }

        StringCB(ZooKeeper zk, CountDownLatch latch) {
            super(zk, latch);
        }

        @Override
        public void setPath(String path) {
            super.setPath(path);
            this.name = path;
        }

        public String nodeName() {
            return this.path.substring(this.path.lastIndexOf(47) + 1);
        }

        public void processResult(int rc, String path, Object ctx, String name) {
            this.name = name;
            super.processResult(KeeperException.Code.get((int)rc), path, ctx);
        }

        public AsyncCB create() {
            this.zk.create(this.path, this.data, this.acl, this.flags, (AsyncCallback.StringCallback)this, (Object)this.toString());
            return this;
        }

        public AsyncCB createEphemeral() {
            this.zk.create(this.path, this.data, this.acl, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this, (Object)this.toString());
            return this;
        }

        public void verifyCreate() {
            this.create();
            this.verify();
        }

        public void verifyCreateEphemeral() {
            this.createEphemeral();
            this.verify();
        }

        public void verifyCreateFailure_NodeExists() {
            new StringCB(this.zk).verifyCreate();
            this.rc = KeeperException.Code.NODEEXISTS;
            this.name = null;
            this.zk.create(this.path, this.data, this.acl, this.flags, (AsyncCallback.StringCallback)this, (Object)this.toString());
            this.verify();
        }

        public void verifyCreateFailure_NoNode() {
            this.rc = KeeperException.Code.NONODE;
            this.name = null;
            this.path = this.path + "/bar";
            this.zk.create(this.path, this.data, this.acl, this.flags, (AsyncCallback.StringCallback)this, (Object)this.toString());
            this.verify();
        }

        public void verifyCreateFailure_NoChildForEphemeral() {
            new StringCB(this.zk).verifyCreateEphemeral();
            this.rc = KeeperException.Code.NOCHILDRENFOREPHEMERALS;
            this.name = null;
            this.path = this.path + "/bar";
            this.zk.create(this.path, this.data, this.acl, this.flags, (AsyncCallback.StringCallback)this, (Object)this.toString());
            this.verify();
        }

        @Override
        public String toString() {
            return super.toString() + this.name;
        }
    }

    public static abstract class AsyncCB {
        protected final ZooKeeper zk;
        protected long defaultTimeoutMillis = 30000L;
        CountDownLatch latch;
        KeeperException.Code rc = KeeperException.Code.OK;
        String path = "/foo";
        String expected;

        public AsyncCB(ZooKeeper zk, CountDownLatch latch) {
            this.zk = zk;
            this.latch = latch;
        }

        public void setRC(KeeperException.Code rc) {
            this.rc = rc;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void processResult(KeeperException.Code rc, String path, Object ctx) {
            this.rc = rc;
            this.path = path;
            this.expected = (String)ctx;
            this.latch.countDown();
        }

        public String toString() {
            return this.rc + ":" + this.path + ":";
        }

        protected void verify() {
            try {
                this.latch.await(this.defaultTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"unexpected interrupt");
            }
            Assert.assertSame((Object)0L, (Object)this.latch.getCount());
            String actual = this.toString();
            Assert.assertEquals((Object)this.expected, (Object)actual);
        }
    }
}

