/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.auth;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumAuthTestBase
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(QuorumAuthTestBase.class);
    protected List<QuorumPeerTestBase.MainThread> mt = new ArrayList<QuorumPeerTestBase.MainThread>();
    protected static File jaasConfigDir;

    public static void setupJaasConfig(String jaasEntries) {
        try {
            jaasConfigDir = ClientBase.createTmpDir();
            File saslConfFile = new File(jaasConfigDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write(jaasEntries);
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            LOG.error("Failed to create tmp directory to hold JAAS conf file", (Throwable)ioe);
        }
    }

    public static void cleanupJaasConfig() {
        if (jaasConfigDir != null) {
            FileUtils.deleteQuietly((File)jaasConfigDir);
        }
    }

    protected String startQuorum(int serverCount, Map<String, String> authConfigs, int authServerCount, boolean delayedServerStartup) throws IOException {
        StringBuilder connectStr = new StringBuilder();
        int[] clientPorts = this.startQuorum(serverCount, 0, connectStr, authConfigs, authServerCount, delayedServerStartup);
        for (int i = 0; i < serverCount; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
        }
        return connectStr.toString();
    }

    protected String startQuorum(int serverCount, int observerCount, Map<String, String> authConfigs, int authServerCount) throws IOException {
        StringBuilder connectStr = new StringBuilder();
        int[] clientPorts = this.startQuorum(serverCount, observerCount, connectStr, authConfigs, authServerCount, false);
        for (int i = 0; i < serverCount; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
        }
        return connectStr.toString();
    }

    protected int[] startQuorum(int serverCount, int observerCount, StringBuilder connectStr, Map<String, String> authConfigs, int authServerCount, boolean delayedServerStartup) throws IOException {
        int i;
        int[] clientPorts = new int[serverCount];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < serverCount; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "";
            server = observerCount > 0 && i2 < observerCount ? String.format("server.%d=localhost:%d:%d:observer", i2, PortAssignment.unique(), PortAssignment.unique()) : String.format("server.%d=localhost:%d:%d:participant", i2, PortAssignment.unique(), PortAssignment.unique());
            sb.append(server + "\n");
            connectStr.append("127.0.0.1:" + clientPorts[i2]);
            if (i2 >= serverCount - 1) continue;
            connectStr.append(",");
        }
        String quorumCfg = sb.toString();
        for (i = 0; i < authServerCount; ++i) {
            if (observerCount > 0 && i < observerCount) {
                String obsCfgSection;
                quorumCfg = obsCfgSection = quorumCfg + "\npeerType=observer";
            }
            this.startServer(authConfigs, clientPorts[i], quorumCfg, i, delayedServerStartup);
        }
        int j = 0;
        while (j < serverCount - authServerCount) {
            if (observerCount > 0 && i < observerCount) {
                String obsCfgSection;
                quorumCfg = obsCfgSection = quorumCfg + "\npeerType=observer";
            }
            this.startServer(null, clientPorts[i], quorumCfg, i, delayedServerStartup);
            ++j;
            ++i;
        }
        return clientPorts;
    }

    private void startServer(Map<String, String> authConfigs, int clientPort, String quorumCfg, int i, boolean delayedServerStartup) throws IOException {
        QuorumPeerTestBase.MainThread mthread = authConfigs != null ? new QuorumPeerTestBase.MainThread(i, clientPort, quorumCfg, authConfigs) : new QuorumPeerTestBase.MainThread(i, clientPort, quorumCfg);
        this.mt.add(mthread);
        mthread.start();
        if (delayedServerStartup) {
            this.addDelayBeforeStartingNextServer(mthread);
        }
    }

    private void addDelayBeforeStartingNextServer(QuorumPeerTestBase.MainThread mThread) {
        LOG.info("Waiting to finish login context init(Krb login), as there are potential concurrency issues in ApacheDS if multiple servers starts together!");
        int retries = 60;
        while (retries > 0) {
            if (mThread.getQuorumPeer() != null && mThread.getQuorumPeer().hasAuthInitialized()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.info("Ignore InterruptedException");
                }
                break;
            }
            --retries;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                LOG.info("Ignore InterruptedException");
            }
        }
    }

    protected void startServer(QuorumPeerTestBase.MainThread restartPeer, Map<String, String> authConfigs) throws IOException {
        QuorumPeerTestBase.MainThread mthread = new QuorumPeerTestBase.MainThread(restartPeer.getMyid(), restartPeer.getClientPort(), restartPeer.getQuorumCfgSection(), authConfigs);
        this.mt.add(mthread);
        mthread.start();
    }

    void shutdownAll() {
        for (int i = 0; i < this.mt.size(); ++i) {
            this.shutdown(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QuorumPeerTestBase.MainThread shutdown(int index) {
        QuorumPeerTestBase.MainThread mainThread = this.mt.get(index);
        try {
            mainThread.shutdown();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.mt.remove(index);
        }
        mainThread.deleteBaseDir();
        return mainThread;
    }
}

