/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.auth;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.server.quorum.auth.ApacheDSMiniKdc;
import org.apache.zookeeper.server.quorum.auth.QuorumAuthTestBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class ApacheDSKerberosSecurityTestcase
extends QuorumAuthTestBase {
    private static ApacheDSMiniKdc kdc;
    private static File workDir;
    private static Properties conf;

    @BeforeClass
    public static void setUpSasl() throws Exception {
        ApacheDSKerberosSecurityTestcase.startMiniKdc();
    }

    @AfterClass
    public static void tearDownSasl() throws Exception {
        ApacheDSKerberosSecurityTestcase.stopMiniKdc();
        FileUtils.deleteQuietly((File)workDir);
    }

    public static void startMiniKdc() throws Exception {
        ApacheDSKerberosSecurityTestcase.createTestDir();
        ApacheDSKerberosSecurityTestcase.createMiniKdcConf();
        kdc = new ApacheDSMiniKdc(conf, workDir);
        kdc.start();
    }

    public static void createTestDir() throws IOException {
        workDir = ApacheDSKerberosSecurityTestcase.createTmpDir(new File(System.getProperty("build.test.dir", "build")));
    }

    static File createTmpDir(File parentDir) throws IOException {
        File tmpFile = File.createTempFile("test", ".junit", parentDir);
        File tmpDir = new File(tmpFile + ".dir");
        Assert.assertFalse((boolean)tmpDir.exists());
        Assert.assertTrue((boolean)tmpDir.mkdirs());
        return tmpDir;
    }

    public static void createMiniKdcConf() {
        conf = ApacheDSMiniKdc.createConf();
    }

    public static void stopMiniKdc() {
        if (kdc != null) {
            kdc.stop();
        }
    }

    public static ApacheDSMiniKdc getKdc() {
        return kdc;
    }

    public static File getWorkDir() {
        return workDir;
    }

    public static Properties getConf() {
        return conf;
    }
}

