/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.servlets.MetricsServlet;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.metrics.MetricsSystem;
import org.apache.gravitino.server.authentication.AuthenticationFilter;
import org.apache.gravitino.server.web.CorsFilterHolder;
import org.apache.gravitino.server.web.JettyServerConfig;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServer.class);
    private static final String HTTPS = "https";
    private static final String HTTP_PROTOCOL = "http/1.1";
    private Server server;
    private ServletContextHandler servletContextHandler;
    private JettyServerConfig serverConfig;
    private String serverName;

    public synchronized void initialize(JettyServerConfig serverConfig, String serverName, boolean shouldEnableUI) {
        this.serverConfig = serverConfig;
        this.serverName = serverName;
        ThreadPool threadPool = this.createThreadPool(serverConfig.getMinThreads(), serverConfig.getMaxThreads(), serverConfig.getThreadPoolWorkQueueSize());
        this.server = new Server(threadPool);
        this.server.setStopAtShutdown(true);
        this.server.setStopTimeout(serverConfig.getStopTimeout());
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setServer(this.server);
        this.server.addBean((Object)errorHandler);
        if (serverConfig.isEnableHttps()) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)serverConfig.getKeyStorePath()), (Object)"If enables https, must set keyStorePath");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)serverConfig.getKeyStorePassword()), (Object)"If enables https, must set keyStorePassword");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)serverConfig.getManagerPassword()), (Object)"If enables https, must set managerPassword");
            if (serverConfig.isEnableClientAuth()) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)serverConfig.getTrustStorePath()), (Object)"If enables the authentication of the client, must set trustStorePath");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)serverConfig.getTrustStorePassword()), (Object)"If enables the authentication of the client, must set trustStorePassword");
            }
            ServerConnector httpsConnector = this.createHttpsServerConnector(this.server, serverConfig.getRequestHeaderSize(), serverConfig.getResponseHeaderSize(), serverConfig.getHost(), serverConfig.getHttpsPort(), serverConfig.getIdleTimeout(), serverConfig.getKeyStorePath(), serverConfig.getKeyStorePassword(), serverConfig.getManagerPassword(), serverConfig.getKeyStoreType(), serverConfig.getTlsProtocol(), serverConfig.getSupportedAlgorithms(), serverConfig.isEnableClientAuth(), serverConfig.getTrustStorePath(), serverConfig.getTrustStorePassword(), serverConfig.getTrustStoreType());
            this.server.addConnector((Connector)httpsConnector);
        } else {
            ServerConnector httpConnector = this.createHttpServerConnector(this.server, serverConfig.getRequestHeaderSize(), serverConfig.getResponseHeaderSize(), serverConfig.getHost(), serverConfig.getHttpPort(), serverConfig.getIdleTimeout());
            this.server.addConnector((Connector)httpConnector);
        }
        if (shouldEnableUI) {
            this.initializeWebAppServletContextHandler();
        } else {
            this.initializeBasicServletContextHandler();
        }
        MetricsSystem metricsSystem = GravitinoEnv.getInstance().metricsSystem();
        if (metricsSystem != null) {
            MetricRegistry metricRegistry = metricsSystem.getMetricRegistry();
            this.servletContextHandler.setAttribute("com.codahale.metrics.servlets.MetricsServlet.registry", (Object)metricRegistry);
            this.servletContextHandler.addServlet(MetricsServlet.class, "/metrics");
            this.servletContextHandler.addServlet(new ServletHolder((Servlet)metricsSystem.getPrometheusServlet()), "/prometheus/metrics");
        }
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)this.servletContextHandler);
        this.server.setHandler((Handler)handlers);
    }

    public synchronized void start() throws RuntimeException {
        try {
            this.server.start();
        }
        catch (BindException e) {
            LOG.error("Failed to start {} web server on host {} port {}, which is already in use.", new Object[]{this.serverName, this.serverConfig.getHost(), this.serverConfig.getHttpPort(), e});
            throw new RuntimeException("Failed to start " + this.serverName + " web server.", e);
        }
        catch (Exception e) {
            LOG.error("Failed to start {} web server.", (Object)this.serverName, (Object)e);
            throw new RuntimeException("Failed to start " + this.serverName + " web server.", e);
        }
        if (!this.serverConfig.isEnableHttps()) {
            LOG.warn("Users would better use HTTPS to avoid token data leak.");
        }
        LOG.info("{} web server started on host {} port {}.", new Object[]{this.serverName, this.serverConfig.getHost(), this.getPort()});
    }

    public synchronized void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while {} web server is joining.", (Object)this.serverName);
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void stop() {
        if (this.server != null) {
            try {
                ThreadPool threadPool = this.server.getThreadPool();
                if (threadPool instanceof QueuedThreadPool) {
                    ((QueuedThreadPool)threadPool).setStopTimeout(0L);
                }
                this.server.stop();
                if (threadPool instanceof LifeCycle) {
                    ((LifeCycle)threadPool).stop();
                }
                LOG.info("{} web server stopped on host {} port {}.", new Object[]{this.serverName, this.serverConfig.getHost(), this.getPort()});
            }
            catch (Exception e) {
                LOG.warn("Failed to stop {} web server.", (Object)this.serverName, (Object)e);
            }
            this.server = null;
        }
    }

    public void addServlet(Servlet servlet, String pathSpec) {
        this.servletContextHandler.addServlet(new ServletHolder(servlet), pathSpec);
    }

    public void addFilter(Filter filter, String pathSpec) {
        this.servletContextHandler.addFilter(new FilterHolder(filter), pathSpec, EnumSet.allOf(DispatcherType.class));
    }

    private void initializeBasicServletContextHandler() {
        this.servletContextHandler = new ServletContextHandler();
        this.servletContextHandler.setContextPath("/");
        this.servletContextHandler.addServlet(DefaultServlet.class, "/");
    }

    private void initializeWebAppServletContextHandler() {
        File warFile;
        String warPath;
        this.servletContextHandler = new WebAppContext();
        boolean isUnitTest = System.getenv("GRAVITINO_TEST") != null;
        String string = warPath = System.getenv("GRAVITINO_WAR") != null ? System.getenv("GRAVITINO_WAR") : "";
        if (warPath.isEmpty()) {
            String webPath = String.join((CharSequence)File.separator, System.getenv("GRAVITINO_HOME"), "web");
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(Paths.get(webPath, new String[0]), "gravitino-web-*.war");){
                int warCount = 0;
                for (Path path : paths) {
                    warPath = path.toString();
                    ++warCount;
                }
                if (warCount != 1 && !isUnitTest) {
                    throw new RuntimeException("Found multiple or no war files in the web path : " + webPath);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to find war file in the web path : " + webPath, e);
            }
        }
        if (!(warFile = new File(warPath)).exists()) {
            if (isUnitTest) {
                this.servletContextHandler.setResourceBase("/");
            } else {
                throw new RuntimeException("Gravitino web path not found in " + warPath);
            }
        }
        if (warFile.isDirectory()) {
            this.servletContextHandler.setResourceBase(warFile.getPath());
            this.servletContextHandler.setContextPath("/");
        } else {
            ((WebAppContext)this.servletContextHandler).setWar(warFile.getAbsolutePath());
            ((WebAppContext)this.servletContextHandler).setExtractWAR(false);
            try {
                File warTempDirectory = Files.createTempDirectory("GravitinoWar", new FileAttribute[0]).toFile();
                LOG.info("Gravitino Webapp path: {}", (Object)warTempDirectory.getPath());
                ((WebAppContext)this.servletContextHandler).setTempDirectory(warTempDirectory);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private ServerConnector createHttpServerConnector(Server server, int reqHeaderSize, int respHeaderSize, String host, int port, int idleTimeout) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setRequestHeaderSize(reqHeaderSize);
        httpConfig.setResponseHeaderSize(respHeaderSize);
        httpConfig.setSendServerVersion(true);
        httpConfig.setIdleTimeout((long)idleTimeout);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = this.createServerConnector(server, new ConnectionFactory[]{httpConnectionFactory});
        connector.setHost(host);
        connector.setPort(port);
        connector.setReuseAddress(true);
        return connector;
    }

    private int getPort() {
        if (this.serverConfig.isEnableHttps()) {
            return this.serverConfig.getHttpsPort();
        }
        return this.serverConfig.getHttpPort();
    }

    private ServerConnector createHttpsServerConnector(Server server, int reqHeaderSize, int respHeaderSize, String host, int port, int idleTimeout, String keyStorePath, String keyStorePassword, String keyManagerPassword, String keyStoreType, Optional<String> tlsProtocol, Set<String> supportedAlgorithms, boolean isEnableClientAuth, String trustStorePath, String trustStorePassword, String trustStoreType) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme(HTTPS);
        httpConfig.setRequestHeaderSize(reqHeaderSize);
        httpConfig.setResponseHeaderSize(respHeaderSize);
        httpConfig.setSendServerVersion(true);
        httpConfig.setIdleTimeout((long)idleTimeout);
        httpConfig.setSecurePort(port);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keyStorePath);
        sslContextFactory.setKeyStorePassword(keyStorePassword);
        sslContextFactory.setKeyManagerPassword(keyManagerPassword);
        sslContextFactory.setKeyStoreType(keyStoreType);
        tlsProtocol.ifPresent(arg_0 -> ((SslContextFactory)sslContextFactory).setProtocol(arg_0));
        if (!supportedAlgorithms.isEmpty()) {
            sslContextFactory.setIncludeCipherSuites(supportedAlgorithms.toArray(new String[0]));
        }
        if (isEnableClientAuth) {
            sslContextFactory.setNeedClientAuth(true);
            sslContextFactory.setTrustStorePath(trustStorePath);
            sslContextFactory.setTrustStorePassword(trustStorePassword);
            sslContextFactory.setTrustStoreType(trustStoreType);
        }
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        httpConfig.addCustomizer((HttpConfiguration.Customizer)src);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory((SslContextFactory)sslContextFactory, HTTP_PROTOCOL);
        ServerConnector connector = this.createServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory});
        connector.setHost(host);
        connector.setPort(port);
        connector.setReuseAddress(true);
        return connector;
    }

    private ServerConnector createServerConnector(Server server, ConnectionFactory[] connectionFactories) {
        ScheduledExecutorScheduler serverExecutor = new ScheduledExecutorScheduler(this.serverName + "-webserver-JettyScheduler", true);
        return new ServerConnector(server, null, (Scheduler)serverExecutor, null, -1, -1, connectionFactories);
    }

    private ThreadPool createThreadPool(int minThreads, int maxThreads, int threadPoolWorkQueueSize) {
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreads, minThreads, 60000, new LinkedBlockingQueue(threadPoolWorkQueueSize)){

            public Thread newThread(final Runnable runnable) {
                return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                    @Override
                    public Thread run() {
                        Thread thread = new Thread(runnable);
                        thread.setDaemon(true);
                        thread.setPriority(this.getThreadsPriority());
                        thread.setName(this.getName() + "-" + thread.getId());
                        thread.setUncaughtExceptionHandler((t, throwable) -> LOG.error("{} uncaught exception:", (Object)t.getName(), (Object)throwable));
                        thread.setContextClassLoader(classLoader);
                        return thread;
                    }
                });
            }
        };
        threadPool.setName(this.serverName);
        return threadPool;
    }

    public ThreadPool getThreadPool() {
        return this.server.getThreadPool();
    }

    public void addCustomFilters(String pathSpec) {
        for (String filterName : this.serverConfig.getCustomFilters()) {
            if (StringUtils.isBlank((CharSequence)filterName)) continue;
            FilterHolder filterHolder = new FilterHolder();
            filterHolder.setClassName(filterName);
            for (Map.Entry<String, String> entry : this.serverConfig.getAllWithPrefix(String.format("%s.param.", filterName)).entrySet()) {
                filterHolder.setInitParameter(entry.getKey(), entry.getValue());
            }
            this.servletContextHandler.addFilter(filterHolder, pathSpec, EnumSet.allOf(DispatcherType.class));
        }
    }

    public void addSystemFilters(String pathSpec) {
        if (this.serverConfig.isEnableCorsFilter()) {
            this.servletContextHandler.addFilter(CorsFilterHolder.create(this.serverConfig), pathSpec, EnumSet.allOf(DispatcherType.class));
        }
        this.addFilter(new AuthenticationFilter(), pathSpec);
    }
}

