/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.TableDispatcher;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.DistributionDTO;
import org.apache.gravitino.dto.rel.SortOrderDTO;
import org.apache.gravitino.dto.rel.indexes.IndexDTO;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.dto.requests.TableCreateRequest;
import org.apache.gravitino.dto.requests.TableUpdateRequest;
import org.apache.gravitino.dto.requests.TableUpdatesRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.TableResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.server.authorization.MetadataAuthzHelper;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="metalakes/{metalake}/catalogs/{catalog}/schemas/{schema}/tables")
public class TableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(TableOperations.class);
    private final TableDispatcher dispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public TableOperations(TableDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-table", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nANY_USE_CATALOG && (SCHEMA::OWNER || ANY_USE_SCHEMA)\n", accessMetadataType=MetadataObject.Type.SCHEMA)
    public Response listTables(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema) {
        LOG.info("Received list tables request for schema: {}.{}.{}", new Object[]{metalake, catalog, schema});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                Namespace tableNS = NamespaceUtil.ofTable((String)metalake, (String)catalog, (String)schema);
                NameIdentifier[] idents = this.dispatcher.listTables(tableNS);
                idents = MetadataAuthzHelper.filterByExpression((String)metalake, (String)"ANY(OWNER, METALAKE, CATALOG, SCHEMA, TABLE) ||\nANY_SELECT_TABLE ||\nANY_MODIFY_TABLE\n", (Entity.EntityType)Entity.EntityType.TABLE, (NameIdentifier[])idents);
                Response response = Utils.ok((Object)new EntityListResponse(idents));
                LOG.info("List {} tables under schema: {}.{}.{}", new Object[]{idents.length, metalake, catalog, schema});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTableException(OperationType.LIST, "", schema, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="create-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-table", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA && ANY_CREATE_TABLE", accessMetadataType=MetadataObject.Type.SCHEMA)
    public Response createTable(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, TableCreateRequest request) {
        LOG.info("Received create table request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, request.getName()});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofTable((String)metalake, (String)catalog, (String)schema, (String)request.getName());
                Table table = this.dispatcher.createTable(ident, DTOConverters.fromDTOs((ColumnDTO[])request.getColumns()), request.getComment(), request.getProperties(), DTOConverters.fromDTOs((Partitioning[])request.getPartitioning()), DTOConverters.fromDTO((DistributionDTO)request.getDistribution()), DTOConverters.fromDTOs((SortOrderDTO[])request.getSortOrders()), DTOConverters.fromDTOs((IndexDTO[])request.getIndexes()));
                Response response = Utils.ok((Object)new TableResponse(DTOConverters.toDTO((Table)table)));
                LOG.info("Table created: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, request.getName()});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTableException(OperationType.CREATE, request.getName(), schema, e);
        }
    }

    @GET
    @Path(value="{table}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="load-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-table", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_SELECT_TABLE || ANY_MODIFY_TABLE)\n", accessMetadataType=MetadataObject.Type.TABLE)
    public Response loadTable(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="table") @AuthorizationMetadata(type=Entity.EntityType.TABLE) String table) {
        LOG.info("Received load table request for table: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, table});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                NameIdentifier ident = NameIdentifierUtil.ofTable((String)metalake, (String)catalog, (String)schema, (String)table);
                Table t = this.dispatcher.loadTable(ident);
                Response response = Utils.ok((Object)new TableResponse(DTOConverters.toDTO((Table)t)));
                LOG.info("Table loaded: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, table});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTableException(OperationType.LOAD, table, schema, e);
        }
    }

    @PUT
    @Path(value="{table}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-table", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA && (TABLE::OWNER || ANY_MODIFY_TABLE)\n", accessMetadataType=MetadataObject.Type.TABLE)
    public Response alterTable(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="table") @AuthorizationMetadata(type=Entity.EntityType.TABLE) String table, TableUpdatesRequest request) {
        LOG.info("Received alter table request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, table});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofTable((String)metalake, (String)catalog, (String)schema, (String)table);
                TableChange[] changes = (TableChange[])request.getUpdates().stream().map(TableUpdateRequest::tableChange).toArray(TableChange[]::new);
                Table t = this.dispatcher.alterTable(ident, changes);
                Response response = Utils.ok((Object)new TableResponse(DTOConverters.toDTO((Table)t)));
                LOG.info("Table altered: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, t.name()});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTableException(OperationType.ALTER, table, schema, e);
        }
    }

    @DELETE
    @Path(value="{table}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="drop-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-table", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA  && TABLE::OWNER\n", accessMetadataType=MetadataObject.Type.TABLE)
    public Response dropTable(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="catalog") @AuthorizationMetadata(type=Entity.EntityType.CATALOG) String catalog, @PathParam(value="schema") @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) String schema, @PathParam(value="table") @AuthorizationMetadata(type=Entity.EntityType.TABLE) String table, @QueryParam(value="purge") @DefaultValue(value="false") boolean purge) {
        LOG.info("Received {} table request: {}.{}.{}.{}", new Object[]{purge ? "purge" : "drop", metalake, catalog, schema, table});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                boolean dropped;
                NameIdentifier ident = NameIdentifierUtil.ofTable((String)metalake, (String)catalog, (String)schema, (String)table);
                boolean bl = dropped = purge ? this.dispatcher.purgeTable(ident) : this.dispatcher.dropTable(ident);
                if (!dropped) {
                    LOG.warn("Cannot find to be dropped table {} under schema {}", (Object)table, (Object)schema);
                }
                Response response = Utils.ok((Object)new DropResponse(Boolean.valueOf(dropped)));
                LOG.info("Table {}: {}.{}.{}.{}", new Object[]{purge ? "purge" : "drop", metalake, catalog, schema, table});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTableException(OperationType.DROP, table, schema, e);
        }
    }
}

