/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.dto.requests.PartitionStatisticsDropRequest;
import org.apache.gravitino.dto.requests.PartitionStatisticsUpdateRequest;
import org.apache.gravitino.dto.requests.StatisticsDropRequest;
import org.apache.gravitino.dto.requests.StatisticsUpdateRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.PartitionStatisticsListResponse;
import org.apache.gravitino.dto.responses.StatisticListResponse;
import org.apache.gravitino.dto.stats.PartitionStatisticsDTO;
import org.apache.gravitino.dto.stats.PartitionStatisticsDropDTO;
import org.apache.gravitino.dto.stats.PartitionStatisticsUpdateDTO;
import org.apache.gravitino.dto.stats.StatisticDTO;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.exceptions.IllegalStatisticNameException;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationFullName;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.authorization.annotations.AuthorizationObjectType;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.stats.PartitionRange;
import org.apache.gravitino.stats.PartitionStatisticsModification;
import org.apache.gravitino.stats.Statistic;
import org.apache.gravitino.stats.StatisticDispatcher;
import org.apache.gravitino.stats.StatisticValue;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metalakes/{metalake}/objects/{type}/{fullName}/statistics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class StatisticOperations {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticOperations.class);
    @Context
    private HttpServletRequest httpRequest;
    private final StatisticDispatcher statisticDispatcher;

    @Inject
    public StatisticOperations(StatisticDispatcher statisticDispatcher) {
        this.statisticDispatcher = statisticDispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-stats.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-stats", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_SELECT_TABLE|| ANY_MODIFY_TABLE)", accessMetadataType=MetadataObject.Type.TABLE)
    public Response listStatistics(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName) {
        LOG.info("Received list statistics request for object full name: {} type: {} in the metalake {}", new Object[]{fullName, type, metalake});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                if (object.type() != MetadataObject.Type.TABLE) {
                    throw new UnsupportedOperationException("Listing statistics is only supported for tables now.");
                }
                MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                List statistics = this.statisticDispatcher.listStatistics(metalake, object);
                return Utils.ok((Object)new StatisticListResponse(DTOConverters.toDTOs((Statistic[])statistics.toArray(new Statistic[0]))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleStatisticException(OperationType.LIST, fullName, metalake, e);
        }
    }

    @PUT
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="update-stats.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="update-stats", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_MODIFY_TABLE)", accessMetadataType=MetadataObject.Type.TABLE)
    public Response updateStatistics(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName, StatisticsUpdateRequest request) {
        try {
            LOG.info("Received update statistics request for object full name: {} type: {} in the metalake {}", new Object[]{fullName, type, metalake});
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                if (object.type() != MetadataObject.Type.TABLE) {
                    throw new UnsupportedOperationException("Update statistics is only supported for tables now.");
                }
                HashMap statisticMaps = Maps.newHashMap();
                for (Map.Entry entry : request.getUpdates().entrySet()) {
                    if (!((String)entry.getKey()).startsWith("custom-")) {
                        throw new IllegalStatisticNameException("Statistic name must start with %s , but got: %s", new Object[]{"custom-", entry.getKey()});
                    }
                    statisticMaps.put((String)entry.getKey(), (StatisticValue)entry.getValue());
                }
                MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                this.statisticDispatcher.updateStatistics(metalake, object, (Map)statisticMaps);
                return Utils.ok((Object)new BaseResponse(0));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleStatisticException(OperationType.UPDATE, StringUtils.join(request.getUpdates().keySet(), (String)","), fullName, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="drop-stats.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-stats", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_MODIFY_TABLE)", accessMetadataType=MetadataObject.Type.TABLE)
    public Response dropStatistics(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName, StatisticsDropRequest request) {
        try {
            LOG.info("Received drop statistics request for object full name: {} type: {} in the metalake {}", new Object[]{fullName, type, metalake});
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                if (object.type() != MetadataObject.Type.TABLE) {
                    throw new UnsupportedOperationException("Dropping statistics is only supported for tables now.");
                }
                MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                boolean dropped = this.statisticDispatcher.dropStatistics(metalake, object, (List)Lists.newArrayList((Object[])request.getNames()));
                return Utils.ok((Object)new DropResponse(Boolean.valueOf(dropped)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleStatisticException(OperationType.DROP, StringUtils.join((Object[])request.getNames(), (String)","), fullName, e);
        }
    }

    @GET
    @Path(value="/partitions")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-partition-stats.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-partition-stats", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_SELECT_TABLE|| ANY_MODIFY_TABLE)", accessMetadataType=MetadataObject.Type.TABLE)
    public Response listPartitionStatistics(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName, @QueryParam(value="from") String fromPartitionName, @QueryParam(value="to") String toPartitionName, @QueryParam(value="fromInclusive") @DefaultValue(value="true") boolean fromInclusive, @QueryParam(value="toInclusive") @DefaultValue(value="false") boolean toInclusive) {
        String formattedFromPartitionName = StatisticOperations.getFormattedFromPartitionName(fromPartitionName, fromInclusive);
        String formattedToPartitionName = StatisticOperations.getFormattedToPartitionName(toPartitionName, toInclusive);
        LOG.info("Listing partition statistics for table: {} in the metalake {} from {} to {}", new Object[]{fullName, metalake, formattedFromPartitionName, formattedToPartitionName});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                if (object.type() != MetadataObject.Type.TABLE) {
                    throw new UnsupportedOperationException("Listing partition statistics is only supported for tables now.");
                }
                MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                PartitionRange.BoundType fromBoundType = StatisticOperations.getFromBoundType(fromInclusive);
                PartitionRange.BoundType toBoundType = StatisticOperations.getFromBoundType(toInclusive);
                PartitionRange range = fromPartitionName == null && toPartitionName == null ? PartitionRange.ALL_PARTITIONS : (fromPartitionName != null && toPartitionName != null ? PartitionRange.between((String)fromPartitionName, (PartitionRange.BoundType)fromBoundType, (String)toPartitionName, (PartitionRange.BoundType)toBoundType) : (fromPartitionName != null ? PartitionRange.downTo((String)fromPartitionName, (PartitionRange.BoundType)fromBoundType) : PartitionRange.upTo((String)toPartitionName, (PartitionRange.BoundType)toBoundType)));
                List statistics = this.statisticDispatcher.listPartitionStatistics(metalake, object, range);
                PartitionStatisticsDTO[] partitionStatistics = (PartitionStatisticsDTO[])statistics.stream().map(partitionStatistic -> PartitionStatisticsDTO.of((String)partitionStatistic.partitionName(), (StatisticDTO[])DTOConverters.toDTOs((Statistic[])partitionStatistic.statistics()))).toArray(PartitionStatisticsDTO[]::new);
                return Utils.ok((Object)new PartitionStatisticsListResponse(partitionStatistics));
            });
        }
        catch (Exception e) {
            LOG.error("Error listing {},{} partition statistics for table: {} in the metalake {}.", new Object[]{formattedFromPartitionName, formattedToPartitionName, fullName, metalake, e});
            return ExceptionHandlers.handlePartitionStatsException(OperationType.LIST, formattedFromPartitionName + "," + formattedToPartitionName, fullName, e);
        }
    }

    @PUT
    @Path(value="/partitions")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="update-partitions-stats.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="update-partitions-stats", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_MODIFY_TABLE)", accessMetadataType=MetadataObject.Type.TABLE)
    public Response updatePartitionStatistics(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName, PartitionStatisticsUpdateRequest request) {
        LOG.info("Updating partition statistics for table: {} in the metalake {}", (Object)fullName, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                if (object.type() != MetadataObject.Type.TABLE) {
                    throw new UnsupportedOperationException("Updating partition statistics is only supported for tables now.");
                }
                List updates = request.getUpdates();
                for (PartitionStatisticsUpdateDTO update2 : updates) {
                    update2.statistics().keySet().forEach(statistic -> {
                        if (!statistic.startsWith("custom-")) {
                            throw new IllegalStatisticNameException("Statistic name must start with %s, but got: %s", new Object[]{"custom-", statistic});
                        }
                    });
                }
                MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                this.statisticDispatcher.updatePartitionStatistics(metalake, object, updates.stream().map(update -> PartitionStatisticsModification.update((String)update.partitionName(), (Map)update.statistics())).collect(Collectors.toList()));
                return Utils.ok((Object)new BaseResponse(0));
            });
        }
        catch (Exception e) {
            LOG.error("Error updating partition statistics for table: {} in the metalake {}", new Object[]{fullName, metalake, e});
            String partitions = StringUtils.joinWith((String)",", (Object[])new Object[]{request.getUpdates().stream().map(PartitionStatisticsUpdateDTO::partitionName).collect(Collectors.toList())});
            return ExceptionHandlers.handlePartitionStatsException(OperationType.UPDATE, partitions, fullName, e);
        }
    }

    @POST
    @Path(value="/partitions")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="drop-partitions-stats.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-partitions-stats", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_MODIFY_TABLE)", accessMetadataType=MetadataObject.Type.TABLE)
    public Response dropPartitionStatistics(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="type") @AuthorizationObjectType String type, @PathParam(value="fullName") @AuthorizationFullName String fullName, PartitionStatisticsDropRequest request) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                if (object.type() != MetadataObject.Type.TABLE) {
                    throw new UnsupportedOperationException("Dropping partition statistics is only supported for tables now.");
                }
                MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                return Utils.ok((Object)new DropResponse(Boolean.valueOf(this.statisticDispatcher.dropPartitionStatistics(metalake, object, request.getDrops().stream().map(drop -> PartitionStatisticsModification.drop((String)drop.partitionName(), (List)drop.statisticNames())).collect(Collectors.toList())))));
            });
        }
        catch (Exception e) {
            LOG.error("Error dropping partition statistics for table: {} in the metalake {}.", new Object[]{fullName, metalake, e});
            String partitions = StringUtils.joinWith((String)",", (Object[])new Object[]{request.getDrops().stream().map(PartitionStatisticsDropDTO::partitionName).collect(Collectors.toList())});
            return ExceptionHandlers.handlePartitionStatsException(OperationType.DROP, partitions, fullName, e);
        }
    }

    @VisibleForTesting
    static PartitionRange.BoundType getFromBoundType(boolean inclusive) {
        return inclusive ? PartitionRange.BoundType.CLOSED : PartitionRange.BoundType.OPEN;
    }

    private static String getFormattedFromPartitionName(String fromPartitionName, boolean fromInclusive) {
        if (fromPartitionName == null) {
            return "(-INF";
        }
        if (fromInclusive) {
            return "[" + fromPartitionName;
        }
        return "(" + fromPartitionName;
    }

    private static String getFormattedToPartitionName(String toPartitionName, boolean toInclusive) {
        if (toPartitionName == null) {
            return "INF)";
        }
        if (toInclusive) {
            return toPartitionName + "]";
        }
        return toPartitionName + ")";
    }
}

