/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.dto.job.JobDTO;
import org.apache.gravitino.dto.job.JobTemplateDTO;
import org.apache.gravitino.dto.job.ShellJobTemplateDTO;
import org.apache.gravitino.dto.job.SparkJobTemplateDTO;
import org.apache.gravitino.dto.requests.JobRunRequest;
import org.apache.gravitino.dto.requests.JobTemplateRegisterRequest;
import org.apache.gravitino.dto.requests.JobTemplateUpdateRequest;
import org.apache.gravitino.dto.requests.JobTemplateUpdatesRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.JobListResponse;
import org.apache.gravitino.dto.responses.JobResponse;
import org.apache.gravitino.dto.responses.JobTemplateListResponse;
import org.apache.gravitino.dto.responses.JobTemplateResponse;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.job.JobOperationDispatcher;
import org.apache.gravitino.job.JobTemplate;
import org.apache.gravitino.job.JobTemplateChange;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.JobEntity;
import org.apache.gravitino.meta.JobTemplateEntity;
import org.apache.gravitino.server.authorization.MetadataAuthzHelper;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.authorization.annotations.AuthorizationRequest;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="metalakes/{metalake}/jobs")
public class JobOperations {
    private static final Logger LOG = LoggerFactory.getLogger(JobOperations.class);
    private final JobOperationDispatcher jobOperationDispatcher;
    @Context
    HttpServletRequest httpRequest;

    @Inject
    public JobOperations(JobOperationDispatcher jobOperationDispatcher) {
        this.jobOperationDispatcher = jobOperationDispatcher;
    }

    @GET
    @Path(value="templates")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-job-templates.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-job-templates", absolute=true)
    @AuthorizationExpression(expression="")
    public Response listJobTemplates(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @QueryParam(value="details") @DefaultValue(value="false") boolean details) {
        LOG.info("Received request to list job templates in metalake: {}, details: {}", (Object)metalake, (Object)details);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                ArrayList jobTemplateEntities = Lists.newArrayList((Object[])((JobTemplateEntity[])MetadataAuthzHelper.filterByExpression((String)metalake, (String)"METALAKE::OWNER || JOB_TEMPLATE::OWNER || ANY_USE_JOB_TEMPLATE", (Entity.EntityType)Entity.EntityType.JOB_TEMPLATE, (Object[])this.jobOperationDispatcher.listJobTemplates(metalake).toArray(new JobTemplateEntity[0]), jobTemplateEntity -> NameIdentifierUtil.ofJobTemplate((String)metalake, (String)jobTemplateEntity.name()))));
                List<JobTemplateDTO> jobTemplates = JobOperations.toJobTemplateDTOs(jobTemplateEntities);
                if (details) {
                    LOG.info("List {} job templates in metalake: {}", (Object)jobTemplates.size(), (Object)metalake);
                    return Utils.ok((Object)new JobTemplateListResponse(jobTemplates));
                }
                String[] jobTemplateNames = (String[])jobTemplates.stream().map(JobTemplateDTO::name).toArray(String[]::new);
                LOG.info("List {} job template names in metalake: {}", (Object)jobTemplateNames.length, (Object)metalake);
                return Utils.ok((Object)new NameListResponse(jobTemplateNames));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleJobTemplateException(OperationType.LIST, "", metalake, e);
        }
    }

    @POST
    @Path(value="templates")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="register-job-template.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="register-job-template", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || METALAKE::REGISTER_JOB_TEMPLATE")
    public Response registerJobTemplate(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, JobTemplateRegisterRequest request) {
        LOG.info("Received request to register job template {} in metalake: {}", (Object)request.getJobTemplate().name(), (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                this.jobOperationDispatcher.registerJobTemplate(metalake, JobOperations.toEntity(metalake, request.getJobTemplate()));
                LOG.info("Registered job template {} in metalake: {}", (Object)request.getJobTemplate().name(), (Object)metalake);
                return Utils.ok((Object)new BaseResponse());
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleJobTemplateException(OperationType.REGISTER, request.getJobTemplate().name(), metalake, e);
        }
    }

    @GET
    @Path(value="templates/{name}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-job-template.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-job-template", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || JOB_TEMPLATE::OWNER || ANY_USE_JOB_TEMPLATE")
    public Response getJobTemplate(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="name") @AuthorizationMetadata(type=Entity.EntityType.JOB_TEMPLATE) String name) {
        LOG.info("Received request to get job template: {} in metalake: {}", (Object)name, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                JobTemplateEntity jobTemplateEntity = this.jobOperationDispatcher.getJobTemplate(metalake, name);
                LOG.info("Retrieved job template {} in metalake: {}", (Object)name, (Object)metalake);
                return Utils.ok((Object)new JobTemplateResponse(JobOperations.toDTO(jobTemplateEntity)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleJobTemplateException(OperationType.GET, name, metalake, e);
        }
    }

    @DELETE
    @Path(value="templates/{name}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="delete-job-template.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="delete-job-template", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || JOB_TEMPLATE::OWNER")
    public Response deleteJobTemplate(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="name") @AuthorizationMetadata(type=Entity.EntityType.JOB_TEMPLATE) String name) {
        LOG.info("Received request to delete job template: {} in metalake: {}", (Object)name, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                boolean deleted = this.jobOperationDispatcher.deleteJobTemplate(metalake, name);
                if (!deleted) {
                    LOG.warn("Cannot find job template {} in metalake {}", (Object)name, (Object)metalake);
                } else {
                    LOG.info("Deleted job template {} in metalake {}", (Object)name, (Object)metalake);
                }
                return Utils.ok((Object)new DropResponse(Boolean.valueOf(deleted)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleJobTemplateException(OperationType.DELETE, name, metalake, e);
        }
    }

    @PUT
    @Path(value="templates/{name}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-job-template.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-job-template", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || JOB_TEMPLATE::OWNER")
    public Response alterJobTemplate(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="name") @AuthorizationMetadata(type=Entity.EntityType.JOB_TEMPLATE) String jobTemplateName, JobTemplateUpdatesRequest request) {
        LOG.info("Received request to alter job template: {} in metalake: {}", (Object)jobTemplateName, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                JobTemplateChange[] changes = (JobTemplateChange[])request.getUpdates().stream().map(JobTemplateUpdateRequest::jobTemplateChange).toArray(JobTemplateChange[]::new);
                JobTemplateEntity updatedEntity = this.jobOperationDispatcher.alterJobTemplate(metalake, jobTemplateName, changes);
                Response response = Utils.ok((Object)new JobTemplateResponse(JobOperations.toDTO(updatedEntity)));
                LOG.info("Job template {} in metalake {} is altered", (Object)jobTemplateName, (Object)metalake);
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleJobTemplateException(OperationType.ALTER, jobTemplateName, metalake, e);
        }
    }

    @GET
    @Path(value="runs")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-jobs.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-jobs", absolute=true)
    @AuthorizationExpression(expression="")
    public Response listJobs(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @QueryParam(value="jobTemplateName") String jobTemplateName) {
        LOG.info("Received request to list jobs in metalake {}{}", (Object)metalake, jobTemplateName != null ? " for job template " + jobTemplateName : "");
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                ArrayList jobEntities = Lists.newArrayList((Object[])((JobEntity[])MetadataAuthzHelper.filterByExpression((String)metalake, (String)"METALAKE::OWNER || JOB::OWNER", (Entity.EntityType)Entity.EntityType.JOB, (Object[])this.jobOperationDispatcher.listJobs(metalake, Optional.ofNullable(jobTemplateName)).toArray(new JobEntity[0]), jobEntity -> NameIdentifierUtil.ofJob((String)metalake, (String)jobEntity.name()))));
                List<JobDTO> jobDTOs = JobOperations.toJobDTOs(jobEntities);
                LOG.info("Listed {} jobs in metalake {}", (Object)jobEntities.size(), (Object)metalake);
                return Utils.ok((Object)new JobListResponse(jobDTOs));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleJobException(OperationType.LIST, "", metalake, e);
        }
    }

    @GET
    @Path(value="runs/{jobId}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-job.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-job", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || JOB::OWNER")
    public Response getJob(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="jobId") @AuthorizationMetadata(type=Entity.EntityType.JOB) String jobId) {
        LOG.info("Received request to get job {} in metalake {}", (Object)jobId, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                JobEntity jobEntity = this.jobOperationDispatcher.getJob(metalake, jobId);
                LOG.info("Retrieved job {} in metalake: {}", (Object)jobId, (Object)metalake);
                return Utils.ok((Object)new JobResponse(JobOperations.toDTO(jobEntity)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleJobException(OperationType.GET, jobId, metalake, e);
        }
    }

    @POST
    @Path(value="runs")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="run-job.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="run-job", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || (METALAKE::RUN_JOB && (ANY_USE_JOB_TEMPLATE || JOB_TEMPLATE::OWNER))")
    public Response runJob(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @AuthorizationRequest(type=AuthorizationRequest.RequestType.RUN_JOB) JobRunRequest request) {
        LOG.info("Received request to run job {} in metalake: {}", (Object)request.getJobTemplateName(), (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                Map jobConf = request.getJobConf() != null ? request.getJobConf() : Collections.emptyMap();
                JobEntity jobEntity = this.jobOperationDispatcher.runJob(metalake, request.getJobTemplateName(), jobConf);
                LOG.info("Run job[{}] {} in metalake: {}", new Object[]{jobEntity.jobTemplateName(), jobEntity.name(), metalake});
                return Utils.ok((Object)new JobResponse(JobOperations.toDTO(jobEntity)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleJobException(OperationType.RUN, "", metalake, e);
        }
    }

    @POST
    @Path(value="runs/{jobId}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="cancel-job.http-request-duration-seconds", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || JOB::OWNER")
    public Response cancelJob(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="jobId") @AuthorizationMetadata(type=Entity.EntityType.JOB) String jobId) {
        LOG.info("Received request to cancel job {} in metalake {}", (Object)jobId, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                JobEntity jobEntity = this.jobOperationDispatcher.cancelJob(metalake, jobId);
                LOG.info("Cancelled job {} in metalake: {}", (Object)jobId, (Object)metalake);
                return Utils.ok((Object)new JobResponse(JobOperations.toDTO(jobEntity)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleJobException(OperationType.CANCEL, jobId, metalake, e);
        }
    }

    private static List<JobTemplateDTO> toJobTemplateDTOs(List<JobTemplateEntity> jobTemplateEntities) {
        return jobTemplateEntities.stream().map(JobOperations::toDTO).collect(Collectors.toList());
    }

    @VisibleForTesting
    static JobTemplateDTO toDTO(JobTemplateEntity jobTemplateEntity) {
        switch (jobTemplateEntity.templateContent().jobType()) {
            case SHELL: {
                return ((ShellJobTemplateDTO.ShellJobTemplateDTOBuilder)((ShellJobTemplateDTO.ShellJobTemplateDTOBuilder)((ShellJobTemplateDTO.ShellJobTemplateDTOBuilder)((ShellJobTemplateDTO.ShellJobTemplateDTOBuilder)((ShellJobTemplateDTO.ShellJobTemplateDTOBuilder)((ShellJobTemplateDTO.ShellJobTemplateDTOBuilder)((ShellJobTemplateDTO.ShellJobTemplateDTOBuilder)((ShellJobTemplateDTO.ShellJobTemplateDTOBuilder)ShellJobTemplateDTO.builder().withName(jobTemplateEntity.name())).withComment(jobTemplateEntity.comment())).withJobType(jobTemplateEntity.templateContent().jobType())).withExecutable(jobTemplateEntity.templateContent().executable())).withArguments(jobTemplateEntity.templateContent().arguments())).withEnvironments(jobTemplateEntity.templateContent().environments())).withCustomFields(jobTemplateEntity.templateContent().customFields())).withScripts(jobTemplateEntity.templateContent().scripts()).withAudit(DTOConverters.toDTO((Audit)jobTemplateEntity.auditInfo()))).build();
            }
            case SPARK: {
                return ((SparkJobTemplateDTO.SparkJobTemplateDTOBuilder)((SparkJobTemplateDTO.SparkJobTemplateDTOBuilder)((SparkJobTemplateDTO.SparkJobTemplateDTOBuilder)((SparkJobTemplateDTO.SparkJobTemplateDTOBuilder)((SparkJobTemplateDTO.SparkJobTemplateDTOBuilder)((SparkJobTemplateDTO.SparkJobTemplateDTOBuilder)((SparkJobTemplateDTO.SparkJobTemplateDTOBuilder)((SparkJobTemplateDTO.SparkJobTemplateDTOBuilder)SparkJobTemplateDTO.builder().withName(jobTemplateEntity.name())).withComment(jobTemplateEntity.comment())).withJobType(jobTemplateEntity.templateContent().jobType())).withExecutable(jobTemplateEntity.templateContent().executable())).withArguments(jobTemplateEntity.templateContent().arguments())).withEnvironments(jobTemplateEntity.templateContent().environments())).withCustomFields(jobTemplateEntity.templateContent().customFields())).withClassName(jobTemplateEntity.templateContent().className()).withJars(jobTemplateEntity.templateContent().jars()).withFiles(jobTemplateEntity.templateContent().files()).withArchives(jobTemplateEntity.templateContent().archives()).withConfigs(jobTemplateEntity.templateContent().configs()).withAudit(DTOConverters.toDTO((Audit)jobTemplateEntity.auditInfo()))).build();
            }
        }
        throw new IllegalArgumentException("Unsupported job template type: " + String.valueOf(jobTemplateEntity.templateContent().jobType()));
    }

    private static JobTemplateEntity toEntity(String metalake, JobTemplateDTO jobTemplateDTO) {
        return JobTemplateEntity.builder().withId(Long.valueOf(GravitinoEnv.getInstance().idGenerator().nextId())).withName(jobTemplateDTO.name()).withNamespace(NamespaceUtil.ofJobTemplate((String)metalake)).withComment(jobTemplateDTO.comment()).withTemplateContent(JobTemplateEntity.TemplateContent.fromJobTemplate((JobTemplate)DTOConverters.fromDTO((JobTemplateDTO)jobTemplateDTO))).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
    }

    @VisibleForTesting
    static JobDTO toDTO(JobEntity jobEntity) {
        return new JobDTO(jobEntity.name(), jobEntity.jobTemplateName(), jobEntity.status(), DTOConverters.toDTO((Audit)jobEntity.auditInfo()));
    }

    private static List<JobDTO> toJobDTOs(List<JobEntity> jobEntities) {
        return jobEntities.stream().map(JobOperations::toDTO).collect(Collectors.toList());
    }
}

