/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.filter.authorization;

import com.google.common.base.Preconditions;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationRequestContext;
import org.apache.gravitino.dto.requests.TagsAssociateRequest;
import org.apache.gravitino.server.authorization.expression.AuthorizationExpressionEvaluator;
import org.apache.gravitino.server.web.filter.ParameterUtil;
import org.apache.gravitino.server.web.filter.authorization.AuthorizationExecutor;
import org.apache.gravitino.server.web.filter.authorization.CommonAuthorizerExecutor;

public class AssociateTagAuthorizationExecutor
extends CommonAuthorizerExecutor
implements AuthorizationExecutor {
    private final Parameter[] parameters;
    private final Object[] args;

    public AssociateTagAuthorizationExecutor(String expression, Parameter[] parameters, Object[] args, Map<Entity.EntityType, NameIdentifier> metadataContext, AuthorizationExpressionEvaluator authorizationExpressionEvaluator, Map<String, Object> pathParams, String entityType) {
        super(expression, metadataContext, authorizationExpressionEvaluator, pathParams, entityType);
        this.parameters = parameters;
        this.args = args;
    }

    @Override
    public boolean execute() throws Exception {
        Object request = ParameterUtil.extractFromParameters(this.parameters, this.args);
        if (request == null) {
            return false;
        }
        AuthorizationRequestContext context = new AuthorizationRequestContext();
        context.setOriginalAuthorizationExpression(this.expression);
        Entity.EntityType targetType = Entity.EntityType.TAG;
        Preconditions.checkArgument((boolean)(request instanceof TagsAssociateRequest), (Object)"Only tag can use AssociateTagAuthorizationExecutor, please contact the administrator.");
        TagsAssociateRequest tagsAssociateRequest = (TagsAssociateRequest)request;
        tagsAssociateRequest.validate();
        return this.authorizeTag(tagsAssociateRequest.getTagsToAdd(), context, targetType) && this.authorizeTag(tagsAssociateRequest.getTagsToRemove(), context, targetType);
    }

    private boolean authorizeTag(String[] tagNames, AuthorizationRequestContext context, Entity.EntityType targetType) {
        if (tagNames == null) {
            return true;
        }
        for (String tagName : tagNames) {
            HashMap<Entity.EntityType, NameIdentifier> currentContext = new HashMap<Entity.EntityType, NameIdentifier>(this.metadataContext);
            ParameterUtil.buildNameIdentifierForBatchAuthorization(currentContext, tagName, targetType);
            boolean authorized = this.authorizationExpressionEvaluator.evaluate(currentContext, this.pathParams, context, Optional.ofNullable(this.entityType));
            if (authorized) continue;
            return false;
        }
        return true;
    }
}

