/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.filter;

import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.server.authorization.MetadataAuthzHelper;
import org.apache.gravitino.server.authorization.annotations.AuthorizationFullName;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.authorization.annotations.AuthorizationObjectType;
import org.apache.gravitino.server.authorization.annotations.AuthorizationRequest;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;

public class ParameterUtil {
    private ParameterUtil() {
    }

    public static AuthorizationRequest.RequestType extractAuthorizationRequestTypeFromParameters(Parameter[] parameters) {
        for (Parameter parameter : parameters) {
            AuthorizationRequest authorizationRequest = parameter.getAnnotation(AuthorizationRequest.class);
            if (authorizationRequest == null) continue;
            return authorizationRequest.type();
        }
        return AuthorizationRequest.RequestType.COMMON;
    }

    public static Object extractFromParameters(Parameter[] parameters, Object[] args) {
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            AuthorizationRequest authorizationBatchTarget = parameter.getAnnotation(AuthorizationRequest.class);
            if (authorizationBatchTarget == null) continue;
            return args[i];
        }
        return null;
    }

    public static Map<Entity.EntityType, NameIdentifier> extractNameIdentifierFromParameters(Parameter[] parameters, Object[] args) {
        HashMap<Entity.EntityType, String> entities = new HashMap<Entity.EntityType, String>();
        HashMap<Entity.EntityType, NameIdentifier> nameIdentifierMap = new HashMap<Entity.EntityType, NameIdentifier>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            AuthorizationMetadata authorizeResource = parameter.getAnnotation(AuthorizationMetadata.class);
            if (authorizeResource == null) continue;
            Entity.EntityType type2 = authorizeResource.type();
            entities.put(type2, String.valueOf(args[i]));
        }
        String metalake = (String)entities.get(Entity.EntityType.METALAKE);
        String catalog = (String)entities.get(Entity.EntityType.CATALOG);
        String schema = (String)entities.get(Entity.EntityType.SCHEMA);
        String table = (String)entities.get(Entity.EntityType.TABLE);
        String topic = (String)entities.get(Entity.EntityType.TOPIC);
        String fileset = (String)entities.get(Entity.EntityType.FILESET);
        String fullName = null;
        String metadataObjectType = null;
        for (int i = 0; i < parameters.length; ++i) {
            AuthorizationObjectType objectType;
            Parameter parameter = parameters[i];
            AuthorizationFullName authorizeFullName = parameter.getAnnotation(AuthorizationFullName.class);
            if (authorizeFullName != null) {
                fullName = String.valueOf(args[i]);
            }
            if ((objectType = parameter.getAnnotation(AuthorizationObjectType.class)) == null) continue;
            metadataObjectType = String.valueOf(args[i]);
        }
        entities.forEach((type, metadata) -> {
            switch (type) {
                case CATALOG: {
                    nameIdentifierMap.put(Entity.EntityType.CATALOG, NameIdentifierUtil.ofCatalog((String)metalake, (String)catalog));
                    break;
                }
                case SCHEMA: {
                    nameIdentifierMap.put(Entity.EntityType.SCHEMA, NameIdentifierUtil.ofSchema((String)metalake, (String)catalog, (String)schema));
                    break;
                }
                case TABLE: {
                    nameIdentifierMap.put(Entity.EntityType.TABLE, NameIdentifierUtil.ofTable((String)metalake, (String)catalog, (String)schema, (String)table));
                    break;
                }
                case TOPIC: {
                    nameIdentifierMap.put(Entity.EntityType.TOPIC, NameIdentifierUtil.ofTopic((String)metalake, (String)catalog, (String)schema, (String)topic));
                    break;
                }
                case FILESET: {
                    nameIdentifierMap.put(Entity.EntityType.FILESET, NameIdentifierUtil.ofFileset((String)metalake, (String)catalog, (String)schema, (String)fileset));
                    break;
                }
                case MODEL: {
                    String model = (String)entities.get(Entity.EntityType.MODEL);
                    nameIdentifierMap.put(Entity.EntityType.MODEL, NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model));
                    break;
                }
                case METALAKE: {
                    nameIdentifierMap.put(Entity.EntityType.METALAKE, NameIdentifierUtil.ofMetalake((String)metalake));
                    break;
                }
                case USER: {
                    nameIdentifierMap.put(Entity.EntityType.USER, NameIdentifierUtil.ofUser((String)metadata, (String)((String)entities.get(Entity.EntityType.USER))));
                    break;
                }
                case GROUP: {
                    nameIdentifierMap.put(Entity.EntityType.GROUP, NameIdentifierUtil.ofGroup((String)metalake, (String)((String)entities.get(Entity.EntityType.GROUP))));
                    break;
                }
                case ROLE: {
                    nameIdentifierMap.put(Entity.EntityType.ROLE, NameIdentifierUtil.ofRole((String)metalake, (String)((String)entities.get(Entity.EntityType.ROLE))));
                    break;
                }
                case TAG: {
                    nameIdentifierMap.put(Entity.EntityType.TAG, NameIdentifierUtil.ofTag((String)metalake, (String)((String)entities.get(Entity.EntityType.TAG))));
                    break;
                }
                case POLICY: {
                    nameIdentifierMap.put(Entity.EntityType.POLICY, NameIdentifierUtil.ofPolicy((String)metalake, (String)((String)entities.get(Entity.EntityType.POLICY))));
                    break;
                }
                case JOB: {
                    nameIdentifierMap.put(Entity.EntityType.JOB, NameIdentifierUtil.ofJob((String)metalake, (String)((String)entities.get(Entity.EntityType.JOB))));
                    break;
                }
                case JOB_TEMPLATE: {
                    nameIdentifierMap.put(Entity.EntityType.JOB_TEMPLATE, NameIdentifierUtil.ofJobTemplate((String)metalake, (String)((String)entities.get(Entity.EntityType.JOB_TEMPLATE))));
                    break;
                }
            }
        });
        if (fullName != null && metadataObjectType != null && metalake != null) {
            MetadataObject.Type type3 = MetadataObject.Type.valueOf((String)metadataObjectType.toUpperCase(Locale.ROOT));
            NameIdentifier nameIdentifier = MetadataObjectUtil.toEntityIdent((String)metalake, (MetadataObject)MetadataObjects.parse((String)fullName, (MetadataObject.Type)type3));
            nameIdentifierMap.putAll(MetadataAuthzHelper.splitMetadataNames((String)metalake, (Entity.EntityType)MetadataObjectUtil.toEntityType((MetadataObject.Type)type3), (NameIdentifier)nameIdentifier));
        }
        return nameIdentifierMap;
    }

    public static String extractMetadataObjectTypeFromParameters(Parameter[] parameters, Object[] args) {
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            AuthorizationObjectType objectType = parameter.getAnnotation(AuthorizationObjectType.class);
            if (objectType == null) continue;
            return String.valueOf(args[i]).toUpperCase();
        }
        return null;
    }

    public static void buildNameIdentifierForBatchAuthorization(Map<Entity.EntityType, NameIdentifier> metadataNames, String name, Entity.EntityType type) {
        NameIdentifier metalake = metadataNames.get(Entity.EntityType.METALAKE);
        if (Objects.requireNonNull(type) == Entity.EntityType.TAG) {
            metadataNames.put(Entity.EntityType.TAG, NameIdentifierUtil.ofTag((String)NameIdentifierUtil.getMetalake((NameIdentifier)metalake), (String)name));
            return;
        }
        if (type == Entity.EntityType.POLICY) {
            metadataNames.put(Entity.EntityType.POLICY, NameIdentifierUtil.ofPolicy((String)NameIdentifierUtil.getMetalake((NameIdentifier)metalake), (String)name));
            return;
        }
        throw new UnsupportedOperationException("Unsupported to build NameIdentifier for batch authorization target");
    }
}

