/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.common.ops;

import org.apache.gravitino.lance.common.config.LanceConfig;
import org.apache.gravitino.lance.common.ops.LanceNamespaceOperations;
import org.apache.gravitino.lance.common.ops.LanceTableOperations;

public abstract class NamespaceWrapper {
    public static final String NAMESPACE_DELIMITER_DEFAULT = "$";
    private final LanceConfig config;
    private volatile boolean initialized = false;
    private LanceNamespaceOperations namespaceOps;
    private LanceTableOperations tableOps;

    public NamespaceWrapper(LanceConfig config) {
        this.config = config;
    }

    protected abstract void initialize();

    protected abstract LanceNamespaceOperations newNamespaceOps();

    protected abstract LanceTableOperations newTableOps();

    public abstract void close() throws Exception;

    public LanceNamespaceOperations asNamespaceOps() {
        this.initIfNeeded();
        return this.namespaceOps;
    }

    public LanceTableOperations asTableOps() {
        this.initIfNeeded();
        return this.tableOps;
    }

    public LanceConfig config() {
        return this.config;
    }

    private void initAll() {
        this.initialize();
        this.namespaceOps = this.newNamespaceOps();
        this.tableOps = this.newTableOps();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() {
        if (!this.initialized) {
            NamespaceWrapper namespaceWrapper = this;
            synchronized (namespaceWrapper) {
                if (!this.initialized) {
                    this.initAll();
                }
            }
        }
    }
}

