/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerRequestExprResolver;
import org.apache.ranger.plugin.util.StringTokenReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ResourceMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceMatcher.class);
    protected final String value;
    protected final RangerRequestExprResolver exprResolver;
    protected StringTokenReplacer tokenReplacer;
    static final int DYNAMIC_EVALUATION_PENALTY = 8;

    ResourceMatcher(String value, Map<String, String> options) {
        this.value = value;
        this.exprResolver = RangerAbstractResourceMatcher.getOptionReplaceReqExpressions(options) && RangerRequestExprResolver.hasExpressions(value) ? new RangerRequestExprResolver(value, null) : null;
    }

    abstract boolean isMatch(String var1, Map<String, Object> var2);

    abstract int getPriority();

    boolean isMatchAny() {
        return this.value != null && this.value.length() == 0;
    }

    boolean getNeedsDynamicEval() {
        return this.exprResolver != null || this.tokenReplacer != null;
    }

    public boolean isMatchAny(Collection<String> resourceValues, Map<String, Object> evalContext) {
        if (resourceValues != null) {
            for (String resourceValue : resourceValues) {
                if (!this.isMatch(resourceValue, evalContext)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.value + ")";
    }

    void setDelimiters(char startDelimiterChar, char endDelimiterChar, char escapeChar, String tokenPrefix) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> setDelimiters(value= " + this.value + ", startDelimiter=" + startDelimiterChar + ", endDelimiter=" + endDelimiterChar + ", escapeChar=" + escapeChar + ", prefix=" + tokenPrefix);
        }
        if (this.exprResolver != null || StringTokenReplacer.hasToken(this.value, startDelimiterChar, endDelimiterChar, escapeChar)) {
            this.tokenReplacer = new StringTokenReplacer(startDelimiterChar, endDelimiterChar, escapeChar, tokenPrefix);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== setDelimiters(value= " + this.value + ", startDelimiter=" + startDelimiterChar + ", endDelimiter=" + endDelimiterChar + ", escapeChar=" + escapeChar + ", prefix=" + tokenPrefix);
        }
    }

    String getExpandedValue(Map<String, Object> evalContext) {
        RangerAccessRequest accessRequest;
        String ret = this.value;
        if (this.exprResolver != null && (accessRequest = RangerAccessRequestUtil.getRequestFromContext(evalContext)) != null) {
            ret = this.exprResolver.resolveExpressions(accessRequest);
        }
        if (this.tokenReplacer != null) {
            ret = this.tokenReplacer.replaceTokens(ret, evalContext);
        }
        return ret;
    }

    public static boolean startsWithAnyChar(String value, String startChars) {
        boolean ret = false;
        if (value != null && value.length() > 0 && startChars != null) {
            ret = StringUtils.contains((String)startChars, (char)value.charAt(0));
        }
        return ret;
    }

    public static class PriorityComparator
    implements Comparator<ResourceMatcher>,
    Serializable {
        @Override
        public int compare(ResourceMatcher me, ResourceMatcher other) {
            return Integer.compare(me.getPriority(), other.getPriority());
        }
    }
}

