/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ProcessTree {
    private static final Log LOG = LogFactory.getLog(ProcessTree.class);
    public static final long DEFAULT_SLEEPTIME_BEFORE_SIGKILL = 5000L;
    private static final int SIGQUIT = 3;
    private static final int SIGTERM = 15;
    private static final int SIGKILL = 9;
    private static final String SIGQUIT_STR = "SIGQUIT";
    private static final String SIGTERM_STR = "SIGTERM";
    private static final String SIGKILL_STR = "SIGKILL";
    public static final boolean isSetsidAvailable = ProcessTree.isSetsidSupported();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSetsidSupported() {
        Shell.ShellCommandExecutor shexec = null;
        boolean setsidSupported = true;
        try {
            String[] args = new String[]{"setsid", "bash", "-c", "echo $$"};
            shexec = new Shell.ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"setsid is not available on this machine. So not using it.");
            setsidSupported = false;
        }
        finally {
            LOG.info((Object)("setsid exited with exit code " + shexec.getExitCode()));
        }
        return setsidSupported;
    }

    public static void destroy(String pid, long sleeptimeBeforeSigkill, boolean isProcessGroup, boolean inBackground) {
        if (isProcessGroup) {
            ProcessTree.destroyProcessGroup(pid, sleeptimeBeforeSigkill, inBackground);
        } else {
            ProcessTree.destroyProcess(pid, sleeptimeBeforeSigkill, inBackground);
        }
    }

    protected static void destroyProcess(String pid, long sleeptimeBeforeSigkill, boolean inBackground) {
        ProcessTree.terminateProcess(pid);
        ProcessTree.sigKill(pid, false, sleeptimeBeforeSigkill, inBackground);
    }

    protected static void destroyProcessGroup(String pgrpId, long sleeptimeBeforeSigkill, boolean inBackground) {
        ProcessTree.terminateProcessGroup(pgrpId);
        ProcessTree.sigKill(pgrpId, true, sleeptimeBeforeSigkill, inBackground);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendSignal(String pid, int signalNum, String signalName) {
        Shell.ShellCommandExecutor shexec = null;
        try {
            String[] args = new String[]{"kill", "-" + signalNum, pid};
            shexec = new Shell.ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error executing shell command " + ioe));
        }
        finally {
            if (pid.startsWith("-")) {
                LOG.info((Object)("Sending signal to all members of process group " + pid + ": " + signalName + ". Exit code " + shexec.getExitCode()));
            } else {
                LOG.info((Object)("Signaling process " + pid + " with " + signalName + ". Exit code " + shexec.getExitCode()));
            }
        }
    }

    private static void maybeSignalProcess(String pid, int signalNum, String signalName, boolean alwaysSignal) {
        if (alwaysSignal || ProcessTree.isAlive(pid)) {
            ProcessTree.sendSignal(pid, signalNum, signalName);
        }
    }

    private static void maybeSignalProcessGroup(String pgrpId, int signalNum, String signalName, boolean alwaysSignal) {
        if (alwaysSignal || ProcessTree.isProcessGroupAlive(pgrpId)) {
            ProcessTree.sendSignal("-" + pgrpId, signalNum, signalName);
        }
    }

    public static void terminateProcess(String pid) {
        ProcessTree.maybeSignalProcess(pid, 15, SIGTERM_STR, true);
    }

    public static void terminateProcessGroup(String pgrpId) {
        ProcessTree.maybeSignalProcessGroup(pgrpId, 15, SIGTERM_STR, true);
    }

    private static void sigKillInCurrentThread(String pid, boolean isProcessGroup, long sleepTimeBeforeSigKill) {
        if (isProcessGroup || ProcessTree.isAlive(pid)) {
            try {
                Thread.sleep(sleepTimeBeforeSigKill);
            }
            catch (InterruptedException i) {
                LOG.warn((Object)"Thread sleep is interrupted.");
            }
            if (isProcessGroup) {
                ProcessTree.killProcessGroup(pid);
            } else {
                ProcessTree.killProcess(pid);
            }
        }
    }

    private static void sigKill(String pid, boolean isProcessGroup, long sleeptimeBeforeSigkill, boolean inBackground) {
        if (inBackground) {
            SigKillThread sigKillThread = new SigKillThread(pid, isProcessGroup, sleeptimeBeforeSigkill);
            sigKillThread.setDaemon(true);
            sigKillThread.start();
        } else {
            ProcessTree.sigKillInCurrentThread(pid, isProcessGroup, sleeptimeBeforeSigkill);
        }
    }

    public static void killProcess(String pid) {
        ProcessTree.maybeSignalProcess(pid, 9, SIGKILL_STR, false);
    }

    public static void sigQuitProcess(String pid) {
        ProcessTree.maybeSignalProcess(pid, 3, SIGQUIT_STR, false);
    }

    public static void killProcessGroup(String pgrpId) {
        ProcessTree.maybeSignalProcessGroup(pgrpId, 9, SIGKILL_STR, false);
    }

    public static void sigQuitProcessGroup(String pgrpId) {
        ProcessTree.maybeSignalProcessGroup(pgrpId, 3, SIGQUIT_STR, false);
    }

    public static boolean isAlive(String pid) {
        Shell.ShellCommandExecutor shexec = null;
        try {
            String[] args = new String[]{"kill", "-0", pid};
            shexec = new Shell.ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (Shell.ExitCodeException ee) {
            return false;
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error executing shell command " + Arrays.toString(shexec.getExecString()) + ioe));
            return false;
        }
        return shexec.getExitCode() == 0;
    }

    public static boolean isProcessGroupAlive(String pgrpId) {
        Shell.ShellCommandExecutor shexec = null;
        try {
            String[] args = new String[]{"kill", "-0", "-" + pgrpId};
            shexec = new Shell.ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (Shell.ExitCodeException ee) {
            return false;
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error executing shell command " + Arrays.toString(shexec.getExecString()) + ioe));
            return false;
        }
        return shexec.getExitCode() == 0;
    }

    static class SigKillThread
    extends Thread {
        private String pid = null;
        private boolean isProcessGroup = false;
        private long sleepTimeBeforeSigKill = 5000L;

        private SigKillThread(String pid, boolean isProcessGroup, long interval) {
            this.pid = pid;
            this.isProcessGroup = isProcessGroup;
            this.setName(this.getClass().getName() + "-" + pid);
            this.sleepTimeBeforeSigKill = interval;
        }

        @Override
        public void run() {
            ProcessTree.sigKillInCurrentThread(this.pid, this.isProcessGroup, this.sleepTimeBeforeSigKill);
        }
    }
}

